/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dag;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.SingleInputOperator;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.operators.base.GroupCombineOperatorBase;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.dag.SingleInputNode;
import org.apache.flink.optimizer.operators.AllGroupCombineProperties;
import org.apache.flink.optimizer.operators.GroupCombineProperties;
import org.apache.flink.optimizer.operators.OperatorDescriptorSingle;

public class GroupCombineNode
extends SingleInputNode {
    private final List<OperatorDescriptorSingle> possibleProperties;

    public GroupCombineNode(GroupCombineOperatorBase<?, ?, ?> operator) {
        super((SingleInputOperator<?, ?, ?>)operator);
        if (this.keys == null) {
            this.setParallelism(1);
        }
        this.possibleProperties = this.initPossibleProperties();
    }

    private List<OperatorDescriptorSingle> initPossibleProperties() {
        Ordering groupOrder = this.getOperator().getGroupOrder();
        if (groupOrder != null && groupOrder.getNumberOfFields() == 0) {
            groupOrder = null;
        }
        OperatorDescriptorSingle props = this.keys == null ? new AllGroupCombineProperties() : new GroupCombineProperties(this.keys, groupOrder);
        return Collections.singletonList(props);
    }

    public GroupCombineOperatorBase<?, ?, ?> getOperator() {
        return (GroupCombineOperatorBase)super.getOperator();
    }

    @Override
    public String getName() {
        return "GroupCombine";
    }

    @Override
    protected List<OperatorDescriptorSingle> getPossibleProperties() {
        return this.possibleProperties;
    }

    @Override
    protected SemanticProperties getSemanticPropertiesForLocalPropertyFiltering() {
        SingleInputSemanticProperties origProps = this.getOperator().getSemanticProperties();
        SingleInputSemanticProperties filteredProps = new SingleInputSemanticProperties();
        FieldSet readSet = origProps.getReadFields(0);
        if (readSet != null) {
            filteredProps.addReadFields(readSet);
        }
        if (this.keys != null) {
            Iterator iterator = this.keys.iterator();
            while (iterator.hasNext()) {
                int f = (Integer)iterator.next();
                FieldSet targets = origProps.getForwardingTargetFields(0, f);
                Iterator iterator2 = targets.iterator();
                while (iterator2.hasNext()) {
                    int t = (Integer)iterator2.next();
                    filteredProps.addForwardedField(f, t);
                }
            }
        }
        return filteredProps;
    }

    @Override
    protected void computeOperatorSpecificDefaultEstimates(DataStatistics statistics) {
    }
}

