/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dag;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.ExecutionMode;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.io.NonParallelInput;
import org.apache.flink.api.common.io.ReplicatingInputFormat;
import org.apache.flink.api.common.io.statistics.BaseStatistics;
import org.apache.flink.api.common.operators.GenericDataSourceBase;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.Optimizer;
import org.apache.flink.optimizer.costs.CostEstimator;
import org.apache.flink.optimizer.costs.Costs;
import org.apache.flink.optimizer.dag.DagConnection;
import org.apache.flink.optimizer.dag.OptimizerNode;
import org.apache.flink.optimizer.dataproperties.GlobalProperties;
import org.apache.flink.optimizer.dataproperties.LocalProperties;
import org.apache.flink.optimizer.plan.PlanNode;
import org.apache.flink.optimizer.plan.SourcePlanNode;
import org.apache.flink.util.Visitable;
import org.apache.flink.util.Visitor;

public class DataSourceNode
extends OptimizerNode {
    private final boolean sequentialInput;
    private final boolean replicatedInput;
    private GlobalProperties gprops;
    private LocalProperties lprops;

    public DataSourceNode(GenericDataSourceBase<?, ?> pactContract) {
        super((Operator<?>)pactContract);
        if (pactContract.getUserCodeWrapper().getUserCodeClass() == null) {
            throw new IllegalArgumentException("Input format has not been set.");
        }
        if (NonParallelInput.class.isAssignableFrom(pactContract.getUserCodeWrapper().getUserCodeClass())) {
            this.setParallelism(1);
            this.sequentialInput = true;
        } else {
            this.sequentialInput = false;
        }
        this.replicatedInput = ReplicatingInputFormat.class.isAssignableFrom(pactContract.getUserCodeWrapper().getUserCodeClass());
        this.gprops = new GlobalProperties();
        this.lprops = new LocalProperties();
        GenericDataSourceBase.SplitDataProperties splitProps = pactContract.getSplitDataProperties();
        if (this.replicatedInput) {
            this.gprops.setFullyReplicated();
            this.lprops = new LocalProperties();
        } else if (splitProps != null) {
            this.setDataPropertiesFromSplitProperties(splitProps);
        }
    }

    public GenericDataSourceBase<?, ?> getOperator() {
        return (GenericDataSourceBase)super.getOperator();
    }

    @Override
    public String getName() {
        return "Data Source";
    }

    @Override
    public void setParallelism(int parallelism) {
        if (!this.sequentialInput) {
            super.setParallelism(parallelism);
        }
    }

    @Override
    public List<DagConnection> getIncomingConnections() {
        return Collections.emptyList();
    }

    @Override
    public void setInput(Map<Operator<?>, OptimizerNode> contractToNode, ExecutionMode defaultDataExchangeMode) {
    }

    @Override
    protected void computeOperatorSpecificDefaultEstimates(DataStatistics statistics) {
        if (statistics != null) {
            BaseStatistics bs;
            String inFormatDescription;
            block14: {
                InputFormat format;
                inFormatDescription = "<unknown>";
                try {
                    format = (InputFormat)this.getOperator().getFormatWrapper().getUserCodeObject();
                    Configuration config = this.getOperator().getParameters();
                    format.configure(config);
                }
                catch (Throwable t) {
                    if (Optimizer.LOG.isWarnEnabled()) {
                        Optimizer.LOG.warn("Could not instantiate InputFormat to obtain statistics. Limited statistics will be available.", t);
                    }
                    return;
                }
                try {
                    inFormatDescription = format.toString();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                String statisticsKey = this.getOperator().getStatisticsKey();
                BaseStatistics cachedStatistics = statistics.getBaseStatistics(statisticsKey);
                bs = null;
                try {
                    bs = format.getStatistics(cachedStatistics);
                }
                catch (Throwable t) {
                    if (!Optimizer.LOG.isWarnEnabled()) break block14;
                    Optimizer.LOG.warn("Error obtaining statistics from input format: " + t.getMessage(), t);
                }
            }
            if (bs != null) {
                long card;
                long len = bs.getTotalInputSize();
                if (len == -1L) {
                    if (Optimizer.LOG.isInfoEnabled()) {
                        Optimizer.LOG.info("Compiler could not determine the size of input '" + inFormatDescription + "'. Using default estimates.");
                    }
                } else if (len >= 0L) {
                    this.estimatedOutputSize = len;
                }
                if ((card = bs.getNumberOfRecords()) != -1L) {
                    this.estimatedNumRecords = card;
                }
            }
        }
    }

    @Override
    public void computeInterestingPropertiesForInputs(CostEstimator estimator) {
    }

    @Override
    public void computeUnclosedBranchStack() {
        this.openBranches = Collections.emptyList();
    }

    @Override
    public List<PlanNode> getAlternativePlans(CostEstimator estimator) {
        Costs costs;
        if (this.cachedPlans != null) {
            return this.cachedPlans;
        }
        SourcePlanNode candidate = new SourcePlanNode(this, "DataSource (" + this.getOperator().getName() + ")", this.gprops, this.lprops);
        if (!this.replicatedInput) {
            candidate.updatePropertiesWithUniqueSets(this.getUniqueFields());
            costs = new Costs();
            if (FileInputFormat.class.isAssignableFrom(this.getOperator().getFormatWrapper().getUserCodeClass()) && this.estimatedOutputSize >= 0L) {
                estimator.addFileInputCost(this.estimatedOutputSize, costs);
            }
            candidate.setCosts(costs);
        } else {
            costs = new Costs();
            InputFormat inputFormat = ((ReplicatingInputFormat)this.getOperator().getFormatWrapper().getUserCodeObject()).getReplicatedInputFormat();
            if (FileInputFormat.class.isAssignableFrom(inputFormat.getClass()) && this.estimatedOutputSize >= 0L) {
                estimator.addFileInputCost(this.estimatedOutputSize * (long)this.getParallelism(), costs);
            }
            candidate.setCosts(costs);
        }
        ArrayList<PlanNode> plans = new ArrayList<PlanNode>(1);
        plans.add(candidate);
        this.cachedPlans = plans;
        return plans;
    }

    @Override
    public SemanticProperties getSemanticProperties() {
        return new SemanticProperties.EmptySemanticProperties();
    }

    @Override
    public void accept(Visitor<OptimizerNode> visitor) {
        if (visitor.preVisit((Visitable)this)) {
            visitor.postVisit((Visitable)this);
        }
    }

    private void setDataPropertiesFromSplitProperties(GenericDataSourceBase.SplitDataProperties splitProps) {
        int[] partitionKeys = splitProps.getSplitPartitionKeys();
        Partitioner partitioner = splitProps.getSplitPartitioner();
        if (partitionKeys != null && partitioner != null) {
            this.gprops.setCustomPartitioned(new FieldList(partitionKeys), partitioner);
        } else if (partitionKeys != null) {
            this.gprops.setAnyPartitioning(new FieldList(partitionKeys));
        }
        int[] groupingKeys = splitProps.getSplitGroupKeys();
        Ordering ordering = splitProps.getSplitOrder();
        if (ordering != null) {
            groupingKeys = ordering.getFieldPositions();
        }
        if (groupingKeys != null && partitionKeys != null) {
            boolean allFieldsIncluded = true;
            for (int i : partitionKeys) {
                boolean fieldIncluded = false;
                for (int j : groupingKeys) {
                    if (i != j) continue;
                    fieldIncluded = true;
                    break;
                }
                if (fieldIncluded) continue;
                allFieldsIncluded = false;
                break;
            }
            this.lprops = allFieldsIncluded ? LocalProperties.forGrouping(new FieldList(groupingKeys)) : new LocalProperties();
        } else {
            this.lprops = new LocalProperties();
        }
    }
}

