/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dag;

import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.base.BulkIterationBase;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.dag.AbstractPartialSolutionNode;
import org.apache.flink.optimizer.dag.BulkIterationNode;
import org.apache.flink.optimizer.dag.OptimizerNode;
import org.apache.flink.optimizer.dataproperties.GlobalProperties;
import org.apache.flink.optimizer.dataproperties.LocalProperties;
import org.apache.flink.optimizer.plan.BulkPartialSolutionPlanNode;
import org.apache.flink.optimizer.plan.Channel;

public class BulkPartialSolutionNode
extends AbstractPartialSolutionNode {
    private final BulkIterationNode iterationNode;

    public BulkPartialSolutionNode(BulkIterationBase.PartialSolutionPlaceHolder<?> psph, BulkIterationNode iterationNode) {
        super((Operator<?>)psph);
        this.iterationNode = iterationNode;
    }

    public void setCandidateProperties(GlobalProperties gProps, LocalProperties lProps, Channel initialInput) {
        if (this.cachedPlans != null) {
            throw new IllegalStateException();
        }
        this.cachedPlans = Collections.singletonList(new BulkPartialSolutionPlanNode(this, "PartialSolution (" + this.getOperator().getName() + ")", gProps, lProps, initialInput));
    }

    public BulkPartialSolutionPlanNode getCurrentPartialSolutionPlanNode() {
        if (this.cachedPlans != null) {
            return (BulkPartialSolutionPlanNode)this.cachedPlans.get(0);
        }
        throw new IllegalStateException();
    }

    @Override
    public BulkIterationNode getIterationNode() {
        return this.iterationNode;
    }

    @Override
    public void computeOutputEstimates(DataStatistics statistics) {
        this.copyEstimates(this.iterationNode.getPredecessorNode());
    }

    public BulkIterationBase.PartialSolutionPlaceHolder<?> getOperator() {
        return (BulkIterationBase.PartialSolutionPlaceHolder)super.getOperator();
    }

    @Override
    public String getName() {
        return "Bulk Partial Solution";
    }

    @Override
    public void computeUnclosedBranchStack() {
        if (this.openBranches != null) {
            return;
        }
        OptimizerNode inputToIteration = this.iterationNode.getPredecessorNode();
        this.addClosedBranches(inputToIteration.closedBranchingNodes);
        List<OptimizerNode.UnclosedBranchDescriptor> fromInput = inputToIteration.getBranchesForParent(this.iterationNode.getIncomingConnection());
        this.openBranches = fromInput == null || fromInput.isEmpty() ? Collections.emptyList() : fromInput;
    }
}

