/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dag;

import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.SingleInputOperator;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.operators.base.PartitionOperatorBase;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.dag.SingleInputNode;
import org.apache.flink.optimizer.dataproperties.GlobalProperties;
import org.apache.flink.optimizer.dataproperties.LocalProperties;
import org.apache.flink.optimizer.dataproperties.RequestedGlobalProperties;
import org.apache.flink.optimizer.dataproperties.RequestedLocalProperties;
import org.apache.flink.optimizer.operators.OperatorDescriptorSingle;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.plan.SingleInputPlanNode;
import org.apache.flink.runtime.operators.DriverStrategy;

public class PartitionNode
extends SingleInputNode {
    private final List<OperatorDescriptorSingle> possibleProperties;

    public PartitionNode(PartitionOperatorBase<?> operator) {
        super((SingleInputOperator<?, ?, ?>)operator);
        PartitionDescriptor descr = new PartitionDescriptor(this.getOperator().getPartitionMethod(), this.keys, operator.getCustomPartitioner());
        this.possibleProperties = Collections.singletonList(descr);
    }

    public PartitionOperatorBase<?> getOperator() {
        return (PartitionOperatorBase)super.getOperator();
    }

    @Override
    public String getOperatorName() {
        return "Partition";
    }

    @Override
    protected List<OperatorDescriptorSingle> getPossibleProperties() {
        return this.possibleProperties;
    }

    @Override
    protected void computeOperatorSpecificDefaultEstimates(DataStatistics statistics) {
        this.estimatedNumRecords = this.getPredecessorNode().getEstimatedNumRecords();
        this.estimatedOutputSize = this.getPredecessorNode().getEstimatedOutputSize();
    }

    @Override
    public SemanticProperties getSemanticProperties() {
        return new SingleInputSemanticProperties.AllFieldsForwardedProperties();
    }

    public static class PartitionDescriptor
    extends OperatorDescriptorSingle {
        private final PartitionOperatorBase.PartitionMethod pMethod;
        private final Partitioner<?> customPartitioner;

        public PartitionDescriptor(PartitionOperatorBase.PartitionMethod pMethod, FieldSet pKeys, Partitioner<?> customPartitioner) {
            super(pKeys);
            this.pMethod = pMethod;
            this.customPartitioner = customPartitioner;
        }

        @Override
        public DriverStrategy getStrategy() {
            return DriverStrategy.UNARY_NO_OP;
        }

        @Override
        public SingleInputPlanNode instantiate(Channel in, SingleInputNode node) {
            return new SingleInputPlanNode(node, "Partition", in, DriverStrategy.UNARY_NO_OP);
        }

        @Override
        protected List<RequestedGlobalProperties> createPossibleGlobalProperties() {
            RequestedGlobalProperties rgps = new RequestedGlobalProperties();
            switch (this.pMethod) {
                case HASH: {
                    rgps.setHashPartitioned(this.keys);
                    break;
                }
                case REBALANCE: {
                    rgps.setForceRebalancing();
                    break;
                }
                case CUSTOM: {
                    rgps.setCustomPartitioned(this.keys, this.customPartitioner);
                    break;
                }
                case RANGE: {
                    throw new UnsupportedOperationException("Not yet supported");
                }
                default: {
                    throw new IllegalArgumentException("Invalid partition method");
                }
            }
            return Collections.singletonList(rgps);
        }

        @Override
        protected List<RequestedLocalProperties> createPossibleLocalProperties() {
            return Collections.singletonList(new RequestedLocalProperties());
        }

        @Override
        public GlobalProperties computeGlobalProperties(GlobalProperties gProps) {
            return gProps;
        }

        @Override
        public LocalProperties computeLocalProperties(LocalProperties lProps) {
            return lProps;
        }
    }
}

