/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.model.openai;

import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.TextElement;
import org.apache.flink.model.openai.AbstractOpenAIModelFunction;
import org.apache.flink.model.openai.ContextOverflowAction;
import org.apache.flink.model.openai.OpenAIChatModelFunction;

@Experimental
public class OpenAIOptions {
    @Documentation.Section(value={"model_openai_common"})
    public static final ConfigOption<String> ENDPOINT = ConfigOptions.key((String)"endpoint").stringType().noDefaultValue().withDescription(Description.builder().text("Full URL of the OpenAI API endpoint, e.g., %s or %s", new InlineElement[]{TextElement.code((String)"https://api.openai.com/v1/chat/completions"), TextElement.code((String)"https://api.openai.com/v1/embeddings")}).build());
    @Documentation.Section(value={"model_openai_common"})
    public static final ConfigOption<String> API_KEY = ConfigOptions.key((String)"api-key").stringType().noDefaultValue().withDescription("OpenAI API key for authentication.");
    @Documentation.Section(value={"model_openai_common"})
    public static final ConfigOption<String> MODEL = ConfigOptions.key((String)"model").stringType().noDefaultValue().withDescription(Description.builder().text("Model name, e.g., %s, %s.", new InlineElement[]{TextElement.code((String)"gpt-3.5-turbo"), TextElement.code((String)"text-embedding-ada-002")}).build());
    @Documentation.Section(value={"model_openai_common"})
    public static final ConfigOption<Integer> MAX_CONTEXT_SIZE = ConfigOptions.key((String)"max-context-size").intType().noDefaultValue().withDescription("Max number of tokens for context. context-overflow-action would be triggered if this threshold is exceeded.");
    @Documentation.Section(value={"model_openai_common"})
    public static final ConfigOption<ContextOverflowAction> CONTEXT_OVERFLOW_ACTION = ConfigOptions.key((String)"context-overflow-action").enumType(ContextOverflowAction.class).defaultValue((Object)ContextOverflowAction.TRUNCATED_TAIL).withDescription(Description.builder().text("Action to handle context overflows.").build());
    @Documentation.Section(value={"model_openai_common"})
    public static final ConfigOption<AbstractOpenAIModelFunction.ErrorHandlingStrategy> ERROR_HANDLING_STRATEGY = ConfigOptions.key((String)"error-handling-strategy").enumType(AbstractOpenAIModelFunction.ErrorHandlingStrategy.class).defaultValue((Object)AbstractOpenAIModelFunction.ErrorHandlingStrategy.RETRY).withDescription("Strategy for handling errors during model requests.");
    @Documentation.Section(value={"model_openai_common"})
    public static final ConfigOption<Integer> RETRY_NUM = ConfigOptions.key((String)"retry-num").intType().defaultValue((Object)100).withDescription("Number of retry for OpenAI client requests.");
    @Documentation.Section(value={"model_openai_common"})
    public static final ConfigOption<AbstractOpenAIModelFunction.RetryFallbackStrategy> RETRY_FALLBACK_STRATEGY = ConfigOptions.key((String)"retry-fallback-strategy").enumType(AbstractOpenAIModelFunction.RetryFallbackStrategy.class).defaultValue((Object)AbstractOpenAIModelFunction.RetryFallbackStrategy.FAILOVER).withDescription("Fallback strategy to employ if the retry attempts are exhausted. This strategy is applied when error-handling-strategy is set to retry.");
    @Documentation.Section(value={"model_openai_chat"})
    public static final ConfigOption<String> SYSTEM_PROMPT = ConfigOptions.key((String)"system-prompt").stringType().defaultValue((Object)"You are a helpful assistant.").withDeprecatedKeys(new String[]{"systemPrompt"}).withDescription("The system message of a chat.");
    @Documentation.Section(value={"model_openai_chat"})
    public static final ConfigOption<Double> TEMPERATURE = ConfigOptions.key((String)"temperature").doubleType().noDefaultValue().withDescription("Controls the randomness or \u201ccreativity\u201d of the output. Typical values are between 0.0 and 1.0.");
    @Documentation.Section(value={"model_openai_chat"})
    public static final ConfigOption<Double> TOP_P = ConfigOptions.key((String)"top-p").doubleType().noDefaultValue().withDeprecatedKeys(new String[]{"topP"}).withDescription("The probability cutoff for token selection. Usually, either temperature or topP are specified, but not both.");
    @Documentation.Section(value={"model_openai_chat"})
    public static final ConfigOption<String> STOP = ConfigOptions.key((String)"stop").stringType().noDefaultValue().withDescription("A CSV list of strings to pass as stop sequences to the model.");
    @Documentation.Section(value={"model_openai_chat"})
    public static final ConfigOption<Long> MAX_TOKENS = ConfigOptions.key((String)"max-tokens").longType().noDefaultValue().withDeprecatedKeys(new String[]{"maxTokens"}).withDescription("The maximum number of tokens that can be generated in the chat completion.");
    @Documentation.Section(value={"model_openai_chat"})
    public static final ConfigOption<Double> PRESENCE_PENALTY = ConfigOptions.key((String)"presence-penalty").doubleType().noDefaultValue().withDescription("Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.");
    @Documentation.Section(value={"model_openai_chat"})
    public static final ConfigOption<Long> N = ConfigOptions.key((String)"n").longType().noDefaultValue().withDescription("How many chat completion choices to generate for each input message. Note that you will be charged based on the number of generated tokens across all of the choices. Keep n as 1 to minimize costs.");
    @Documentation.Section(value={"model_openai_chat"})
    public static final ConfigOption<Long> SEED = ConfigOptions.key((String)"seed").longType().noDefaultValue().withDescription("If specified, the model platform will make a best effort to sample deterministically, such that repeated requests with the same seed and parameters should return the same result. Determinism is not guaranteed.");
    @Documentation.Section(value={"model_openai_chat"})
    public static final ConfigOption<OpenAIChatModelFunction.ChatModelResponseFormat> RESPONSE_FORMAT = ConfigOptions.key((String)"response-format").enumType(OpenAIChatModelFunction.ChatModelResponseFormat.class).noDefaultValue().withDescription("The format of the response, e.g., 'text' or 'json_object'.");
    @Documentation.Section(value={"model_openai_embedding"})
    public static final ConfigOption<Long> DIMENSION = ConfigOptions.key((String)"dimension").longType().noDefaultValue().withDescription("The size of the embedding result array.");
}

