/*
 * Decompiled with CFR 0.152.
 */
package com.knuddels.jtokkit.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class IntArrayList {
    private int[] array;
    private int size = 0;

    public IntArrayList() {
        this(10);
    }

    public IntArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.array = new int[initialCapacity];
    }

    public void clear() {
        this.size = 0;
    }

    public void add(int element) {
        if (this.size >= this.array.length) {
            this.resize();
        }
        this.array[this.size++] = element;
    }

    public int get(int index) {
        return this.array[index];
    }

    public int set(int index, int element) {
        int old = this.array[index];
        this.array[index] = element;
        return old;
    }

    private void resize() {
        this.ensureCapacity(Math.max(1, this.array.length) * 2);
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity <= this.size) {
            return;
        }
        int[] newArray = new int[minCapacity];
        if (this.size > 0) {
            System.arraycopy(this.array, 0, newArray, 0, this.size);
        }
        this.array = newArray;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int[] toArray() {
        return Arrays.copyOf(this.array, this.size);
    }

    public List<Integer> boxed() {
        ArrayList<Integer> list2 = new ArrayList<Integer>(this.size);
        for (int i = 0; i < this.size; ++i) {
            list2.add(this.array[i]);
        }
        return list2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntArrayList that = (IntArrayList)o;
        if (this.size != that.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i] == that.array[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.size; ++i) {
            result = 31 * result + this.array[i];
        }
        return result;
    }

    public String toString() {
        return this.boxed().toString();
    }
}

