/*
 * Decompiled with CFR 0.152.
 */
package com.knuddels.jtokkit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class ByteArrayList {
    private byte[] array;
    private int size = 0;

    ByteArrayList() {
        this(10);
    }

    ByteArrayList(int size) {
        this.array = new byte[size];
    }

    void clear() {
        this.size = 0;
    }

    void add(byte element) {
        if (this.size >= this.array.length) {
            this.resize();
        }
        this.array[this.size++] = element;
    }

    byte get(int index) {
        return this.array[index];
    }

    void set(int index, byte element) {
        this.array[index] = element;
    }

    private void resize() {
        this.ensureCapacity(Math.max(1, this.array.length) * 2);
    }

    void ensureCapacity(int targetSize) {
        if (targetSize <= this.size) {
            return;
        }
        byte[] newArray = new byte[targetSize];
        if (this.size > 0) {
            System.arraycopy(this.array, 0, newArray, 0, this.size);
        }
        this.array = newArray;
    }

    int size() {
        return this.size;
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    byte[] toArray() {
        return Arrays.copyOf(this.array, this.size);
    }

    List<Byte> boxed() {
        ArrayList<Byte> list2 = new ArrayList<Byte>(this.size);
        for (int i = 0; i < this.size; ++i) {
            list2.add(this.array[i]);
        }
        return list2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteArrayList that = (ByteArrayList)o;
        if (this.size != that.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i] == that.array[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.size; ++i) {
            result = 31 * result + this.array[i];
        }
        return result;
    }

    public String toString() {
        return this.boxed().toString();
    }
}

