/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.internal;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.flink.kubernetes.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.KubernetesResource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.internal.KubernetesDeserializer;

public class KubernetesDeserializerForMap
extends JsonDeserializer<Map<String, KubernetesResource>> {
    private final KubernetesDeserializer kubernetesDeserializer = new KubernetesDeserializer();

    @Override
    public Map<String, KubernetesResource> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.readValueAsTree();
        if (!node.isObject()) {
            throw new JsonMappingException(p, "Expected map but found " + String.valueOf((Object)node.getNodeType()));
        }
        LinkedHashMap<String, KubernetesResource> ret = new LinkedHashMap<String, KubernetesResource>();
        Iterator<Map.Entry<String, JsonNode>> it = node.fields();
        while (it.hasNext()) {
            Map.Entry<String, JsonNode> entry = it.next();
            ret.put(entry.getKey(), this.kubernetesDeserializer.deserialize(p, entry.getValue()));
        }
        return ret;
    }
}

