/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.readiness;

import java.util.Objects;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.EndpointSubset;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Endpoints;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.HasMetadata;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Node;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.NodeCondition;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Pod;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodCondition;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ReplicationController;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ReplicationControllerStatus;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.Deployment;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.DeploymentStatus;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.ReplicaSetSpec;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.ReplicaSetStatus;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.StatefulSet;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.StatefulSetSpec;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.StatefulSetStatus;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.extensions.DeploymentSpec;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Readiness {
    private static final String POD_READY = "Ready";
    private static final String NODE_READY = "Ready";
    private static final String TRUE = "True";
    private static final Logger logger = LoggerFactory.getLogger(Readiness.class);
    protected static final String READINESS_APPLICABLE_RESOURCES = "Node, Deployment, ReplicaSet, StatefulSet, Pod, ReplicationController";

    public static Readiness getInstance() {
        return ReadinessHolder.INSTANCE;
    }

    public boolean isReady(HasMetadata item) {
        if (this.isReadinessApplicable(item)) {
            return this.isResourceReady(item);
        }
        return this.handleNonReadinessApplicableResource(item);
    }

    protected boolean isReadinessApplicable(HasMetadata item) {
        return item instanceof Deployment || item instanceof org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.extensions.Deployment || item instanceof ReplicaSet || item instanceof Pod || item instanceof ReplicationController || item instanceof Endpoints || item instanceof Node || item instanceof StatefulSet;
    }

    protected boolean isResourceReady(HasMetadata item) {
        if (item instanceof Deployment) {
            return Readiness.isDeploymentReady((Deployment)item);
        }
        if (item instanceof org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.extensions.Deployment) {
            return Readiness.isExtensionsDeploymentReady((org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.extensions.Deployment)item);
        }
        if (item instanceof ReplicaSet) {
            return Readiness.isReplicaSetReady((ReplicaSet)item);
        }
        if (item instanceof Pod) {
            return Readiness.isPodReady((Pod)item);
        }
        if (item instanceof ReplicationController) {
            return Readiness.isReplicationControllerReady((ReplicationController)item);
        }
        if (item instanceof Endpoints) {
            return Readiness.isEndpointsReady((Endpoints)item);
        }
        if (item instanceof Node) {
            return Readiness.isNodeReady((Node)item);
        }
        if (item instanceof StatefulSet) {
            return Readiness.isStatefulSetReady((StatefulSet)item);
        }
        return false;
    }

    protected String getReadinessResourcesList() {
        return READINESS_APPLICABLE_RESOURCES;
    }

    final boolean handleNonReadinessApplicableResource(HasMetadata item) {
        boolean doesItemExist = Objects.nonNull(item);
        logger.warn("{} is not a Readiable resource. It needs to be one of [{}]", (Object)(doesItemExist ? item.getKind() : "Unknown"), (Object)this.getReadinessResourcesList());
        return doesItemExist;
    }

    public static boolean isStatefulSetReady(StatefulSet ss) {
        Utils.checkNotNull(ss, "StatefulSet can't be null.");
        StatefulSetSpec spec = ss.getSpec();
        StatefulSetStatus status = ss.getStatus();
        if (spec == null || spec.getReplicas() == null) {
            return false;
        }
        if (spec.getReplicas() == 0) {
            return true;
        }
        if (status == null || status.getReplicas() == null || status.getReadyReplicas() == null) {
            return false;
        }
        return spec.getReplicas().intValue() == status.getReplicas().intValue() && spec.getReplicas().intValue() == status.getReadyReplicas().intValue();
    }

    public static boolean isDeploymentReady(Deployment d) {
        Utils.checkNotNull(d, "Deployment can't be null.");
        org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.apps.DeploymentSpec spec = d.getSpec();
        DeploymentStatus status = d.getStatus();
        if (spec == null || spec.getReplicas() == null) {
            return false;
        }
        if (spec.getReplicas() == 0) {
            return true;
        }
        if (status == null || status.getReplicas() == null || status.getAvailableReplicas() == null) {
            return false;
        }
        int replicas = Utils.getNonNullOrElse(spec.getReplicas(), 0);
        return replicas == status.getReplicas() && replicas <= status.getAvailableReplicas();
    }

    public static boolean isExtensionsDeploymentReady(org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.extensions.Deployment d) {
        Utils.checkNotNull(d, "Deployment can't be null.");
        DeploymentSpec spec = d.getSpec();
        org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.extensions.DeploymentStatus status = d.getStatus();
        if (spec == null || spec.getReplicas() == null) {
            return false;
        }
        if (spec.getReplicas() == 0) {
            return true;
        }
        if (status == null || status.getReplicas() == null || status.getAvailableReplicas() == null) {
            return false;
        }
        return spec.getReplicas().intValue() == status.getReplicas().intValue() && spec.getReplicas() <= status.getAvailableReplicas();
    }

    public static boolean isReplicaSetReady(ReplicaSet r) {
        Utils.checkNotNull(r, "ReplicationController can't be null.");
        ReplicaSetSpec spec = r.getSpec();
        ReplicaSetStatus status = r.getStatus();
        if (spec == null || spec.getReplicas() == null) {
            return false;
        }
        if (spec.getReplicas() == 0) {
            return true;
        }
        if (status == null || status.getReadyReplicas() == null) {
            return false;
        }
        return spec.getReplicas().intValue() == status.getReadyReplicas().intValue();
    }

    public static boolean isReplicationControllerReady(ReplicationController r) {
        Utils.checkNotNull(r, "ReplicationController can't be null.");
        ReplicationControllerSpec spec = r.getSpec();
        ReplicationControllerStatus status = r.getStatus();
        if (spec == null || spec.getReplicas() == null) {
            return false;
        }
        if (spec.getReplicas() == 0) {
            return true;
        }
        if (status == null || status.getReadyReplicas() == null) {
            return false;
        }
        return spec.getReplicas().intValue() == status.getReadyReplicas().intValue();
    }

    public static boolean isEndpointsReady(Endpoints e) {
        Utils.checkNotNull(e, "Endpoints can't be null.");
        String name = e.getMetadata().getName();
        Utils.checkNotNull(name, "Endpoints name can't be null.");
        if (e.getSubsets() == null) {
            return false;
        }
        for (EndpointSubset subset : e.getSubsets()) {
            if (subset.getAddresses().isEmpty() || subset.getPorts().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean isPodReady(Pod pod) {
        Utils.checkNotNull(pod, "Pod can't be null.");
        PodCondition condition = Readiness.getPodReadyCondition(pod);
        if (condition == null || condition.getStatus() == null) {
            return false;
        }
        return condition.getStatus().equalsIgnoreCase(TRUE);
    }

    public static boolean isPodSucceeded(Pod pod) {
        Utils.checkNotNull(pod, "Pod can't be null.");
        return pod.getStatus() != null && "Succeeded".equals(pod.getStatus().getPhase());
    }

    private static PodCondition getPodReadyCondition(Pod pod) {
        Utils.checkNotNull(pod, "Pod can't be null.");
        if (pod.getStatus() == null || pod.getStatus().getConditions() == null) {
            return null;
        }
        for (PodCondition condition : pod.getStatus().getConditions()) {
            if (!"Ready".equals(condition.getType())) continue;
            return condition;
        }
        return null;
    }

    public static boolean isNodeReady(Node node) {
        Utils.checkNotNull(node, "Node can't be null.");
        NodeCondition condition = Readiness.getNodeReadyCondition(node);
        if (condition == null || condition.getStatus() == null) {
            return false;
        }
        return condition.getStatus().equalsIgnoreCase(TRUE);
    }

    private static NodeCondition getNodeReadyCondition(Node node) {
        Utils.checkNotNull(node, "Node can't be null.");
        if (node.getStatus() == null || node.getStatus().getConditions() == null) {
            return null;
        }
        for (NodeCondition condition : node.getStatus().getConditions()) {
            if (!"Ready".equals(condition.getType())) continue;
            return condition;
        }
        return null;
    }

    private static class ReadinessHolder {
        public static final Readiness INSTANCE = new Readiness();

        private ReadinessHolder() {
        }
    }
}

