/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.core.v1;

import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Pod;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ReplicationController;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ReplicationControllerList;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.Client;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.MixedOperation;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.PodResource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.apps.v1.RollingUpdater;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.internal.core.v1.ReplicationControllerOperationsImpl;

class ReplicationControllerRollingUpdater
extends RollingUpdater<ReplicationController, ReplicationControllerList> {
    ReplicationControllerRollingUpdater(Client client, String namespace, long rollingTimeoutMillis, long loggingIntervalMillis) {
        super(client, namespace, rollingTimeoutMillis, loggingIntervalMillis);
    }

    @Override
    protected ReplicationController createClone(ReplicationController obj, String newName, String newDeploymentHash) {
        return ((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((ReplicationControllerFluent.SpecNested)((ReplicationControllerFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)((ReplicationControllerFluent.MetadataNested)new ReplicationControllerBuilder(obj).editMetadata().withResourceVersion(null)).withName(newName)).endMetadata()).editSpec().withReplicas(0)).addToSelector("deployment", newDeploymentHash)).editTemplate().editMetadata().addToLabels("deployment", newDeploymentHash)).endMetadata()).endTemplate()).endSpec()).build();
    }

    @Override
    protected FilterWatchListDeletable<Pod, PodList, PodResource> selectedPodLister(ReplicationController obj) {
        return (FilterWatchListDeletable)((NonNamespaceOperation)this.pods().inNamespace(this.namespace)).withLabels(obj.getSpec().getSelector());
    }

    @Override
    protected ReplicationController updateDeploymentKey(String name, String hash) {
        ReplicationController old = (ReplicationController)((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(this.namespace)).withName(name)).get();
        ReplicationController updated = ((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((ReplicationControllerFluent.SpecNested)new ReplicationControllerBuilder(old).editSpec().addToSelector("deployment", hash)).editTemplate().editMetadata().addToLabels("deployment", hash)).endMetadata()).endTemplate()).endSpec()).build();
        return ((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(this.namespace)).withName(name)).replace(updated);
    }

    @Override
    protected ReplicationController removeDeploymentKey(String name) {
        ReplicationController old = (ReplicationController)((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(this.namespace)).withName(name)).get();
        ReplicationController updated = ((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((ReplicationControllerFluent.SpecNested)new ReplicationControllerBuilder(old).editSpec().removeFromSelector("deployment")).editTemplate().editMetadata().removeFromLabels("deployment")).endMetadata()).endTemplate()).endSpec()).build();
        return ((RollableScalableResource)((NonNamespaceOperation)this.resources().inNamespace(this.namespace)).withName(name)).replace(updated);
    }

    @Override
    protected int getReplicas(ReplicationController obj) {
        return obj.getSpec().getReplicas();
    }

    @Override
    protected ReplicationController setReplicas(ReplicationController obj, int replicas) {
        return ((ReplicationControllerBuilder)((ReplicationControllerFluent.SpecNested)new ReplicationControllerBuilder(obj).editSpec().withReplicas(replicas)).endSpec()).build();
    }

    @Override
    protected MixedOperation<ReplicationController, ReplicationControllerList, RollableScalableResource<ReplicationController>> resources() {
        return new ReplicationControllerOperationsImpl(this.client);
    }
}

