/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.resource.v1alpha3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.resource.v1alpha3.DeviceSelector;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.resource.v1alpha3.DeviceSelectorBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.resource.v1alpha3.DeviceSelectorFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.resource.v1alpha3.DeviceSubRequest;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.resource.v1alpha3.DeviceToleration;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.resource.v1alpha3.DeviceTolerationBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.resource.v1alpha3.DeviceTolerationFluent;

public class DeviceSubRequestFluent<A extends DeviceSubRequestFluent<A>>
extends BaseFluent<A> {
    private String allocationMode;
    private Long count;
    private String deviceClassName;
    private String name;
    private ArrayList<DeviceSelectorBuilder> selectors = new ArrayList();
    private ArrayList<DeviceTolerationBuilder> tolerations = new ArrayList();
    private Map<String, Object> additionalProperties;

    public DeviceSubRequestFluent() {
    }

    public DeviceSubRequestFluent(DeviceSubRequest instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DeviceSubRequest instance) {
        DeviceSubRequest deviceSubRequest = instance = instance != null ? instance : new DeviceSubRequest();
        if (instance != null) {
            this.withAllocationMode(instance.getAllocationMode());
            this.withCount(instance.getCount());
            this.withDeviceClassName(instance.getDeviceClassName());
            this.withName(instance.getName());
            this.withSelectors(instance.getSelectors());
            this.withTolerations(instance.getTolerations());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getAllocationMode() {
        return this.allocationMode;
    }

    public A withAllocationMode(String allocationMode) {
        this.allocationMode = allocationMode;
        return (A)this;
    }

    public boolean hasAllocationMode() {
        return this.allocationMode != null;
    }

    public Long getCount() {
        return this.count;
    }

    public A withCount(Long count) {
        this.count = count;
        return (A)this;
    }

    public boolean hasCount() {
        return this.count != null;
    }

    public String getDeviceClassName() {
        return this.deviceClassName;
    }

    public A withDeviceClassName(String deviceClassName) {
        this.deviceClassName = deviceClassName;
        return (A)this;
    }

    public boolean hasDeviceClassName() {
        return this.deviceClassName != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public A addToSelectors(int index, DeviceSelector item) {
        if (this.selectors == null) {
            this.selectors = new ArrayList();
        }
        DeviceSelectorBuilder builder = new DeviceSelectorBuilder(item);
        if (index < 0 || index >= this.selectors.size()) {
            this._visitables.get("selectors").add(builder);
            this.selectors.add(builder);
        } else {
            this._visitables.get("selectors").add(builder);
            this.selectors.add(index, builder);
        }
        return (A)this;
    }

    public A setToSelectors(int index, DeviceSelector item) {
        if (this.selectors == null) {
            this.selectors = new ArrayList();
        }
        DeviceSelectorBuilder builder = new DeviceSelectorBuilder(item);
        if (index < 0 || index >= this.selectors.size()) {
            this._visitables.get("selectors").add(builder);
            this.selectors.add(builder);
        } else {
            this._visitables.get("selectors").add(builder);
            this.selectors.set(index, builder);
        }
        return (A)this;
    }

    public A addToSelectors(DeviceSelector ... items) {
        if (this.selectors == null) {
            this.selectors = new ArrayList();
        }
        for (DeviceSelector item : items) {
            DeviceSelectorBuilder builder = new DeviceSelectorBuilder(item);
            this._visitables.get("selectors").add(builder);
            this.selectors.add(builder);
        }
        return (A)this;
    }

    public A addAllToSelectors(Collection<DeviceSelector> items) {
        if (this.selectors == null) {
            this.selectors = new ArrayList();
        }
        for (DeviceSelector item : items) {
            DeviceSelectorBuilder builder = new DeviceSelectorBuilder(item);
            this._visitables.get("selectors").add(builder);
            this.selectors.add(builder);
        }
        return (A)this;
    }

    public A removeFromSelectors(DeviceSelector ... items) {
        if (this.selectors == null) {
            return (A)this;
        }
        for (DeviceSelector item : items) {
            DeviceSelectorBuilder builder = new DeviceSelectorBuilder(item);
            this._visitables.get("selectors").remove(builder);
            this.selectors.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromSelectors(Collection<DeviceSelector> items) {
        if (this.selectors == null) {
            return (A)this;
        }
        for (DeviceSelector item : items) {
            DeviceSelectorBuilder builder = new DeviceSelectorBuilder(item);
            this._visitables.get("selectors").remove(builder);
            this.selectors.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSelectors(Predicate<DeviceSelectorBuilder> predicate) {
        if (this.selectors == null) {
            return (A)this;
        }
        Iterator<DeviceSelectorBuilder> each = this.selectors.iterator();
        Object visitables = this._visitables.get("selectors");
        while (each.hasNext()) {
            DeviceSelectorBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<DeviceSelector> buildSelectors() {
        return this.selectors != null ? DeviceSubRequestFluent.build(this.selectors) : null;
    }

    public DeviceSelector buildSelector(int index) {
        return this.selectors.get(index).build();
    }

    public DeviceSelector buildFirstSelector() {
        return this.selectors.get(0).build();
    }

    public DeviceSelector buildLastSelector() {
        return this.selectors.get(this.selectors.size() - 1).build();
    }

    public DeviceSelector buildMatchingSelector(Predicate<DeviceSelectorBuilder> predicate) {
        for (DeviceSelectorBuilder item : this.selectors) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSelector(Predicate<DeviceSelectorBuilder> predicate) {
        for (DeviceSelectorBuilder item : this.selectors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSelectors(List<DeviceSelector> selectors) {
        if (this.selectors != null) {
            this._visitables.get("selectors").clear();
        }
        if (selectors != null) {
            this.selectors = new ArrayList();
            for (DeviceSelector item : selectors) {
                this.addToSelectors(item);
            }
        } else {
            this.selectors = null;
        }
        return (A)this;
    }

    public A withSelectors(DeviceSelector ... selectors) {
        if (this.selectors != null) {
            this.selectors.clear();
            this._visitables.remove("selectors");
        }
        if (selectors != null) {
            for (DeviceSelector item : selectors) {
                this.addToSelectors(item);
            }
        }
        return (A)this;
    }

    public boolean hasSelectors() {
        return this.selectors != null && !this.selectors.isEmpty();
    }

    public SelectorsNested<A> addNewSelector() {
        return new SelectorsNested(-1, null);
    }

    public SelectorsNested<A> addNewSelectorLike(DeviceSelector item) {
        return new SelectorsNested(-1, item);
    }

    public SelectorsNested<A> setNewSelectorLike(int index, DeviceSelector item) {
        return new SelectorsNested(index, item);
    }

    public SelectorsNested<A> editSelector(int index) {
        if (this.selectors.size() <= index) {
            throw new RuntimeException("Can't edit selectors. Index exceeds size.");
        }
        return this.setNewSelectorLike(index, this.buildSelector(index));
    }

    public SelectorsNested<A> editFirstSelector() {
        if (this.selectors.size() == 0) {
            throw new RuntimeException("Can't edit first selectors. The list is empty.");
        }
        return this.setNewSelectorLike(0, this.buildSelector(0));
    }

    public SelectorsNested<A> editLastSelector() {
        int index = this.selectors.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last selectors. The list is empty.");
        }
        return this.setNewSelectorLike(index, this.buildSelector(index));
    }

    public SelectorsNested<A> editMatchingSelector(Predicate<DeviceSelectorBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.selectors.size(); ++i) {
            if (!predicate.test(this.selectors.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching selectors. No match found.");
        }
        return this.setNewSelectorLike(index, this.buildSelector(index));
    }

    public A addToTolerations(int index, DeviceToleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        DeviceTolerationBuilder builder = new DeviceTolerationBuilder(item);
        if (index < 0 || index >= this.tolerations.size()) {
            this._visitables.get("tolerations").add(builder);
            this.tolerations.add(builder);
        } else {
            this._visitables.get("tolerations").add(builder);
            this.tolerations.add(index, builder);
        }
        return (A)this;
    }

    public A setToTolerations(int index, DeviceToleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        DeviceTolerationBuilder builder = new DeviceTolerationBuilder(item);
        if (index < 0 || index >= this.tolerations.size()) {
            this._visitables.get("tolerations").add(builder);
            this.tolerations.add(builder);
        } else {
            this._visitables.get("tolerations").add(builder);
            this.tolerations.set(index, builder);
        }
        return (A)this;
    }

    public A addToTolerations(DeviceToleration ... items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        for (DeviceToleration item : items) {
            DeviceTolerationBuilder builder = new DeviceTolerationBuilder(item);
            this._visitables.get("tolerations").add(builder);
            this.tolerations.add(builder);
        }
        return (A)this;
    }

    public A addAllToTolerations(Collection<DeviceToleration> items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        for (DeviceToleration item : items) {
            DeviceTolerationBuilder builder = new DeviceTolerationBuilder(item);
            this._visitables.get("tolerations").add(builder);
            this.tolerations.add(builder);
        }
        return (A)this;
    }

    public A removeFromTolerations(DeviceToleration ... items) {
        if (this.tolerations == null) {
            return (A)this;
        }
        for (DeviceToleration item : items) {
            DeviceTolerationBuilder builder = new DeviceTolerationBuilder(item);
            this._visitables.get("tolerations").remove(builder);
            this.tolerations.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromTolerations(Collection<DeviceToleration> items) {
        if (this.tolerations == null) {
            return (A)this;
        }
        for (DeviceToleration item : items) {
            DeviceTolerationBuilder builder = new DeviceTolerationBuilder(item);
            this._visitables.get("tolerations").remove(builder);
            this.tolerations.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromTolerations(Predicate<DeviceTolerationBuilder> predicate) {
        if (this.tolerations == null) {
            return (A)this;
        }
        Iterator<DeviceTolerationBuilder> each = this.tolerations.iterator();
        Object visitables = this._visitables.get("tolerations");
        while (each.hasNext()) {
            DeviceTolerationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<DeviceToleration> buildTolerations() {
        return this.tolerations != null ? DeviceSubRequestFluent.build(this.tolerations) : null;
    }

    public DeviceToleration buildToleration(int index) {
        return this.tolerations.get(index).build();
    }

    public DeviceToleration buildFirstToleration() {
        return this.tolerations.get(0).build();
    }

    public DeviceToleration buildLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1).build();
    }

    public DeviceToleration buildMatchingToleration(Predicate<DeviceTolerationBuilder> predicate) {
        for (DeviceTolerationBuilder item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingToleration(Predicate<DeviceTolerationBuilder> predicate) {
        for (DeviceTolerationBuilder item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTolerations(List<DeviceToleration> tolerations) {
        if (this.tolerations != null) {
            this._visitables.get("tolerations").clear();
        }
        if (tolerations != null) {
            this.tolerations = new ArrayList();
            for (DeviceToleration item : tolerations) {
                this.addToTolerations(item);
            }
        } else {
            this.tolerations = null;
        }
        return (A)this;
    }

    public A withTolerations(DeviceToleration ... tolerations) {
        if (this.tolerations != null) {
            this.tolerations.clear();
            this._visitables.remove("tolerations");
        }
        if (tolerations != null) {
            for (DeviceToleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)this;
    }

    public boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    public A addNewToleration(String effect, String key, String operator, Long tolerationSeconds, String value) {
        return this.addToTolerations(new DeviceToleration(effect, key, operator, tolerationSeconds, value));
    }

    public TolerationsNested<A> addNewToleration() {
        return new TolerationsNested(-1, null);
    }

    public TolerationsNested<A> addNewTolerationLike(DeviceToleration item) {
        return new TolerationsNested(-1, item);
    }

    public TolerationsNested<A> setNewTolerationLike(int index, DeviceToleration item) {
        return new TolerationsNested(index, item);
    }

    public TolerationsNested<A> editToleration(int index) {
        if (this.tolerations.size() <= index) {
            throw new RuntimeException("Can't edit tolerations. Index exceeds size.");
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    public TolerationsNested<A> editFirstToleration() {
        if (this.tolerations.size() == 0) {
            throw new RuntimeException("Can't edit first tolerations. The list is empty.");
        }
        return this.setNewTolerationLike(0, this.buildToleration(0));
    }

    public TolerationsNested<A> editLastToleration() {
        int index = this.tolerations.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tolerations. The list is empty.");
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    public TolerationsNested<A> editMatchingToleration(Predicate<DeviceTolerationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tolerations.size(); ++i) {
            if (!predicate.test(this.tolerations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tolerations. No match found.");
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeviceSubRequestFluent that = (DeviceSubRequestFluent)o;
        if (!Objects.equals(this.allocationMode, that.allocationMode)) {
            return false;
        }
        if (!Objects.equals(this.count, that.count)) {
            return false;
        }
        if (!Objects.equals(this.deviceClassName, that.deviceClassName)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.selectors, that.selectors)) {
            return false;
        }
        if (!Objects.equals(this.tolerations, that.tolerations)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allocationMode, this.count, this.deviceClassName, this.name, this.selectors, this.tolerations, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allocationMode != null) {
            sb.append("allocationMode:");
            sb.append(this.allocationMode + ",");
        }
        if (this.count != null) {
            sb.append("count:");
            sb.append(this.count + ",");
        }
        if (this.deviceClassName != null) {
            sb.append("deviceClassName:");
            sb.append(this.deviceClassName + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.selectors != null && !this.selectors.isEmpty()) {
            sb.append("selectors:");
            sb.append(String.valueOf(this.selectors) + ",");
        }
        if (this.tolerations != null && !this.tolerations.isEmpty()) {
            sb.append("tolerations:");
            sb.append(String.valueOf(this.tolerations) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TolerationsNested<N>
    extends DeviceTolerationFluent<TolerationsNested<N>>
    implements Nested<N> {
        DeviceTolerationBuilder builder;
        int index;

        TolerationsNested(int index, DeviceToleration item) {
            this.index = index;
            this.builder = new DeviceTolerationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DeviceSubRequestFluent.this.setToTolerations(this.index, this.builder.build());
        }

        public N endToleration() {
            return this.and();
        }
    }

    public class SelectorsNested<N>
    extends DeviceSelectorFluent<SelectorsNested<N>>
    implements Nested<N> {
        DeviceSelectorBuilder builder;
        int index;

        SelectorsNested(int index, DeviceSelector item) {
            this.index = index;
            this.builder = new DeviceSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DeviceSubRequestFluent.this.setToSelectors(this.index, this.builder.build());
        }

        public N endSelector() {
            return this.and();
        }
    }
}

