/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.gatewayapi.v1;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Condition;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.gatewayapi.v1.ParentReference;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.gatewayapi.v1.ParentReferenceBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.gatewayapi.v1.ParentReferenceFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.gatewayapi.v1.RouteParentStatus;

public class RouteParentStatusFluent<A extends RouteParentStatusFluent<A>>
extends BaseFluent<A> {
    private List<Condition> conditions = new ArrayList<Condition>();
    private String controllerName;
    private ParentReferenceBuilder parentRef;
    private Map<String, Object> additionalProperties;

    public RouteParentStatusFluent() {
    }

    public RouteParentStatusFluent(RouteParentStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(RouteParentStatus instance) {
        RouteParentStatus routeParentStatus = instance = instance != null ? instance : new RouteParentStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withControllerName(instance.getControllerName());
            this.withParentRef(instance.getParentRef());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public String getControllerName() {
        return this.controllerName;
    }

    public A withControllerName(String controllerName) {
        this.controllerName = controllerName;
        return (A)this;
    }

    public boolean hasControllerName() {
        return this.controllerName != null;
    }

    public ParentReference buildParentRef() {
        return this.parentRef != null ? this.parentRef.build() : null;
    }

    public A withParentRef(ParentReference parentRef) {
        this._visitables.remove("parentRef");
        if (parentRef != null) {
            this.parentRef = new ParentReferenceBuilder(parentRef);
            this._visitables.get("parentRef").add(this.parentRef);
        } else {
            this.parentRef = null;
            this._visitables.get("parentRef").remove(this.parentRef);
        }
        return (A)this;
    }

    public boolean hasParentRef() {
        return this.parentRef != null;
    }

    public ParentRefNested<A> withNewParentRef() {
        return new ParentRefNested(null);
    }

    public ParentRefNested<A> withNewParentRefLike(ParentReference item) {
        return new ParentRefNested(item);
    }

    public ParentRefNested<A> editParentRef() {
        return this.withNewParentRefLike(Optional.ofNullable(this.buildParentRef()).orElse(null));
    }

    public ParentRefNested<A> editOrNewParentRef() {
        return this.withNewParentRefLike(Optional.ofNullable(this.buildParentRef()).orElse(new ParentReferenceBuilder().build()));
    }

    public ParentRefNested<A> editOrNewParentRefLike(ParentReference item) {
        return this.withNewParentRefLike(Optional.ofNullable(this.buildParentRef()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RouteParentStatusFluent that = (RouteParentStatusFluent)o;
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.controllerName, that.controllerName)) {
            return false;
        }
        if (!Objects.equals(this.parentRef, that.parentRef)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.controllerName, this.parentRef, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(String.valueOf(this.conditions) + ",");
        }
        if (this.controllerName != null) {
            sb.append("controllerName:");
            sb.append(this.controllerName + ",");
        }
        if (this.parentRef != null) {
            sb.append("parentRef:");
            sb.append(String.valueOf(this.parentRef) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ParentRefNested<N>
    extends ParentReferenceFluent<ParentRefNested<N>>
    implements Nested<N> {
        ParentReferenceBuilder builder;

        ParentRefNested(ParentReference item) {
            this.builder = new ParentReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RouteParentStatusFluent.this.withParentRef(this.builder.build());
        }

        public N endParentRef() {
            return this.and();
        }
    }
}

