/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.LabelSelector;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.LabelSelectorRequirement;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.LabelSelectorRequirementBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.LabelSelectorRequirementFluent;

public class LabelSelectorFluent<A extends LabelSelectorFluent<A>>
extends BaseFluent<A> {
    private ArrayList<LabelSelectorRequirementBuilder> matchExpressions = new ArrayList();
    private Map<String, String> matchLabels;
    private Map<String, Object> additionalProperties;

    public LabelSelectorFluent() {
    }

    public LabelSelectorFluent(LabelSelector instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(LabelSelector instance) {
        LabelSelector labelSelector = instance = instance != null ? instance : new LabelSelector();
        if (instance != null) {
            this.withMatchExpressions(instance.getMatchExpressions());
            this.withMatchLabels(instance.getMatchLabels());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToMatchExpressions(int index, LabelSelectorRequirement item) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList();
        }
        LabelSelectorRequirementBuilder builder = new LabelSelectorRequirementBuilder(item);
        if (index < 0 || index >= this.matchExpressions.size()) {
            this._visitables.get("matchExpressions").add(builder);
            this.matchExpressions.add(builder);
        } else {
            this._visitables.get("matchExpressions").add(builder);
            this.matchExpressions.add(index, builder);
        }
        return (A)this;
    }

    public A setToMatchExpressions(int index, LabelSelectorRequirement item) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList();
        }
        LabelSelectorRequirementBuilder builder = new LabelSelectorRequirementBuilder(item);
        if (index < 0 || index >= this.matchExpressions.size()) {
            this._visitables.get("matchExpressions").add(builder);
            this.matchExpressions.add(builder);
        } else {
            this._visitables.get("matchExpressions").add(builder);
            this.matchExpressions.set(index, builder);
        }
        return (A)this;
    }

    public A addToMatchExpressions(LabelSelectorRequirement ... items) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList();
        }
        for (LabelSelectorRequirement item : items) {
            LabelSelectorRequirementBuilder builder = new LabelSelectorRequirementBuilder(item);
            this._visitables.get("matchExpressions").add(builder);
            this.matchExpressions.add(builder);
        }
        return (A)this;
    }

    public A addAllToMatchExpressions(Collection<LabelSelectorRequirement> items) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList();
        }
        for (LabelSelectorRequirement item : items) {
            LabelSelectorRequirementBuilder builder = new LabelSelectorRequirementBuilder(item);
            this._visitables.get("matchExpressions").add(builder);
            this.matchExpressions.add(builder);
        }
        return (A)this;
    }

    public A removeFromMatchExpressions(LabelSelectorRequirement ... items) {
        if (this.matchExpressions == null) {
            return (A)this;
        }
        for (LabelSelectorRequirement item : items) {
            LabelSelectorRequirementBuilder builder = new LabelSelectorRequirementBuilder(item);
            this._visitables.get("matchExpressions").remove(builder);
            this.matchExpressions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromMatchExpressions(Collection<LabelSelectorRequirement> items) {
        if (this.matchExpressions == null) {
            return (A)this;
        }
        for (LabelSelectorRequirement item : items) {
            LabelSelectorRequirementBuilder builder = new LabelSelectorRequirementBuilder(item);
            this._visitables.get("matchExpressions").remove(builder);
            this.matchExpressions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromMatchExpressions(Predicate<LabelSelectorRequirementBuilder> predicate) {
        if (this.matchExpressions == null) {
            return (A)this;
        }
        Iterator<LabelSelectorRequirementBuilder> each = this.matchExpressions.iterator();
        Object visitables = this._visitables.get("matchExpressions");
        while (each.hasNext()) {
            LabelSelectorRequirementBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<LabelSelectorRequirement> buildMatchExpressions() {
        return this.matchExpressions != null ? LabelSelectorFluent.build(this.matchExpressions) : null;
    }

    public LabelSelectorRequirement buildMatchExpression(int index) {
        return this.matchExpressions.get(index).build();
    }

    public LabelSelectorRequirement buildFirstMatchExpression() {
        return this.matchExpressions.get(0).build();
    }

    public LabelSelectorRequirement buildLastMatchExpression() {
        return this.matchExpressions.get(this.matchExpressions.size() - 1).build();
    }

    public LabelSelectorRequirement buildMatchingMatchExpression(Predicate<LabelSelectorRequirementBuilder> predicate) {
        for (LabelSelectorRequirementBuilder item : this.matchExpressions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMatchExpression(Predicate<LabelSelectorRequirementBuilder> predicate) {
        for (LabelSelectorRequirementBuilder item : this.matchExpressions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMatchExpressions(List<LabelSelectorRequirement> matchExpressions) {
        if (this.matchExpressions != null) {
            this._visitables.get("matchExpressions").clear();
        }
        if (matchExpressions != null) {
            this.matchExpressions = new ArrayList();
            for (LabelSelectorRequirement item : matchExpressions) {
                this.addToMatchExpressions(item);
            }
        } else {
            this.matchExpressions = null;
        }
        return (A)this;
    }

    public A withMatchExpressions(LabelSelectorRequirement ... matchExpressions) {
        if (this.matchExpressions != null) {
            this.matchExpressions.clear();
            this._visitables.remove("matchExpressions");
        }
        if (matchExpressions != null) {
            for (LabelSelectorRequirement item : matchExpressions) {
                this.addToMatchExpressions(item);
            }
        }
        return (A)this;
    }

    public boolean hasMatchExpressions() {
        return this.matchExpressions != null && !this.matchExpressions.isEmpty();
    }

    public MatchExpressionsNested<A> addNewMatchExpression() {
        return new MatchExpressionsNested(-1, null);
    }

    public MatchExpressionsNested<A> addNewMatchExpressionLike(LabelSelectorRequirement item) {
        return new MatchExpressionsNested(-1, item);
    }

    public MatchExpressionsNested<A> setNewMatchExpressionLike(int index, LabelSelectorRequirement item) {
        return new MatchExpressionsNested(index, item);
    }

    public MatchExpressionsNested<A> editMatchExpression(int index) {
        if (this.matchExpressions.size() <= index) {
            throw new RuntimeException("Can't edit matchExpressions. Index exceeds size.");
        }
        return this.setNewMatchExpressionLike(index, this.buildMatchExpression(index));
    }

    public MatchExpressionsNested<A> editFirstMatchExpression() {
        if (this.matchExpressions.size() == 0) {
            throw new RuntimeException("Can't edit first matchExpressions. The list is empty.");
        }
        return this.setNewMatchExpressionLike(0, this.buildMatchExpression(0));
    }

    public MatchExpressionsNested<A> editLastMatchExpression() {
        int index = this.matchExpressions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last matchExpressions. The list is empty.");
        }
        return this.setNewMatchExpressionLike(index, this.buildMatchExpression(index));
    }

    public MatchExpressionsNested<A> editMatchingMatchExpression(Predicate<LabelSelectorRequirementBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.matchExpressions.size(); ++i) {
            if (!predicate.test(this.matchExpressions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching matchExpressions. No match found.");
        }
        return this.setNewMatchExpressionLike(index, this.buildMatchExpression(index));
    }

    public A addToMatchLabels(String key, String value) {
        if (this.matchLabels == null && key != null && value != null) {
            this.matchLabels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.matchLabels.put(key, value);
        }
        return (A)this;
    }

    public A addToMatchLabels(Map<String, String> map) {
        if (this.matchLabels == null && map != null) {
            this.matchLabels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.matchLabels.putAll(map);
        }
        return (A)this;
    }

    public A removeFromMatchLabels(String key) {
        if (this.matchLabels == null) {
            return (A)this;
        }
        if (key != null && this.matchLabels != null) {
            this.matchLabels.remove(key);
        }
        return (A)this;
    }

    public A removeFromMatchLabels(Map<String, String> map) {
        if (this.matchLabels == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.matchLabels == null) continue;
                this.matchLabels.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getMatchLabels() {
        return this.matchLabels;
    }

    public <K, V> A withMatchLabels(Map<String, String> matchLabels) {
        this.matchLabels = matchLabels == null ? null : new LinkedHashMap<String, String>(matchLabels);
        return (A)this;
    }

    public boolean hasMatchLabels() {
        return this.matchLabels != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LabelSelectorFluent that = (LabelSelectorFluent)o;
        if (!Objects.equals(this.matchExpressions, that.matchExpressions)) {
            return false;
        }
        if (!Objects.equals(this.matchLabels, that.matchLabels)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.matchExpressions, this.matchLabels, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.matchExpressions != null && !this.matchExpressions.isEmpty()) {
            sb.append("matchExpressions:");
            sb.append(String.valueOf(this.matchExpressions) + ",");
        }
        if (this.matchLabels != null && !this.matchLabels.isEmpty()) {
            sb.append("matchLabels:");
            sb.append(String.valueOf(this.matchLabels) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MatchExpressionsNested<N>
    extends LabelSelectorRequirementFluent<MatchExpressionsNested<N>>
    implements Nested<N> {
        LabelSelectorRequirementBuilder builder;
        int index;

        MatchExpressionsNested(int index, LabelSelectorRequirement item) {
            this.index = index;
            this.builder = new LabelSelectorRequirementBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)LabelSelectorFluent.this.setToMatchExpressions(this.index, this.builder.build());
        }

        public N endMatchExpression() {
            return this.and();
        }
    }
}

