/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.resources;

import org.apache.flink.kubernetes.kubeclient.KubernetesConfigMapSharedWatcher;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesConfigMap;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesSharedInformer;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ConfigMap;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.Informable;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

public class KubernetesConfigMapSharedInformer
extends KubernetesSharedInformer<ConfigMap, KubernetesConfigMap>
implements KubernetesConfigMapSharedWatcher {
    public KubernetesConfigMapSharedInformer(NamespacedKubernetesClient client, String name) {
        super(client, KubernetesConfigMapSharedInformer.getInformabaleConfigMaps(client, name), KubernetesConfigMap::new);
    }

    private static Informable<ConfigMap> getInformabaleConfigMaps(NamespacedKubernetesClient client, String name) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)name) ? 1 : 0) != 0, (Object)"Name must not be null or empty");
        return (Informable)client.configMaps().withName(name);
    }
}

