/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.decorators;

import java.util.List;
import org.apache.flink.kubernetes.configuration.KubernetesDeploymentTarget;
import org.apache.flink.kubernetes.kubeclient.FlinkPod;
import org.apache.flink.kubernetes.kubeclient.decorators.AbstractKubernetesStepDecorator;
import org.apache.flink.kubernetes.kubeclient.parameters.KubernetesJobManagerParameters;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Container;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerBuilder;
import org.apache.flink.kubernetes.utils.KubernetesUtils;
import org.apache.flink.util.Preconditions;

public class CmdJobManagerDecorator
extends AbstractKubernetesStepDecorator {
    private final KubernetesJobManagerParameters kubernetesJobManagerParameters;

    public CmdJobManagerDecorator(KubernetesJobManagerParameters kubernetesJobManagerParameters) {
        this.kubernetesJobManagerParameters = (KubernetesJobManagerParameters)Preconditions.checkNotNull((Object)kubernetesJobManagerParameters);
    }

    @Override
    public FlinkPod decorateFlinkPod(FlinkPod flinkPod) {
        Container mainContainerWithStartCmd = ((ContainerBuilder)((ContainerBuilder)new ContainerBuilder(flinkPod.getMainContainer()).withCommand(this.kubernetesJobManagerParameters.getContainerEntrypoint())).withArgs(this.getJobManagerStartCommand())).build();
        return new FlinkPod.Builder(flinkPod).withMainContainer(mainContainerWithStartCmd).build();
    }

    private List<String> getJobManagerStartCommand() {
        KubernetesDeploymentTarget deploymentTarget = KubernetesDeploymentTarget.fromConfig(this.kubernetesJobManagerParameters.getFlinkConfiguration());
        return KubernetesUtils.getStartCommandWithBashWrapper("kubernetes-jobmanager.sh " + deploymentTarget.getName() + " " + this.kubernetesJobManagerParameters.getEntrypointArgs());
    }
}

