/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils;

import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.Config;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.KubernetesClientException;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.BasicBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.HttpClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.HttpRequest;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.http.Interceptor;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.internal.SSLUtils;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.BackwardsCompatibilityInterceptor;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.ImpersonatorInterceptor;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.IpAddressMatcher;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.TokenRefreshInterceptor;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientUtils.class);
    private static final String HEADER_INTERCEPTOR = "HEADER";
    private static final String KUBERNETES_BACKWARDS_COMPATIBILITY_INTERCEPTOR_DISABLE = "kubernetes.backwardsCompatibilityInterceptor.disable";
    private static final String BACKWARDS_COMPATIBILITY_DISABLE_DEFAULT = "true";
    private static final Pattern IPV4_PATTERN = Pattern.compile("(http://|https://)?(?<ipAddressOrSubnet>(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])(\\/([1-2]\\d|3[0-2]|\\d))?)(\\D+|$)");
    private static final Pattern INVALID_HOST_PATTERN = Pattern.compile("[^\\da-zA-Z.\\-/:]+");

    private HttpClientUtils() {
    }

    static URI getProxyUri(URL master, Config config) throws URISyntaxException {
        String proxy = config.getHttpsProxy();
        if (master.getProtocol().equals("http")) {
            proxy = config.getHttpProxy();
        }
        if (proxy != null) {
            URI proxyUrl = new URI(proxy);
            if (proxyUrl.getPort() < 0) {
                throw new IllegalArgumentException("Failure in creating proxy URL. Proxy port is required!");
            }
            return proxyUrl;
        }
        return null;
    }

    public static Map<String, Interceptor> createApplicableInterceptors(Config config, HttpClient.Factory factory) {
        LinkedHashMap<String, Interceptor> interceptors = new LinkedHashMap<String, Interceptor>();
        interceptors.put(HEADER_INTERCEPTOR, new HeaderInterceptor(config));
        interceptors.put("IMPERSONATOR", new ImpersonatorInterceptor(config.getRequestConfig()));
        interceptors.put("TOKEN", new TokenRefreshInterceptor(config, factory, Instant.now()));
        String shouldDisableBackwardsCompatibilityInterceptor = Utils.getSystemPropertyOrEnvVar(KUBERNETES_BACKWARDS_COMPATIBILITY_INTERCEPTOR_DISABLE, BACKWARDS_COMPATIBILITY_DISABLE_DEFAULT);
        if (!Boolean.parseBoolean(shouldDisableBackwardsCompatibilityInterceptor)) {
            interceptors.put("BACKWARDS", new BackwardsCompatibilityInterceptor());
        }
        return interceptors;
    }

    public static String basicCredentials(String username, String password) {
        String usernameAndPassword = username + ":" + password;
        String encoded = Base64.getEncoder().encodeToString(usernameAndPassword.getBytes(StandardCharsets.ISO_8859_1));
        return "Basic " + encoded;
    }

    @Deprecated
    public static HttpClient createHttpClient(Config config) {
        HttpClient.Factory factory = HttpClientUtils.getHttpClientFactory();
        return factory.newBuilder(config).build();
    }

    public static HttpClient.Factory getHttpClientFactory() {
        HttpClient.Factory factory = HttpClientUtils.getFactory(ServiceLoader.load(HttpClient.Factory.class, Thread.currentThread().getContextClassLoader()));
        if (factory == null && (factory = HttpClientUtils.getFactory(ServiceLoader.load(HttpClient.Factory.class, HttpClientUtils.class.getClassLoader()))) == null) {
            throw new KubernetesClientException("No httpclient implementations found on the context classloader, please ensure your classpath includes an implementation jar");
        }
        LOGGER.debug("Using httpclient {} factory", (Object)factory.getClass().getName());
        return factory;
    }

    private static HttpClient.Factory getFactory(ServiceLoader<HttpClient.Factory> loader) {
        ArrayList factories = new ArrayList();
        loader.forEach(factories::add);
        if (factories.isEmpty()) {
            return null;
        }
        Collections.sort(factories, (f1, f2) -> Integer.compare(f2.priority(), f1.priority()));
        HttpClient.Factory factory = (HttpClient.Factory)factories.get(0);
        if (factories.size() > 1) {
            if (((HttpClient.Factory)factories.get(1)).priority() == factory.priority()) {
                LOGGER.warn("The following httpclient factories were detected on your classpath: {}, multiple of which had the same priority ({}) so one was chosen randomly. You should exclude dependencies that aren't needed or use an explicit association of the HttpClient.Factory.", (Object)factories.stream().map(f -> f.getClass().getName()).toArray(), (Object)factory.priority());
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("The following httpclient factories were detected on your classpath: {}", factories.stream().map(f -> f.getClass().getName()).toArray());
            }
        }
        return factory;
    }

    public static void applyCommonConfiguration(Config config, HttpClient.Builder builder, HttpClient.Factory factory) {
        builder.followAllRedirects();
        builder.tag(config.getRequestConfig());
        if (config.getConnectionTimeout() > 0) {
            builder.connectTimeout(config.getConnectionTimeout(), TimeUnit.MILLISECONDS);
        }
        if (config.isHttp2Disable()) {
            builder.preferHttp11();
        }
        try {
            HttpClientUtils.configureProxy(config, builder);
            TrustManager[] trustManagers = SSLUtils.trustManagers(config);
            KeyManager[] keyManagers = SSLUtils.keyManagers(config);
            builder.sslContext(keyManagers, trustManagers);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
        if (config.getTlsVersions() != null && config.getTlsVersions().length > 0) {
            builder.tlsVersions(config.getTlsVersions());
        }
        HttpClientUtils.createApplicableInterceptors(config, factory).forEach(builder::addOrReplaceInterceptor);
    }

    static void configureProxy(Config config, HttpClient.Builder builder) throws URISyntaxException, MalformedURLException {
        URL master;
        try {
            master = new URL(config.getMasterUrl());
        }
        catch (MalformedURLException e) {
            return;
        }
        URI proxyUri = HttpClientUtils.getProxyUri(master, config);
        if (proxyUri == null) {
            return;
        }
        String host = master.getHost();
        if (HttpClientUtils.isHostMatchedByNoProxy(host, config.getNoProxy())) {
            builder.proxyType(HttpClient.ProxyType.DIRECT);
        } else {
            builder.proxyAddress(new InetSocketAddress(proxyUri.getHost(), proxyUri.getPort()));
            if (config.getProxyUsername() != null) {
                builder.proxyAuthorization(HttpClientUtils.basicCredentials(config.getProxyUsername(), config.getProxyPassword()));
            }
            builder.proxyType(HttpClientUtils.toProxyType(proxyUri.getScheme()));
        }
    }

    static HttpClient.ProxyType toProxyType(String scheme) throws MalformedURLException {
        if (scheme == null) {
            throw new MalformedURLException("No protocol specified on proxy URL");
        }
        if ((scheme = scheme.toLowerCase()).startsWith("http")) {
            return HttpClient.ProxyType.HTTP;
        }
        if (scheme.equals("socks4")) {
            return HttpClient.ProxyType.SOCKS4;
        }
        if (scheme.equals("socks5")) {
            return HttpClient.ProxyType.SOCKS5;
        }
        throw new MalformedURLException("Unsupported protocol specified on proxy URL");
    }

    static boolean isHostMatchedByNoProxy(String host, String[] noProxies) throws MalformedURLException {
        for (String noProxy : noProxies == null ? new String[]{} : noProxies) {
            if (INVALID_HOST_PATTERN.matcher(noProxy).find()) {
                throw new MalformedURLException("NO_PROXY URL contains invalid entry: '" + noProxy + "'");
            }
            Optional<String> noProxyIpOrSubnet = HttpClientUtils.extractIpAddressOrSubnet(noProxy);
            if (!(noProxyIpOrSubnet.isPresent() ? new IpAddressMatcher(noProxyIpOrSubnet.get()).matches(host) : host.endsWith(noProxy))) continue;
            return true;
        }
        return false;
    }

    private static Optional<String> extractIpAddressOrSubnet(String ipAddressOrSubnet) {
        Matcher ipMatcher = IPV4_PATTERN.matcher(ipAddressOrSubnet);
        if (ipMatcher.find()) {
            return Optional.of(ipMatcher.group("ipAddressOrSubnet"));
        }
        return Optional.empty();
    }

    private static final class HeaderInterceptor
    implements Interceptor {
        private final Config config;

        private HeaderInterceptor(Config config) {
            this.config = config;
        }

        @Override
        public void before(BasicBuilder builder, HttpRequest request, Interceptor.RequestTags tags) {
            if (this.config.getCustomHeaders() != null && !this.config.getCustomHeaders().isEmpty()) {
                for (Map.Entry<String, String> entry : this.config.getCustomHeaders().entrySet()) {
                    builder.header(entry.getKey(), entry.getValue());
                }
            }
            if (this.config.getUserAgent() != null && !this.config.getUserAgent().isEmpty()) {
                builder.setHeader("User-Agent", this.config.getUserAgent());
            }
        }
    }
}

