/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.api.spec;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.fabric8.crd.generator.annotation.SchemaFrom;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.model.annotation.SpecReplicas;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.kubernetes.operator.api.diff.DiffType;
import org.apache.flink.kubernetes.operator.api.diff.Diffable;
import org.apache.flink.kubernetes.operator.api.diff.SpecDiff;
import org.apache.flink.kubernetes.operator.api.spec.KubernetesDeploymentMode;
import org.apache.flink.kubernetes.operator.api.spec.Resource;

@JsonIgnoreProperties(ignoreUnknown=true)
@Experimental
public class TaskManagerSpec
implements Diffable<TaskManagerSpec> {
    private Resource resource;
    @SpecDiff(value=DiffType.SCALE, mode={KubernetesDeploymentMode.STANDALONE})
    @SpecReplicas
    private Integer replicas;
    @SchemaFrom(type=Pod.class)
    private PodTemplateSpec podTemplate;

    public static TaskManagerSpecBuilder builder() {
        return new TaskManagerSpecBuilder();
    }

    public Resource getResource() {
        return this.resource;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public PodTemplateSpec getPodTemplate() {
        return this.podTemplate;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public void setPodTemplate(PodTemplateSpec podTemplate) {
        this.podTemplate = podTemplate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskManagerSpec)) {
            return false;
        }
        TaskManagerSpec other = (TaskManagerSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$replicas = this.getReplicas();
        Integer other$replicas = other.getReplicas();
        if (this$replicas == null ? other$replicas != null : !((Object)this$replicas).equals(other$replicas)) {
            return false;
        }
        Resource this$resource = this.getResource();
        Resource other$resource = other.getResource();
        if (this$resource == null ? other$resource != null : !((Object)this$resource).equals(other$resource)) {
            return false;
        }
        PodTemplateSpec this$podTemplate = this.getPodTemplate();
        PodTemplateSpec other$podTemplate = other.getPodTemplate();
        return !(this$podTemplate == null ? other$podTemplate != null : !this$podTemplate.equals(other$podTemplate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskManagerSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $replicas = this.getReplicas();
        result = result * 59 + ($replicas == null ? 43 : ((Object)$replicas).hashCode());
        Resource $resource = this.getResource();
        result = result * 59 + ($resource == null ? 43 : ((Object)$resource).hashCode());
        PodTemplateSpec $podTemplate = this.getPodTemplate();
        result = result * 59 + ($podTemplate == null ? 43 : $podTemplate.hashCode());
        return result;
    }

    public String toString() {
        return "TaskManagerSpec(resource=" + this.getResource() + ", replicas=" + this.getReplicas() + ", podTemplate=" + this.getPodTemplate() + ")";
    }

    public TaskManagerSpec() {
    }

    public TaskManagerSpec(Resource resource, Integer replicas, PodTemplateSpec podTemplate) {
        this.resource = resource;
        this.replicas = replicas;
        this.podTemplate = podTemplate;
    }

    public static class TaskManagerSpecBuilder {
        private Resource resource;
        private Integer replicas;
        private PodTemplateSpec podTemplate;

        TaskManagerSpecBuilder() {
        }

        public TaskManagerSpecBuilder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public TaskManagerSpecBuilder replicas(Integer replicas) {
            this.replicas = replicas;
            return this;
        }

        public TaskManagerSpecBuilder podTemplate(PodTemplateSpec podTemplate) {
            this.podTemplate = podTemplate;
            return this;
        }

        public TaskManagerSpec build() {
            return new TaskManagerSpec(this.resource, this.replicas, this.podTemplate);
        }

        public String toString() {
            return "TaskManagerSpec.TaskManagerSpecBuilder(resource=" + this.resource + ", replicas=" + this.replicas + ", podTemplate=" + this.podTemplate + ")";
        }
    }
}

