/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.api.spec;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.kubernetes.operator.api.status.SavepointFormatType;

@JsonIgnoreProperties(ignoreUnknown=true)
@Experimental
public class SavepointSpec {
    private String path;
    private SavepointFormatType formatType = SavepointFormatType.CANONICAL;
    private Boolean disposeOnDelete = true;
    private Boolean alreadyExists = false;

    public static SavepointSpecBuilder builder() {
        return new SavepointSpecBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public SavepointFormatType getFormatType() {
        return this.formatType;
    }

    public Boolean getDisposeOnDelete() {
        return this.disposeOnDelete;
    }

    public Boolean getAlreadyExists() {
        return this.alreadyExists;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setFormatType(SavepointFormatType formatType) {
        this.formatType = formatType;
    }

    public void setDisposeOnDelete(Boolean disposeOnDelete) {
        this.disposeOnDelete = disposeOnDelete;
    }

    public void setAlreadyExists(Boolean alreadyExists) {
        this.alreadyExists = alreadyExists;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SavepointSpec)) {
            return false;
        }
        SavepointSpec other = (SavepointSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$disposeOnDelete = this.getDisposeOnDelete();
        Boolean other$disposeOnDelete = other.getDisposeOnDelete();
        if (this$disposeOnDelete == null ? other$disposeOnDelete != null : !((Object)this$disposeOnDelete).equals(other$disposeOnDelete)) {
            return false;
        }
        Boolean this$alreadyExists = this.getAlreadyExists();
        Boolean other$alreadyExists = other.getAlreadyExists();
        if (this$alreadyExists == null ? other$alreadyExists != null : !((Object)this$alreadyExists).equals(other$alreadyExists)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        SavepointFormatType this$formatType = this.getFormatType();
        SavepointFormatType other$formatType = other.getFormatType();
        return !(this$formatType == null ? other$formatType != null : !((Object)((Object)this$formatType)).equals((Object)other$formatType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SavepointSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $disposeOnDelete = this.getDisposeOnDelete();
        result = result * 59 + ($disposeOnDelete == null ? 43 : ((Object)$disposeOnDelete).hashCode());
        Boolean $alreadyExists = this.getAlreadyExists();
        result = result * 59 + ($alreadyExists == null ? 43 : ((Object)$alreadyExists).hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        SavepointFormatType $formatType = this.getFormatType();
        result = result * 59 + ($formatType == null ? 43 : ((Object)((Object)$formatType)).hashCode());
        return result;
    }

    public String toString() {
        return "SavepointSpec(path=" + this.getPath() + ", formatType=" + this.getFormatType() + ", disposeOnDelete=" + this.getDisposeOnDelete() + ", alreadyExists=" + this.getAlreadyExists() + ")";
    }

    public SavepointSpec() {
    }

    public SavepointSpec(String path, SavepointFormatType formatType, Boolean disposeOnDelete, Boolean alreadyExists) {
        this.path = path;
        this.formatType = formatType;
        this.disposeOnDelete = disposeOnDelete;
        this.alreadyExists = alreadyExists;
    }

    public static class SavepointSpecBuilder {
        private String path;
        private SavepointFormatType formatType;
        private Boolean disposeOnDelete;
        private Boolean alreadyExists;

        SavepointSpecBuilder() {
        }

        public SavepointSpecBuilder path(String path) {
            this.path = path;
            return this;
        }

        public SavepointSpecBuilder formatType(SavepointFormatType formatType) {
            this.formatType = formatType;
            return this;
        }

        public SavepointSpecBuilder disposeOnDelete(Boolean disposeOnDelete) {
            this.disposeOnDelete = disposeOnDelete;
            return this;
        }

        public SavepointSpecBuilder alreadyExists(Boolean alreadyExists) {
            this.alreadyExists = alreadyExists;
            return this;
        }

        public SavepointSpec build() {
            return new SavepointSpec(this.path, this.formatType, this.disposeOnDelete, this.alreadyExists);
        }

        public String toString() {
            return "SavepointSpec.SavepointSpecBuilder(path=" + this.path + ", formatType=" + this.formatType + ", disposeOnDelete=" + this.disposeOnDelete + ", alreadyExists=" + this.alreadyExists + ")";
        }
    }
}

