/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.api.spec;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.fabric8.crd.generator.annotation.SchemaFrom;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.util.Map;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.kubernetes.operator.api.spec.AbstractFlinkSpec;
import org.apache.flink.kubernetes.operator.api.spec.FlinkVersion;
import org.apache.flink.kubernetes.operator.api.spec.IngressSpec;
import org.apache.flink.kubernetes.operator.api.spec.JobManagerSpec;
import org.apache.flink.kubernetes.operator.api.spec.KubernetesDeploymentMode;
import org.apache.flink.kubernetes.operator.api.spec.TaskManagerSpec;

@JsonIgnoreProperties(ignoreUnknown=true)
@Experimental
public class FlinkDeploymentSpec
extends AbstractFlinkSpec {
    private String image;
    private String imagePullPolicy;
    private String serviceAccount;
    private FlinkVersion flinkVersion;
    private IngressSpec ingress;
    @SchemaFrom(type=Pod.class)
    private PodTemplateSpec podTemplate;
    private JobManagerSpec jobManager;
    private TaskManagerSpec taskManager;
    private Map<String, String> logConfiguration;
    private KubernetesDeploymentMode mode;

    protected FlinkDeploymentSpec(FlinkDeploymentSpecBuilder<?, ?> b) {
        super(b);
        this.image = b.image;
        this.imagePullPolicy = b.imagePullPolicy;
        this.serviceAccount = b.serviceAccount;
        this.flinkVersion = b.flinkVersion;
        this.ingress = b.ingress;
        this.podTemplate = b.podTemplate;
        this.jobManager = b.jobManager;
        this.taskManager = b.taskManager;
        this.logConfiguration = b.logConfiguration;
        this.mode = b.mode;
    }

    public static FlinkDeploymentSpecBuilder<?, ?> builder() {
        return new FlinkDeploymentSpecBuilderImpl();
    }

    public String getImage() {
        return this.image;
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public FlinkVersion getFlinkVersion() {
        return this.flinkVersion;
    }

    public IngressSpec getIngress() {
        return this.ingress;
    }

    public PodTemplateSpec getPodTemplate() {
        return this.podTemplate;
    }

    public JobManagerSpec getJobManager() {
        return this.jobManager;
    }

    public TaskManagerSpec getTaskManager() {
        return this.taskManager;
    }

    public Map<String, String> getLogConfiguration() {
        return this.logConfiguration;
    }

    public KubernetesDeploymentMode getMode() {
        return this.mode;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
    }

    public void setServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
    }

    public void setFlinkVersion(FlinkVersion flinkVersion) {
        this.flinkVersion = flinkVersion;
    }

    public void setIngress(IngressSpec ingress) {
        this.ingress = ingress;
    }

    public void setPodTemplate(PodTemplateSpec podTemplate) {
        this.podTemplate = podTemplate;
    }

    public void setJobManager(JobManagerSpec jobManager) {
        this.jobManager = jobManager;
    }

    public void setTaskManager(TaskManagerSpec taskManager) {
        this.taskManager = taskManager;
    }

    public void setLogConfiguration(Map<String, String> logConfiguration) {
        this.logConfiguration = logConfiguration;
    }

    public void setMode(KubernetesDeploymentMode mode) {
        this.mode = mode;
    }

    public FlinkDeploymentSpec() {
    }

    public FlinkDeploymentSpec(String image, String imagePullPolicy, String serviceAccount, FlinkVersion flinkVersion, IngressSpec ingress, PodTemplateSpec podTemplate, JobManagerSpec jobManager, TaskManagerSpec taskManager, Map<String, String> logConfiguration, KubernetesDeploymentMode mode) {
        this.image = image;
        this.imagePullPolicy = imagePullPolicy;
        this.serviceAccount = serviceAccount;
        this.flinkVersion = flinkVersion;
        this.ingress = ingress;
        this.podTemplate = podTemplate;
        this.jobManager = jobManager;
        this.taskManager = taskManager;
        this.logConfiguration = logConfiguration;
        this.mode = mode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlinkDeploymentSpec)) {
            return false;
        }
        FlinkDeploymentSpec other = (FlinkDeploymentSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        String this$imagePullPolicy = this.getImagePullPolicy();
        String other$imagePullPolicy = other.getImagePullPolicy();
        if (this$imagePullPolicy == null ? other$imagePullPolicy != null : !this$imagePullPolicy.equals(other$imagePullPolicy)) {
            return false;
        }
        String this$serviceAccount = this.getServiceAccount();
        String other$serviceAccount = other.getServiceAccount();
        if (this$serviceAccount == null ? other$serviceAccount != null : !this$serviceAccount.equals(other$serviceAccount)) {
            return false;
        }
        FlinkVersion this$flinkVersion = this.getFlinkVersion();
        FlinkVersion other$flinkVersion = other.getFlinkVersion();
        if (this$flinkVersion == null ? other$flinkVersion != null : !((Object)((Object)this$flinkVersion)).equals((Object)other$flinkVersion)) {
            return false;
        }
        IngressSpec this$ingress = this.getIngress();
        IngressSpec other$ingress = other.getIngress();
        if (this$ingress == null ? other$ingress != null : !((Object)this$ingress).equals(other$ingress)) {
            return false;
        }
        PodTemplateSpec this$podTemplate = this.getPodTemplate();
        PodTemplateSpec other$podTemplate = other.getPodTemplate();
        if (this$podTemplate == null ? other$podTemplate != null : !this$podTemplate.equals(other$podTemplate)) {
            return false;
        }
        JobManagerSpec this$jobManager = this.getJobManager();
        JobManagerSpec other$jobManager = other.getJobManager();
        if (this$jobManager == null ? other$jobManager != null : !((Object)this$jobManager).equals(other$jobManager)) {
            return false;
        }
        TaskManagerSpec this$taskManager = this.getTaskManager();
        TaskManagerSpec other$taskManager = other.getTaskManager();
        if (this$taskManager == null ? other$taskManager != null : !((Object)this$taskManager).equals(other$taskManager)) {
            return false;
        }
        Map<String, String> this$logConfiguration = this.getLogConfiguration();
        Map<String, String> other$logConfiguration = other.getLogConfiguration();
        if (this$logConfiguration == null ? other$logConfiguration != null : !((Object)this$logConfiguration).equals(other$logConfiguration)) {
            return false;
        }
        KubernetesDeploymentMode this$mode = this.getMode();
        KubernetesDeploymentMode other$mode = other.getMode();
        return !(this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FlinkDeploymentSpec;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        String $imagePullPolicy = this.getImagePullPolicy();
        result = result * 59 + ($imagePullPolicy == null ? 43 : $imagePullPolicy.hashCode());
        String $serviceAccount = this.getServiceAccount();
        result = result * 59 + ($serviceAccount == null ? 43 : $serviceAccount.hashCode());
        FlinkVersion $flinkVersion = this.getFlinkVersion();
        result = result * 59 + ($flinkVersion == null ? 43 : ((Object)((Object)$flinkVersion)).hashCode());
        IngressSpec $ingress = this.getIngress();
        result = result * 59 + ($ingress == null ? 43 : ((Object)$ingress).hashCode());
        PodTemplateSpec $podTemplate = this.getPodTemplate();
        result = result * 59 + ($podTemplate == null ? 43 : $podTemplate.hashCode());
        JobManagerSpec $jobManager = this.getJobManager();
        result = result * 59 + ($jobManager == null ? 43 : ((Object)$jobManager).hashCode());
        TaskManagerSpec $taskManager = this.getTaskManager();
        result = result * 59 + ($taskManager == null ? 43 : ((Object)$taskManager).hashCode());
        Map<String, String> $logConfiguration = this.getLogConfiguration();
        result = result * 59 + ($logConfiguration == null ? 43 : ((Object)$logConfiguration).hashCode());
        KubernetesDeploymentMode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "FlinkDeploymentSpec(super=" + super.toString() + ", image=" + this.getImage() + ", imagePullPolicy=" + this.getImagePullPolicy() + ", serviceAccount=" + this.getServiceAccount() + ", flinkVersion=" + this.getFlinkVersion() + ", ingress=" + this.getIngress() + ", podTemplate=" + this.getPodTemplate() + ", jobManager=" + this.getJobManager() + ", taskManager=" + this.getTaskManager() + ", logConfiguration=" + this.getLogConfiguration() + ", mode=" + this.getMode() + ")";
    }

    private static final class FlinkDeploymentSpecBuilderImpl
    extends FlinkDeploymentSpecBuilder<FlinkDeploymentSpec, FlinkDeploymentSpecBuilderImpl> {
        private FlinkDeploymentSpecBuilderImpl() {
        }

        @Override
        protected FlinkDeploymentSpecBuilderImpl self() {
            return this;
        }

        @Override
        public FlinkDeploymentSpec build() {
            return new FlinkDeploymentSpec(this);
        }
    }

    public static abstract class FlinkDeploymentSpecBuilder<C extends FlinkDeploymentSpec, B extends FlinkDeploymentSpecBuilder<C, B>>
    extends AbstractFlinkSpec.AbstractFlinkSpecBuilder<C, B> {
        private String image;
        private String imagePullPolicy;
        private String serviceAccount;
        private FlinkVersion flinkVersion;
        private IngressSpec ingress;
        private PodTemplateSpec podTemplate;
        private JobManagerSpec jobManager;
        private TaskManagerSpec taskManager;
        private Map<String, String> logConfiguration;
        private KubernetesDeploymentMode mode;

        public B image(String image) {
            this.image = image;
            return (B)this.self();
        }

        public B imagePullPolicy(String imagePullPolicy) {
            this.imagePullPolicy = imagePullPolicy;
            return (B)this.self();
        }

        public B serviceAccount(String serviceAccount) {
            this.serviceAccount = serviceAccount;
            return (B)this.self();
        }

        public B flinkVersion(FlinkVersion flinkVersion) {
            this.flinkVersion = flinkVersion;
            return (B)this.self();
        }

        public B ingress(IngressSpec ingress) {
            this.ingress = ingress;
            return (B)this.self();
        }

        public B podTemplate(PodTemplateSpec podTemplate) {
            this.podTemplate = podTemplate;
            return (B)this.self();
        }

        public B jobManager(JobManagerSpec jobManager) {
            this.jobManager = jobManager;
            return (B)this.self();
        }

        public B taskManager(TaskManagerSpec taskManager) {
            this.taskManager = taskManager;
            return (B)this.self();
        }

        public B logConfiguration(Map<String, String> logConfiguration) {
            this.logConfiguration = logConfiguration;
            return (B)this.self();
        }

        public B mode(KubernetesDeploymentMode mode) {
            this.mode = mode;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "FlinkDeploymentSpec.FlinkDeploymentSpecBuilder(super=" + super.toString() + ", image=" + this.image + ", imagePullPolicy=" + this.imagePullPolicy + ", serviceAccount=" + this.serviceAccount + ", flinkVersion=" + this.flinkVersion + ", ingress=" + this.ingress + ", podTemplate=" + this.podTemplate + ", jobManager=" + this.jobManager + ", taskManager=" + this.taskManager + ", logConfiguration=" + this.logConfiguration + ", mode=" + this.mode + ")";
        }
    }
}

