/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.operators.Keys;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.PartitionOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.KeyFunctions;
import org.apache.flink.api.java.operators.SingleInputOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

@Public
public class PartitionOperator<T>
extends SingleInputOperator<T, T, PartitionOperator<T>> {
    private final Keys<T> pKeys;
    private final PartitionOperatorBase.PartitionMethod pMethod;
    private final String partitionLocationName;
    private final Partitioner<?> customPartitioner;

    public PartitionOperator(DataSet<T> input, PartitionOperatorBase.PartitionMethod pMethod, Keys<T> pKeys, String partitionLocationName) {
        this(input, pMethod, pKeys, null, null, partitionLocationName);
    }

    public PartitionOperator(DataSet<T> input, PartitionOperatorBase.PartitionMethod pMethod, String partitionLocationName) {
        this(input, pMethod, null, null, null, partitionLocationName);
    }

    public PartitionOperator(DataSet<T> input, Keys<T> pKeys, Partitioner<?> customPartitioner, String partitionLocationName) {
        this(input, PartitionOperatorBase.PartitionMethod.CUSTOM, pKeys, customPartitioner, null, partitionLocationName);
    }

    public <P> PartitionOperator(DataSet<T> input, Keys<T> pKeys, Partitioner<P> customPartitioner, TypeInformation<P> partitionerTypeInfo, String partitionLocationName) {
        this(input, PartitionOperatorBase.PartitionMethod.CUSTOM, pKeys, customPartitioner, partitionerTypeInfo, partitionLocationName);
    }

    private <P> PartitionOperator(DataSet<T> input, PartitionOperatorBase.PartitionMethod pMethod, Keys<T> pKeys, Partitioner<P> customPartitioner, TypeInformation<P> partitionerTypeInfo, String partitionLocationName) {
        super(input, input.getType());
        Preconditions.checkNotNull(pMethod);
        Preconditions.checkArgument(pKeys != null || pMethod == PartitionOperatorBase.PartitionMethod.REBALANCE, "Partitioning requires keys");
        Preconditions.checkArgument(pMethod != PartitionOperatorBase.PartitionMethod.CUSTOM || customPartitioner != null, "Custom partioning requires a partitioner.");
        if (customPartitioner != null) {
            pKeys.validateCustomPartitioner(customPartitioner, partitionerTypeInfo);
        }
        this.pMethod = pMethod;
        this.pKeys = pKeys;
        this.partitionLocationName = partitionLocationName;
        this.customPartitioner = customPartitioner;
    }

    @Internal
    public Partitioner<?> getCustomPartitioner() {
        return this.customPartitioner;
    }

    protected org.apache.flink.api.common.operators.SingleInputOperator<?, T, ?> translateToDataFlow(Operator<T> input) {
        String name = "Partition at " + this.partitionLocationName;
        if (this.pMethod == PartitionOperatorBase.PartitionMethod.REBALANCE) {
            UnaryOperatorInformation operatorInfo = new UnaryOperatorInformation(this.getType(), this.getType());
            PartitionOperatorBase rebalancedInput = new PartitionOperatorBase(operatorInfo, this.pMethod, name);
            rebalancedInput.setInput(input);
            rebalancedInput.setParallelism(this.getParallelism());
            return rebalancedInput;
        }
        if (this.pMethod == PartitionOperatorBase.PartitionMethod.HASH || this.pMethod == PartitionOperatorBase.PartitionMethod.CUSTOM || this.pMethod == PartitionOperatorBase.PartitionMethod.RANGE) {
            if (this.pKeys instanceof Keys.ExpressionKeys) {
                int[] logicalKeyPositions = this.pKeys.computeLogicalKeyPositions();
                UnaryOperatorInformation operatorInfo = new UnaryOperatorInformation(this.getType(), this.getType());
                PartitionOperatorBase partitionedInput = new PartitionOperatorBase(operatorInfo, this.pMethod, logicalKeyPositions, name);
                partitionedInput.setInput(input);
                partitionedInput.setParallelism(this.getParallelism());
                partitionedInput.setCustomPartitioner(this.customPartitioner);
                return partitionedInput;
            }
            if (this.pKeys instanceof Keys.SelectorFunctionKeys) {
                Keys.SelectorFunctionKeys selectorKeys = (Keys.SelectorFunctionKeys)this.pKeys;
                return PartitionOperator.translateSelectorFunctionPartitioner(selectorKeys, this.pMethod, name, input, this.getParallelism(), this.customPartitioner);
            }
            throw new UnsupportedOperationException("Unrecognized key type.");
        }
        throw new UnsupportedOperationException("Unsupported partitioning method: " + this.pMethod.name());
    }

    private static <T, K> org.apache.flink.api.common.operators.SingleInputOperator<?, T, ?> translateSelectorFunctionPartitioner(Keys.SelectorFunctionKeys<T, ?> rawKeys, PartitionOperatorBase.PartitionMethod pMethod, String name, Operator<T> input, int partitionDop, Partitioner<?> customPartitioner) {
        Keys.SelectorFunctionKeys<T, ?> keys = rawKeys;
        TypeInformation<Tuple2<?, T>> typeInfoWithKey = KeyFunctions.createTypeWithKey(keys);
        Operator<Tuple2<?, T>> keyedInput = KeyFunctions.appendKeyExtractor(input, keys);
        PartitionOperatorBase keyedPartitionedInput = new PartitionOperatorBase(new UnaryOperatorInformation(typeInfoWithKey, typeInfoWithKey), pMethod, new int[]{0}, name);
        keyedPartitionedInput.setInput(keyedInput);
        keyedPartitionedInput.setCustomPartitioner(customPartitioner);
        keyedPartitionedInput.setParallelism(partitionDop);
        return KeyFunctions.appendKeyRemover(keyedPartitionedInput, keys);
    }
}

