/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.functions.CombineFunction;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.operators.Keys;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.GroupReduceOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.SemanticPropUtil;
import org.apache.flink.api.java.operators.Grouping;
import org.apache.flink.api.java.operators.KeyFunctions;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.api.java.operators.SortedGrouping;
import org.apache.flink.api.java.operators.UdfOperatorUtils;
import org.apache.flink.api.java.operators.translation.CombineToGroupCombineWrapper;
import org.apache.flink.api.java.operators.translation.PlanUnwrappingReduceGroupOperator;
import org.apache.flink.api.java.operators.translation.PlanUnwrappingSortedReduceGroupOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Public
public class GroupReduceOperator<IN, OUT>
extends SingleInputUdfOperator<IN, OUT, GroupReduceOperator<IN, OUT>> {
    private static final Logger LOG = LoggerFactory.getLogger(GroupReduceOperator.class);
    private GroupReduceFunction<IN, OUT> function;
    private final Grouping<IN> grouper;
    private final String defaultName;
    private boolean combinable;

    public GroupReduceOperator(DataSet<IN> input, TypeInformation<OUT> resultType, GroupReduceFunction<IN, OUT> function, String defaultName) {
        super(input, resultType);
        this.function = function;
        this.grouper = null;
        this.defaultName = defaultName;
        this.combinable = this.checkCombinability();
    }

    public GroupReduceOperator(Grouping<IN> input, TypeInformation<OUT> resultType, GroupReduceFunction<IN, OUT> function, String defaultName) {
        super(input != null ? input.getInputDataSet() : null, resultType);
        this.function = function;
        this.grouper = input;
        this.defaultName = defaultName;
        this.combinable = this.checkCombinability();
        UdfOperatorUtils.analyzeSingleInputUdf(this, GroupReduceFunction.class, defaultName, function, this.grouper.keys);
    }

    private boolean checkCombinability() {
        if (this.function instanceof GroupCombineFunction || this.function instanceof CombineFunction) {
            Type[] genInterfaces;
            Type[] reduceTypes = null;
            Type[] combineTypes = null;
            for (Type genInterface : genInterfaces = this.function.getClass().getGenericInterfaces()) {
                if (!(genInterface instanceof ParameterizedType)) continue;
                if (((ParameterizedType)genInterface).getRawType().equals(GroupReduceFunction.class)) {
                    reduceTypes = ((ParameterizedType)genInterface).getActualTypeArguments();
                    continue;
                }
                if (!((ParameterizedType)genInterface).getRawType().equals(GroupCombineFunction.class) && !((ParameterizedType)genInterface).getRawType().equals(CombineFunction.class)) continue;
                combineTypes = ((ParameterizedType)genInterface).getActualTypeArguments();
            }
            if (reduceTypes != null && reduceTypes.length == 2 && combineTypes != null && combineTypes.length == 2) {
                if (reduceTypes[0].equals(combineTypes[0]) && reduceTypes[0].equals(combineTypes[1])) {
                    return true;
                }
                LOG.warn("GroupCombineFunction cannot be used as combiner for GroupReduceFunction. Generic types are incompatible.");
                return false;
            }
            if (reduceTypes == null || reduceTypes.length != 2) {
                LOG.warn("Cannot check generic types of GroupReduceFunction. Enabling combiner but combine function might fail at runtime.");
                return true;
            }
            LOG.warn("Cannot check generic types of GroupCombineFunction. Enabling combiner but combine function might fail at runtime.");
            return true;
        }
        return false;
    }

    protected GroupReduceFunction<IN, OUT> getFunction() {
        return this.function;
    }

    @Internal
    public boolean isCombinable() {
        return this.combinable;
    }

    public GroupReduceOperator<IN, OUT> setCombinable(boolean combinable) {
        if (combinable) {
            if (!this.checkCombinability()) {
                throw new IllegalArgumentException("Either the function does not implement a combine interface, or the types of the combine() and reduce() methods are not compatible.");
            }
            this.combinable = true;
        } else {
            this.combinable = false;
        }
        return this;
    }

    @Override
    @Internal
    public SingleInputSemanticProperties getSemanticProperties() {
        SingleInputSemanticProperties props = super.getSemanticProperties();
        if (props != null && this.grouper != null && this.grouper.keys instanceof Keys.SelectorFunctionKeys) {
            int offset = ((Keys.SelectorFunctionKeys)this.grouper.keys).getKeyType().getTotalFields();
            if (this.grouper instanceof SortedGrouping) {
                offset += ((SortedGrouping)this.grouper).getSortSelectionFunctionKey().getKeyType().getTotalFields();
            }
            props = SemanticPropUtil.addSourceFieldOffset(props, this.getInputType().getTotalFields(), offset);
        }
        return props;
    }

    protected GroupReduceOperatorBase<?, OUT, ?> translateToDataFlow(Operator<IN> input) {
        String name = this.getName() != null ? this.getName() : "GroupReduce at " + this.defaultName;
        CombineToGroupCombineWrapper combineToGroupCombineWrapper = this.function = this.combinable && this.function instanceof CombineFunction ? new CombineToGroupCombineWrapper((CombineFunction)this.function) : this.function;
        if (this.grouper == null) {
            UnaryOperatorInformation operatorInfo = new UnaryOperatorInformation(this.getInputType(), this.getResultType());
            GroupReduceOperatorBase po = new GroupReduceOperatorBase(this.function, operatorInfo, new int[0], name);
            po.setCombinable(this.combinable);
            po.setInput(input);
            po.setParallelism(1);
            return po;
        }
        if (this.grouper.getKeys() instanceof Keys.SelectorFunctionKeys) {
            Keys.SelectorFunctionKeys selectorKeys = (Keys.SelectorFunctionKeys)this.grouper.getKeys();
            if (this.grouper instanceof SortedGrouping) {
                SortedGrouping sortedGrouping = (SortedGrouping)this.grouper;
                Keys.SelectorFunctionKeys sortKeys = sortedGrouping.getSortSelectionFunctionKey();
                Ordering groupOrder = sortedGrouping.getGroupOrdering();
                PlanUnwrappingSortedReduceGroupOperator po = GroupReduceOperator.translateSelectorFunctionSortedReducer(selectorKeys, sortKeys, groupOrder, this.function, this.getResultType(), name, input, this.isCombinable());
                po.setParallelism(this.getParallelism());
                po.setCustomPartitioner(this.grouper.getCustomPartitioner());
                return po;
            }
            PlanUnwrappingReduceGroupOperator po = GroupReduceOperator.translateSelectorFunctionReducer(selectorKeys, this.function, this.getResultType(), name, input, this.isCombinable());
            po.setParallelism(this.getParallelism());
            po.setCustomPartitioner(this.grouper.getCustomPartitioner());
            return po;
        }
        if (this.grouper.getKeys() instanceof Keys.ExpressionKeys) {
            int[] logicalKeyPositions = this.grouper.getKeys().computeLogicalKeyPositions();
            UnaryOperatorInformation operatorInfo = new UnaryOperatorInformation(this.getInputType(), this.getResultType());
            GroupReduceOperatorBase po = new GroupReduceOperatorBase(this.function, operatorInfo, logicalKeyPositions, name);
            po.setCombinable(this.combinable);
            po.setInput(input);
            po.setParallelism(this.getParallelism());
            po.setCustomPartitioner(this.grouper.getCustomPartitioner());
            if (this.grouper instanceof SortedGrouping) {
                SortedGrouping sortedGrouper = (SortedGrouping)this.grouper;
                int[] sortKeyPositions = sortedGrouper.getGroupSortKeyPositions();
                Order[] sortOrders = sortedGrouper.getGroupSortOrders();
                Ordering o = new Ordering();
                for (int i = 0; i < sortKeyPositions.length; ++i) {
                    o.appendOrdering(Integer.valueOf(sortKeyPositions[i]), null, sortOrders[i]);
                }
                po.setGroupOrder(o);
            }
            return po;
        }
        throw new UnsupportedOperationException("Unrecognized key type.");
    }

    private static <IN, OUT, K> PlanUnwrappingReduceGroupOperator<IN, OUT, K> translateSelectorFunctionReducer(Keys.SelectorFunctionKeys<IN, ?> rawKeys, GroupReduceFunction<IN, OUT> function, TypeInformation<OUT> outputType, String name, Operator<IN> input, boolean combinable) {
        Keys.SelectorFunctionKeys<IN, ?> keys = rawKeys;
        TypeInformation<Tuple2<?, IN>> typeInfoWithKey = KeyFunctions.createTypeWithKey(keys);
        Operator<Tuple2<?, IN>> keyedInput = KeyFunctions.appendKeyExtractor(input, keys);
        PlanUnwrappingReduceGroupOperator reducer = new PlanUnwrappingReduceGroupOperator(function, keys, name, outputType, typeInfoWithKey, combinable);
        reducer.setInput(keyedInput);
        return reducer;
    }

    private static <IN, OUT, K1, K2> PlanUnwrappingSortedReduceGroupOperator<IN, OUT, K1, K2> translateSelectorFunctionSortedReducer(Keys.SelectorFunctionKeys<IN, ?> rawGroupingKey, Keys.SelectorFunctionKeys<IN, ?> rawSortingKey, Ordering groupOrdering, GroupReduceFunction<IN, OUT> function, TypeInformation<OUT> outputType, String name, Operator<IN> input, boolean combinable) {
        Keys.SelectorFunctionKeys<IN, ?> groupingKey = rawGroupingKey;
        Keys.SelectorFunctionKeys<IN, ?> sortingKey = rawSortingKey;
        TypeInformation<Tuple3<?, ?, IN>> typeInfoWithKey = KeyFunctions.createTypeWithKey(groupingKey, sortingKey);
        Operator<Tuple3<?, ?, IN>> inputWithKey = KeyFunctions.appendKeyExtractor(input, groupingKey, sortingKey);
        PlanUnwrappingSortedReduceGroupOperator reducer = new PlanUnwrappingSortedReduceGroupOperator(function, groupingKey, sortingKey, name, outputType, typeInfoWithKey, combinable);
        reducer.setInput(inputWithKey);
        reducer.setGroupOrder(groupOrdering);
        return reducer;
    }
}

