/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.GenericArraySerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;

public class ObjectArrayTypeInfo<T, C>
extends TypeInformation<T> {
    private static final long serialVersionUID = 1L;
    private final Type arrayType;
    private final Type componentType;
    private final TypeInformation<C> componentInfo;

    private ObjectArrayTypeInfo(Type arrayType, Type componentType) {
        this.arrayType = arrayType;
        this.componentType = componentType;
        this.componentInfo = TypeExtractor.createTypeInfo(componentType);
    }

    private ObjectArrayTypeInfo(Type arrayType, Type componentType, TypeInformation<C> componentInfo) {
        this.arrayType = arrayType;
        this.componentType = componentType;
        this.componentInfo = componentInfo;
    }

    public boolean isBasicType() {
        return false;
    }

    public boolean isTupleType() {
        return false;
    }

    public int getArity() {
        return 1;
    }

    public int getTotalFields() {
        return 1;
    }

    public Class<T> getTypeClass() {
        if (this.arrayType instanceof Class) {
            return (Class)this.arrayType;
        }
        Class componentClass = (Class)((ParameterizedType)this.componentType).getRawType();
        try {
            return Class.forName("[L" + componentClass.getName() + ";");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot create non-generic type class.", e);
        }
    }

    public Type getType() {
        return this.arrayType;
    }

    public Type getComponentType() {
        return this.componentType;
    }

    public TypeInformation<C> getComponentInfo() {
        return this.componentInfo;
    }

    public boolean isKeyType() {
        return false;
    }

    public TypeSerializer<T> createSerializer(ExecutionConfig executionConfig) {
        if (this.componentType instanceof GenericArrayType) {
            ParameterizedType paramType = (ParameterizedType)((GenericArrayType)this.componentType).getGenericComponentType();
            return new GenericArraySerializer((Class)paramType.getRawType(), this.componentInfo.createSerializer(executionConfig));
        }
        return new GenericArraySerializer((Class)this.componentType, this.componentInfo.createSerializer(executionConfig));
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "<" + this.componentInfo + ">";
    }

    public static <T, C> ObjectArrayTypeInfo<T, C> getInfoFor(Type type, TypeInformation<C> componentInfo) {
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArray = (GenericArrayType)type;
            return new ObjectArrayTypeInfo<T, C>(type, genericArray.getGenericComponentType(), componentInfo);
        }
        if (type instanceof Class && ((Class)type).isArray() && BasicTypeInfo.getInfoFor((Class)((Class)type)) == null) {
            return new ObjectArrayTypeInfo<T, C>(type, ((Class)type).getComponentType(), componentInfo);
        }
        throw new InvalidTypesException("The given type is not a valid object array.");
    }

    public static <T, C> ObjectArrayTypeInfo<T, C> getInfoFor(TypeInformation<C> componentInfo) {
        return new ObjectArrayTypeInfo<T, C>(Array.newInstance(componentInfo.getTypeClass(), 0).getClass(), componentInfo.getTypeClass(), componentInfo);
    }

    public static <T, C> ObjectArrayTypeInfo<T, C> getInfoFor(Type type) {
        if (type instanceof Class && ((Class)type).isArray() && BasicTypeInfo.getInfoFor((Class)((Class)type)) == null) {
            Class array = (Class)type;
            return new ObjectArrayTypeInfo<T, C>(type, array.getComponentType());
        }
        throw new InvalidTypesException("The given type is not a valid object array.");
    }
}

