/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.record.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import org.apache.flink.api.java.record.io.ExternalProcessInputSplit;
import org.apache.flink.api.java.record.io.GenericInputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.GenericInputSplit;

public abstract class ExternalProcessInputFormat<T extends ExternalProcessInputSplit>
extends GenericInputFormat {
    private static final long serialVersionUID = 1L;
    public static final String ALLOWEDEXITCODES_PARAMETER_KEY = "pact.input.externalProcess.allowedExitCodes";
    private Process extProc;
    protected InputStream extProcOutStream;
    protected InputStream extProcErrStream;
    protected int[] allowedExitCodes;

    public void configure(Configuration parameters) {
        String allowedExitCodesList = parameters.getString(ALLOWEDEXITCODES_PARAMETER_KEY, "0");
        StringTokenizer st = new StringTokenizer(allowedExitCodesList, ",");
        this.allowedExitCodes = new int[st.countTokens()];
        for (int i = 0; i < this.allowedExitCodes.length; ++i) {
            this.allowedExitCodes[i] = Integer.parseInt(st.nextToken().trim());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            int exitCode = this.extProc.exitValue();
            boolean exitCodeOk = false;
            for (int allowedExitCode : this.allowedExitCodes) {
                if (allowedExitCode != exitCode) continue;
                exitCodeOk = true;
                break;
            }
            if (!exitCodeOk) {
                throw new RuntimeException("External process did not finish with an allowed exit code: " + exitCode);
            }
        }
        catch (IllegalThreadStateException itse) {
            this.extProc.destroy();
            if (!this.reachedEnd()) {
                throw new RuntimeException("External process was destroyed although stream was not fully read.");
            }
        }
        finally {
            this.extProcErrStream.close();
            this.extProcOutStream.close();
        }
    }

    public void open(GenericInputSplit split) throws IOException {
        if (!(split instanceof ExternalProcessInputSplit)) {
            throw new IOException("Invalid InputSplit type.");
        }
        ExternalProcessInputSplit epSplit = (ExternalProcessInputSplit)split;
        if (epSplit.getExternalProcessCommand() != null && !epSplit.getExternalProcessCommand().equals("")) {
            try {
                this.extProc = Runtime.getRuntime().exec(epSplit.getExternalProcessCommand());
            }
            catch (IOException e) {
                throw new IOException("IO Exception when starting external process: " + epSplit.getExternalProcessCommand());
            }
        } else {
            throw new IllegalArgumentException("External Process Command not set");
        }
        this.extProcOutStream = this.extProc.getInputStream();
        this.extProcErrStream = this.extProc.getErrorStream();
    }

    public void waitForProcessToFinish() throws InterruptedException {
        this.extProc.waitFor();
    }
}

