/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.GroupReduceOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.aggregation.AggregationFunction;
import org.apache.flink.api.java.aggregation.AggregationFunctionFactory;
import org.apache.flink.api.java.aggregation.Aggregations;
import org.apache.flink.api.java.operators.Grouping;
import org.apache.flink.api.java.operators.Keys;
import org.apache.flink.api.java.operators.SingleInputOperator;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.TupleTypeInfoBase;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.util.Collector;

public class AggregateOperator<IN>
extends SingleInputOperator<IN, IN, AggregateOperator<IN>> {
    private final List<AggregationFunction<?>> aggregationFunctions = new ArrayList(4);
    private final List<Integer> fields = new ArrayList<Integer>(4);
    private final Grouping<IN> grouping;
    private final String aggregateLocationName;

    public AggregateOperator(DataSet<IN> input, Aggregations function, int field, String aggregateLocationName) {
        super(Preconditions.checkNotNull(input), input.getType());
        Preconditions.checkNotNull(function);
        this.aggregateLocationName = aggregateLocationName;
        if (!input.getType().isTupleType()) {
            throw new InvalidProgramException("Aggregating on field positions is only possible on tuple data types.");
        }
        TupleTypeInfoBase inType = (TupleTypeInfoBase)input.getType();
        if (field < 0 || field >= inType.getArity()) {
            throw new IllegalArgumentException("Aggregation field position is out of range.");
        }
        AggregationFunctionFactory factory = function.getFactory();
        AggregationFunction aggFunct = factory.createAggregationFunction(inType.getTypeAt(field).getTypeClass());
        this.aggregationFunctions.add(aggFunct);
        this.fields.add(field);
        this.grouping = null;
    }

    public AggregateOperator(Grouping<IN> input, Aggregations function, int field, String aggregateLocationName) {
        super(Preconditions.checkNotNull(input).getDataSet(), input.getDataSet().getType());
        Preconditions.checkNotNull(function);
        this.aggregateLocationName = aggregateLocationName;
        if (!input.getDataSet().getType().isTupleType()) {
            throw new InvalidProgramException("Aggregating on field positions is only possible on tuple data types.");
        }
        TupleTypeInfoBase inType = (TupleTypeInfoBase)input.getDataSet().getType();
        if (field < 0 || field >= inType.getArity()) {
            throw new IllegalArgumentException("Aggregation field position is out of range.");
        }
        AggregationFunctionFactory factory = function.getFactory();
        AggregationFunction aggFunct = factory.createAggregationFunction(inType.getTypeAt(field).getTypeClass());
        this.aggregationFunctions.add(aggFunct);
        this.fields.add(field);
        this.grouping = input;
    }

    public AggregateOperator<IN> and(Aggregations function, int field) {
        Preconditions.checkNotNull(function);
        TupleTypeInfoBase inType = (TupleTypeInfoBase)this.getType();
        if (field < 0 || field >= inType.getArity()) {
            throw new IllegalArgumentException("Aggregation field position is out of range.");
        }
        AggregationFunctionFactory factory = function.getFactory();
        AggregationFunction aggFunct = factory.createAggregationFunction(inType.getTypeAt(field).getTypeClass());
        this.aggregationFunctions.add(aggFunct);
        this.fields.add(field);
        return this;
    }

    public AggregateOperator<IN> andSum(int field) {
        return this.and(Aggregations.SUM, field);
    }

    public AggregateOperator<IN> andMin(int field) {
        return this.and(Aggregations.MIN, field);
    }

    public AggregateOperator<IN> andMax(int field) {
        return this.and(Aggregations.MAX, field);
    }

    protected GroupReduceOperatorBase<IN, IN, GroupReduceFunction<IN, IN>> translateToDataFlow(Operator<IN> input) {
        String name;
        if (this.aggregationFunctions.isEmpty() || this.aggregationFunctions.size() != this.fields.size()) {
            throw new IllegalStateException();
        }
        AggregationFunction[] aggFunctions = new AggregationFunction[this.aggregationFunctions.size()];
        int[] fields = new int[this.fields.size()];
        StringBuilder genName = new StringBuilder();
        for (int i = 0; i < fields.length; ++i) {
            aggFunctions[i] = this.aggregationFunctions.get(i);
            fields[i] = this.fields.get(i);
            genName.append(aggFunctions[i].toString()).append('(').append(fields[i]).append(')').append(',');
        }
        genName.append(" at ").append(this.aggregateLocationName);
        genName.setLength(genName.length() - 1);
        AggregatingUdf function = new AggregatingUdf(aggFunctions, fields);
        String string = name = this.getName() != null ? this.getName() : genName.toString();
        if (this.grouping == null) {
            UnaryOperatorInformation operatorInfo = new UnaryOperatorInformation(this.getInputType(), this.getResultType());
            GroupReduceOperatorBase po = new GroupReduceOperatorBase(function, operatorInfo, new int[0], name);
            po.setCombinable(true);
            po.setInput(input);
            po.setParallelism(this.getParallelism());
            return po;
        }
        if (this.grouping.getKeys() instanceof Keys.ExpressionKeys) {
            int[] logicalKeyPositions = this.grouping.getKeys().computeLogicalKeyPositions();
            UnaryOperatorInformation operatorInfo = new UnaryOperatorInformation(this.getInputType(), this.getResultType());
            GroupReduceOperatorBase po = new GroupReduceOperatorBase(function, operatorInfo, logicalKeyPositions, name);
            po.setCombinable(true);
            po.setInput(input);
            po.setParallelism(this.getParallelism());
            po.setCustomPartitioner(this.grouping.getCustomPartitioner());
            SingleInputSemanticProperties props = new SingleInputSemanticProperties();
            for (int i = 0; i < logicalKeyPositions.length; ++i) {
                int keyField = logicalKeyPositions[i];
                boolean keyFieldUsedInAgg = false;
                for (int k = 0; k < fields.length; ++k) {
                    int aggField = fields[k];
                    if (keyField != aggField) continue;
                    keyFieldUsedInAgg = true;
                    break;
                }
                if (keyFieldUsedInAgg) continue;
                props.addForwardedField(keyField, keyField);
            }
            po.setSemanticProperties(props);
            return po;
        }
        if (this.grouping.getKeys() instanceof Keys.SelectorFunctionKeys) {
            throw new UnsupportedOperationException("Aggregate does not support grouping with KeySelector functions, yet.");
        }
        throw new UnsupportedOperationException("Unrecognized key type.");
    }

    @RichGroupReduceFunction.Combinable
    public static final class AggregatingUdf<T extends Tuple>
    extends RichGroupReduceFunction<T, T> {
        private static final long serialVersionUID = 1L;
        private final int[] fieldPositions;
        private final AggregationFunction<Object>[] aggFunctions;

        public AggregatingUdf(AggregationFunction<Object>[] aggFunctions, int[] fieldPositions) {
            Preconditions.checkNotNull(aggFunctions);
            Preconditions.checkNotNull(aggFunctions);
            Preconditions.checkArgument(aggFunctions.length == fieldPositions.length);
            this.aggFunctions = aggFunctions;
            this.fieldPositions = fieldPositions;
        }

        public void open(Configuration parameters) throws Exception {
            for (int i = 0; i < this.aggFunctions.length; ++i) {
                this.aggFunctions[i].initializeAggregate();
            }
        }

        public void reduce(Iterable<T> records, Collector<T> out) {
            int i;
            AggregationFunction<Object>[] aggFunctions = this.aggFunctions;
            int[] fieldPositions = this.fieldPositions;
            Tuple current2 = null;
            for (Tuple current2 : records) {
                for (i = 0; i < fieldPositions.length; ++i) {
                    Object val = current2.getFieldNotNull(fieldPositions[i]);
                    aggFunctions[i].aggregate(val);
                }
            }
            for (i = 0; i < fieldPositions.length; ++i) {
                Object aggVal = aggFunctions[i].getAggregate();
                current2.setField(aggVal, fieldPositions[i]);
                aggFunctions[i].initializeAggregate();
            }
            out.collect((Object)current2);
        }
    }
}

