/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.IOException;
import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.io.RemoteCollector;
import org.apache.flink.configuration.Configuration;

public class RemoteCollectorOutputFormat<T>
implements OutputFormat<T> {
    private static final long serialVersionUID = 1922744224032398102L;
    private transient RemoteCollector<T> remoteCollector;
    private transient Registry registry;
    public static final String PORT = "port";
    public static final String REMOTE = "remote";
    public static final String RMI_ID = "rmiId";
    private String remote;
    private int port;
    private String rmiId;

    public RemoteCollectorOutputFormat() {
        this("localhost", 8888, null);
    }

    public RemoteCollectorOutputFormat(String remote, int port, String rmiId) {
        this.remote = remote;
        this.port = port;
        this.rmiId = rmiId;
        if (this.remote == null) {
            throw new IllegalStateException(String.format("No remote configured for %s.", this));
        }
        if (this.rmiId == null) {
            throw new IllegalStateException(String.format("No registry ID configured for %s.", this));
        }
    }

    public void configure(Configuration parameters) {
        this.remote = parameters.getString(REMOTE, this.remote);
        this.port = parameters.getInteger(PORT, this.port);
        this.rmiId = parameters.getString(RMI_ID, this.rmiId);
        if (this.remote == null) {
            throw new IllegalStateException(String.format("No remote configured for %s.", this));
        }
        if (this.rmiId == null) {
            throw new IllegalStateException(String.format("No registry ID configured for %s.", this));
        }
    }

    public void open(int taskNumber, int numTasks) throws IOException {
        try {
            this.registry = LocateRegistry.getRegistry(this.remote, this.port);
        }
        catch (RemoteException e) {
            throw new IllegalStateException(e);
        }
        try {
            this.remoteCollector = (RemoteCollector)this.registry.lookup(this.rmiId);
        }
        catch (AccessException e) {
            throw new IllegalStateException(e);
        }
        catch (RemoteException e) {
            throw new IllegalStateException(e);
        }
        catch (NotBoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public void writeRecord(T record) throws IOException {
        this.remoteCollector.collect(record);
    }

    public void close() throws IOException {
    }

    public String toString() {
        return "RemoteCollectorOutputFormat(" + this.remote + ":" + this.port + ", " + this.rmiId + ")";
    }
}

