/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.operators.BinaryOperatorInformation;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.CoGroupOperatorBase;
import org.apache.flink.api.common.operators.base.MapOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.Utils;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.operators.CoGroupOperator;
import org.apache.flink.api.java.operators.DeltaIteration;
import org.apache.flink.api.java.operators.Keys;
import org.apache.flink.api.java.operators.TwoInputUdfOperator;
import org.apache.flink.api.java.operators.translation.KeyExtractingMapper;
import org.apache.flink.api.java.operators.translation.PlanBothUnwrappingCoGroupOperator;
import org.apache.flink.api.java.operators.translation.PlanLeftUnwrappingCoGroupOperator;
import org.apache.flink.api.java.operators.translation.PlanRightUnwrappingCoGroupOperator;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;

public class CoGroupOperator<I1, I2, OUT>
extends TwoInputUdfOperator<I1, I2, OUT, CoGroupOperator<I1, I2, OUT>> {
    private final CoGroupFunction<I1, I2, OUT> function;
    private final Keys<I1> keys1;
    private final Keys<I2> keys2;
    private final String defaultName;
    private final List<Pair<Integer, Order>> groupSortKeyOrderFirst;
    private final List<Pair<Integer, Order>> groupSortKeyOrderSecond;
    private Partitioner<?> customPartitioner;

    public CoGroupOperator(DataSet<I1> input1, DataSet<I2> input2, Keys<I1> keys1, Keys<I2> keys2, CoGroupFunction<I1, I2, OUT> function, TypeInformation<OUT> returnType, Partitioner<?> customPartitioner, String defaultName) {
        this(input1, input2, keys1, keys2, function, returnType, null, null, customPartitioner, defaultName);
    }

    public CoGroupOperator(DataSet<I1> input1, DataSet<I2> input2, Keys<I1> keys1, Keys<I2> keys2, CoGroupFunction<I1, I2, OUT> function, TypeInformation<OUT> returnType, List<Pair<Integer, Order>> groupSortKeyOrderFirst, List<Pair<Integer, Order>> groupSortKeyOrderSecond, Partitioner<?> customPartitioner, String defaultName) {
        super(input1, input2, returnType);
        int[] positions;
        this.function = function;
        this.customPartitioner = customPartitioner;
        this.defaultName = defaultName;
        this.groupSortKeyOrderFirst = groupSortKeyOrderFirst == null ? Collections.emptyList() : groupSortKeyOrderFirst;
        List<Object> list = this.groupSortKeyOrderSecond = groupSortKeyOrderSecond == null ? Collections.emptyList() : groupSortKeyOrderSecond;
        if (keys1 == null || keys2 == null) {
            throw new NullPointerException();
        }
        if (input1 instanceof DeltaIteration.SolutionSetPlaceHolder) {
            if (keys1 instanceof Keys.ExpressionKeys) {
                positions = ((Keys.ExpressionKeys)keys1).computeLogicalKeyPositions();
                ((DeltaIteration.SolutionSetPlaceHolder)input1).checkJoinKeyFields(positions);
            } else {
                throw new InvalidProgramException("Currently, the solution set may only be CoGrouped with using tuple field positions.");
            }
        }
        if (input2 instanceof DeltaIteration.SolutionSetPlaceHolder) {
            if (keys2 instanceof Keys.ExpressionKeys) {
                positions = ((Keys.ExpressionKeys)keys2).computeLogicalKeyPositions();
                ((DeltaIteration.SolutionSetPlaceHolder)input2).checkJoinKeyFields(positions);
            } else {
                throw new InvalidProgramException("Currently, the solution set may only be CoGrouped with using tuple field positions.");
            }
        }
        this.keys1 = keys1;
        this.keys2 = keys2;
        this.extractSemanticAnnotationsFromUdf(function.getClass());
    }

    protected Keys<I1> getKeys1() {
        return this.keys1;
    }

    protected Keys<I2> getKeys2() {
        return this.keys2;
    }

    public CoGroupOperator<I1, I2, OUT> withPartitioner(Partitioner<?> partitioner) {
        if (partitioner != null) {
            this.keys1.validateCustomPartitioner(partitioner, null);
            this.keys2.validateCustomPartitioner(partitioner, null);
        }
        this.customPartitioner = this.getInput1().clean(partitioner);
        return this;
    }

    public Partitioner<?> getPartitioner() {
        return this.customPartitioner;
    }

    @Override
    protected CoGroupOperatorBase<?, ?, OUT, ?> translateToDataFlow(Operator<I1> input1, Operator<I2> input2) {
        Ordering o;
        int[] logicalKeyPositions2;
        int[] logicalKeyPositions1;
        CoGroupOperatorBase po;
        Keys.SelectorFunctionKeys selectorKeys2;
        Keys.SelectorFunctionKeys selectorKeys1;
        String name = this.getName() != null ? this.getName() : "CoGroup at " + this.defaultName;
        try {
            this.keys1.areCompatible(this.keys2);
        }
        catch (Keys.IncompatibleKeysException e) {
            throw new InvalidProgramException("The types of the key fields do not match.", (Throwable)e);
        }
        if (this.keys1 instanceof Keys.SelectorFunctionKeys && this.keys2 instanceof Keys.SelectorFunctionKeys) {
            selectorKeys1 = (Keys.SelectorFunctionKeys)this.keys1;
            selectorKeys2 = (Keys.SelectorFunctionKeys)this.keys2;
            po = CoGroupOperator.translateSelectorFunctionCoGroup(selectorKeys1, selectorKeys2, this.function, this.getInput1Type(), this.getInput2Type(), this.getResultType(), name, input1, input2);
            po.setDegreeOfParallelism(this.getParallelism());
            po.setCustomPartitioner(this.customPartitioner);
        } else if (this.keys2 instanceof Keys.SelectorFunctionKeys) {
            logicalKeyPositions1 = this.keys1.computeLogicalKeyPositions();
            selectorKeys2 = (Keys.SelectorFunctionKeys)this.keys2;
            po = CoGroupOperator.translateSelectorFunctionCoGroupRight(logicalKeyPositions1, selectorKeys2, this.function, this.getInput1Type(), this.getInput2Type(), this.getResultType(), name, input1, input2);
            po.setDegreeOfParallelism(this.getParallelism());
            po.setCustomPartitioner(this.customPartitioner);
        } else if (this.keys1 instanceof Keys.SelectorFunctionKeys) {
            selectorKeys1 = (Keys.SelectorFunctionKeys)this.keys1;
            logicalKeyPositions2 = this.keys2.computeLogicalKeyPositions();
            po = CoGroupOperator.translateSelectorFunctionCoGroupLeft(selectorKeys1, logicalKeyPositions2, this.function, this.getInput1Type(), this.getInput2Type(), this.getResultType(), name, input1, input2);
        } else if (this.keys1 instanceof Keys.ExpressionKeys && this.keys2 instanceof Keys.ExpressionKeys) {
            try {
                this.keys1.areCompatible(this.keys2);
            }
            catch (Keys.IncompatibleKeysException e) {
                throw new InvalidProgramException("The types of the key fields do not match.", (Throwable)e);
            }
            logicalKeyPositions1 = this.keys1.computeLogicalKeyPositions();
            logicalKeyPositions2 = this.keys2.computeLogicalKeyPositions();
            CoGroupOperatorBase op = new CoGroupOperatorBase(this.function, new BinaryOperatorInformation(this.getInput1Type(), this.getInput2Type(), this.getResultType()), logicalKeyPositions1, logicalKeyPositions2, name);
            op.setFirstInput(input1);
            op.setSecondInput(input2);
            po = op;
        } else {
            throw new UnsupportedOperationException("Unrecognized or incompatible key types.");
        }
        po.setDegreeOfParallelism(this.getParallelism());
        po.setCustomPartitioner(this.customPartitioner);
        if (this.groupSortKeyOrderFirst.size() > 0) {
            o = new Ordering();
            for (Pair<Integer, Order> entry : this.groupSortKeyOrderFirst) {
                o.appendOrdering((Integer)entry.getLeft(), null, (Order)entry.getRight());
            }
            po.setGroupOrderForInputOne(o);
        }
        if (this.groupSortKeyOrderSecond.size() > 0) {
            o = new Ordering();
            for (Pair<Integer, Order> entry : this.groupSortKeyOrderSecond) {
                o.appendOrdering((Integer)entry.getLeft(), null, (Order)entry.getRight());
            }
            po.setGroupOrderForInputTwo(o);
        }
        return po;
    }

    private static <I1, I2, K, OUT> PlanBothUnwrappingCoGroupOperator<I1, I2, OUT, K> translateSelectorFunctionCoGroup(Keys.SelectorFunctionKeys<I1, ?> rawKeys1, Keys.SelectorFunctionKeys<I2, ?> rawKeys2, CoGroupFunction<I1, I2, OUT> function, TypeInformation<I1> inputType1, TypeInformation<I2> inputType2, TypeInformation<OUT> outputType, String name, Operator<I1> input1, Operator<I2> input2) {
        Keys.SelectorFunctionKeys<I1, ?> keys1 = rawKeys1;
        Keys.SelectorFunctionKeys<I2, ?> keys2 = rawKeys2;
        TupleTypeInfo typeInfoWithKey1 = new TupleTypeInfo(keys1.getKeyType(), inputType1);
        TupleTypeInfo typeInfoWithKey2 = new TupleTypeInfo(keys2.getKeyType(), inputType2);
        KeyExtractingMapper extractor1 = new KeyExtractingMapper(keys1.getKeyExtractor());
        KeyExtractingMapper extractor2 = new KeyExtractingMapper(keys2.getKeyExtractor());
        MapOperatorBase keyMapper1 = new MapOperatorBase(extractor1, new UnaryOperatorInformation(inputType1, typeInfoWithKey1), "Key Extractor 1");
        MapOperatorBase keyMapper2 = new MapOperatorBase(extractor2, new UnaryOperatorInformation(inputType2, typeInfoWithKey2), "Key Extractor 2");
        PlanBothUnwrappingCoGroupOperator cogroup = new PlanBothUnwrappingCoGroupOperator(function, keys1, keys2, name, outputType, typeInfoWithKey1, typeInfoWithKey2);
        cogroup.setFirstInput((Operator)keyMapper1);
        cogroup.setSecondInput((Operator)keyMapper2);
        keyMapper1.setInput(input1);
        keyMapper2.setInput(input2);
        keyMapper1.setDegreeOfParallelism(input1.getDegreeOfParallelism());
        keyMapper2.setDegreeOfParallelism(input2.getDegreeOfParallelism());
        return cogroup;
    }

    private static <I1, I2, K, OUT> PlanRightUnwrappingCoGroupOperator<I1, I2, OUT, K> translateSelectorFunctionCoGroupRight(int[] logicalKeyPositions1, Keys.SelectorFunctionKeys<I2, ?> rawKeys2, CoGroupFunction<I1, I2, OUT> function, TypeInformation<I1> inputType1, TypeInformation<I2> inputType2, TypeInformation<OUT> outputType, String name, Operator<I1> input1, Operator<I2> input2) {
        if (!inputType1.isTupleType()) {
            throw new InvalidParameterException("Should not happen.");
        }
        Keys.SelectorFunctionKeys<I2, ?> keys2 = rawKeys2;
        TupleTypeInfo typeInfoWithKey2 = new TupleTypeInfo(keys2.getKeyType(), inputType2);
        KeyExtractingMapper extractor2 = new KeyExtractingMapper(keys2.getKeyExtractor());
        MapOperatorBase keyMapper2 = new MapOperatorBase(extractor2, new UnaryOperatorInformation(inputType2, typeInfoWithKey2), "Key Extractor 2");
        PlanRightUnwrappingCoGroupOperator cogroup = new PlanRightUnwrappingCoGroupOperator(function, logicalKeyPositions1, keys2, name, outputType, inputType1, typeInfoWithKey2);
        cogroup.setFirstInput(input1);
        cogroup.setSecondInput((Operator)keyMapper2);
        keyMapper2.setInput(input2);
        keyMapper2.setDegreeOfParallelism(input2.getDegreeOfParallelism());
        return cogroup;
    }

    private static <I1, I2, K, OUT> PlanLeftUnwrappingCoGroupOperator<I1, I2, OUT, K> translateSelectorFunctionCoGroupLeft(Keys.SelectorFunctionKeys<I1, ?> rawKeys1, int[] logicalKeyPositions2, CoGroupFunction<I1, I2, OUT> function, TypeInformation<I1> inputType1, TypeInformation<I2> inputType2, TypeInformation<OUT> outputType, String name, Operator<I1> input1, Operator<I2> input2) {
        if (!inputType2.isTupleType()) {
            throw new InvalidParameterException("Should not happen.");
        }
        Keys.SelectorFunctionKeys<I1, ?> keys1 = rawKeys1;
        TupleTypeInfo typeInfoWithKey1 = new TupleTypeInfo(keys1.getKeyType(), inputType1);
        KeyExtractingMapper extractor1 = new KeyExtractingMapper(keys1.getKeyExtractor());
        MapOperatorBase keyMapper1 = new MapOperatorBase(extractor1, new UnaryOperatorInformation(inputType1, typeInfoWithKey1), "Key Extractor 1");
        PlanLeftUnwrappingCoGroupOperator cogroup = new PlanLeftUnwrappingCoGroupOperator(function, keys1, logicalKeyPositions2, name, outputType, typeInfoWithKey1, inputType2);
        cogroup.setFirstInput((Operator)keyMapper1);
        cogroup.setSecondInput(input2);
        keyMapper1.setInput(input1);
        keyMapper1.setDegreeOfParallelism(input1.getDegreeOfParallelism());
        return cogroup;
    }

    public static final class CoGroupOperatorSets<I1, I2> {
        private final DataSet<I1> input1;
        private final DataSet<I2> input2;

        public CoGroupOperatorSets(DataSet<I1> input1, DataSet<I2> input2) {
            if (input1 == null || input2 == null) {
                throw new NullPointerException();
            }
            this.input1 = input1;
            this.input2 = input2;
        }

        public CoGroupOperatorSetsPredicate where(int ... fields) {
            return new CoGroupOperatorSetsPredicate(new Keys.ExpressionKeys<I1>(fields, this.input1.getType()));
        }

        public CoGroupOperatorSetsPredicate where(String ... fields) {
            return new CoGroupOperatorSetsPredicate(new Keys.ExpressionKeys<I1>(fields, this.input1.getType()));
        }

        public <K> CoGroupOperatorSetsPredicate where(KeySelector<I1, K> keyExtractor) {
            TypeInformation<K> keyType = TypeExtractor.getKeySelectorTypes(keyExtractor, this.input1.getType());
            return new CoGroupOperatorSetsPredicate(new Keys.SelectorFunctionKeys<I1, K>(keyExtractor, this.input1.getType(), keyType));
        }

        public final class CoGroupOperatorSetsPredicate {
            private final Keys<I1> keys1;

            private CoGroupOperatorSetsPredicate(Keys<I1> keys1) {
                if (keys1 == null) {
                    throw new NullPointerException();
                }
                if (keys1.isEmpty()) {
                    throw new InvalidProgramException("The co-group keys must not be empty.");
                }
                this.keys1 = keys1;
            }

            public org.apache.flink.api.java.operators.CoGroupOperator$CoGroupOperatorSets$CoGroupOperatorSetsPredicate.CoGroupOperatorWithoutFunction equalTo(int ... fields) {
                return this.createCoGroupOperator(new Keys.ExpressionKeys(fields, CoGroupOperatorSets.this.input2.getType()));
            }

            public org.apache.flink.api.java.operators.CoGroupOperator$CoGroupOperatorSets$CoGroupOperatorSetsPredicate.CoGroupOperatorWithoutFunction equalTo(String ... fields) {
                return this.createCoGroupOperator(new Keys.ExpressionKeys(fields, CoGroupOperatorSets.this.input2.getType()));
            }

            public <K> org.apache.flink.api.java.operators.CoGroupOperator$CoGroupOperatorSets$CoGroupOperatorSetsPredicate.CoGroupOperatorWithoutFunction equalTo(KeySelector<I2, K> keyExtractor) {
                TypeInformation<K> keyType = TypeExtractor.getKeySelectorTypes(keyExtractor, CoGroupOperatorSets.this.input2.getType());
                return this.createCoGroupOperator(new Keys.SelectorFunctionKeys(keyExtractor, CoGroupOperatorSets.this.input2.getType(), keyType));
            }

            private org.apache.flink.api.java.operators.CoGroupOperator$CoGroupOperatorSets$CoGroupOperatorSetsPredicate.CoGroupOperatorWithoutFunction createCoGroupOperator(Keys<I2> keys2) {
                if (keys2 == null) {
                    throw new NullPointerException();
                }
                if (keys2.isEmpty()) {
                    throw new InvalidProgramException("The co-group keys must not be empty.");
                }
                try {
                    this.keys1.areCompatible(keys2);
                }
                catch (Keys.IncompatibleKeysException ike) {
                    throw new InvalidProgramException("The pair of co-group keys are not compatible with each other.", (Throwable)ike);
                }
                return new CoGroupOperatorWithoutFunction(keys2);
            }

            public final class CoGroupOperatorWithoutFunction {
                private final Keys<I2> keys2;
                private final List<Pair<Integer, Order>> groupSortKeyOrderFirst;
                private final List<Pair<Integer, Order>> groupSortKeyOrderSecond;
                private Partitioner<?> customPartitioner;

                private CoGroupOperatorWithoutFunction(Keys<I2> keys2) {
                    if (keys2 == null) {
                        throw new NullPointerException();
                    }
                    if (keys2.isEmpty()) {
                        throw new InvalidProgramException("The co-group keys must not be empty.");
                    }
                    this.keys2 = keys2;
                    this.groupSortKeyOrderFirst = new ArrayList<Pair<Integer, Order>>();
                    this.groupSortKeyOrderSecond = new ArrayList<Pair<Integer, Order>>();
                }

                public org.apache.flink.api.java.operators.CoGroupOperator$CoGroupOperatorSets$CoGroupOperatorSetsPredicate.CoGroupOperatorWithoutFunction withPartitioner(Partitioner<?> partitioner) {
                    if (partitioner != null) {
                        CoGroupOperatorSetsPredicate.this.keys1.validateCustomPartitioner(partitioner, null);
                        this.keys2.validateCustomPartitioner(partitioner, null);
                    }
                    this.customPartitioner = CoGroupOperatorSets.this.input1.clean(partitioner);
                    return this;
                }

                public Partitioner<?> getPartitioner() {
                    return this.customPartitioner;
                }

                public <R> CoGroupOperator<I1, I2, R> with(CoGroupFunction<I1, I2, R> function) {
                    if (function == null) {
                        throw new NullPointerException("CoGroup function must not be null.");
                    }
                    TypeInformation<R> returnType = TypeExtractor.getCoGroupReturnTypes(function, CoGroupOperatorSets.this.input1.getType(), CoGroupOperatorSets.this.input2.getType());
                    return new CoGroupOperator(CoGroupOperatorSets.this.input1, CoGroupOperatorSets.this.input2, CoGroupOperatorSetsPredicate.this.keys1, this.keys2, CoGroupOperatorSets.this.input1.clean(function), returnType, this.groupSortKeyOrderFirst, this.groupSortKeyOrderSecond, this.customPartitioner, Utils.getCallLocationName());
                }

                public org.apache.flink.api.java.operators.CoGroupOperator$CoGroupOperatorSets$CoGroupOperatorSetsPredicate.CoGroupOperatorWithoutFunction sortFirstGroup(int field, Order order) {
                    int[] groupOrderKeys;
                    if (!CoGroupOperatorSets.this.input1.getType().isTupleType()) {
                        throw new InvalidProgramException("Specifying order keys via field positions is only valid for tuple data types");
                    }
                    if (field >= CoGroupOperatorSets.this.input1.getType().getArity()) {
                        throw new IllegalArgumentException("Order key out of tuple bounds.");
                    }
                    Keys.ExpressionKeys ek = new Keys.ExpressionKeys(new int[]{field}, CoGroupOperatorSets.this.input1.getType());
                    for (int key : groupOrderKeys = ek.computeLogicalKeyPositions()) {
                        this.groupSortKeyOrderFirst.add((Pair<Integer, Order>)new ImmutablePair((Object)key, (Object)order));
                    }
                    return this;
                }

                public org.apache.flink.api.java.operators.CoGroupOperator$CoGroupOperatorSets$CoGroupOperatorSetsPredicate.CoGroupOperatorWithoutFunction sortSecondGroup(int field, Order order) {
                    int[] groupOrderKeys;
                    if (!CoGroupOperatorSets.this.input2.getType().isTupleType()) {
                        throw new InvalidProgramException("Specifying order keys via field positions is only valid for tuple data types");
                    }
                    if (field >= CoGroupOperatorSets.this.input2.getType().getArity()) {
                        throw new IllegalArgumentException("Order key out of tuple bounds.");
                    }
                    Keys.ExpressionKeys ek = new Keys.ExpressionKeys(new int[]{field}, CoGroupOperatorSets.this.input2.getType());
                    for (int key : groupOrderKeys = ek.computeLogicalKeyPositions()) {
                        this.groupSortKeyOrderSecond.add((Pair<Integer, Order>)new ImmutablePair((Object)key, (Object)order));
                    }
                    return this;
                }

                public org.apache.flink.api.java.operators.CoGroupOperator$CoGroupOperatorSets$CoGroupOperatorSetsPredicate.CoGroupOperatorWithoutFunction sortFirstGroup(String fieldExpression, Order order) {
                    int[] groupOrderKeys;
                    if (!(CoGroupOperatorSets.this.input1.getType() instanceof CompositeType)) {
                        throw new InvalidProgramException("Specifying order keys via field positions is only valid for composite data types (pojo / tuple / case class)");
                    }
                    Keys.ExpressionKeys ek = new Keys.ExpressionKeys(new String[]{fieldExpression}, CoGroupOperatorSets.this.input1.getType());
                    for (int key : groupOrderKeys = ek.computeLogicalKeyPositions()) {
                        this.groupSortKeyOrderFirst.add((Pair<Integer, Order>)new ImmutablePair((Object)key, (Object)order));
                    }
                    return this;
                }

                public org.apache.flink.api.java.operators.CoGroupOperator$CoGroupOperatorSets$CoGroupOperatorSetsPredicate.CoGroupOperatorWithoutFunction sortSecondGroup(String fieldExpression, Order order) {
                    int[] groupOrderKeys;
                    if (!(CoGroupOperatorSets.this.input2.getType() instanceof CompositeType)) {
                        throw new InvalidProgramException("Specifying order keys via field positions is only valid for composite data types (pojo / tuple / case class)");
                    }
                    Keys.ExpressionKeys ek = new Keys.ExpressionKeys(new String[]{fieldExpression}, CoGroupOperatorSets.this.input2.getType());
                    for (int key : groupOrderKeys = ek.computeLogicalKeyPositions()) {
                        this.groupSortKeyOrderSecond.add((Pair<Integer, Order>)new ImmutablePair((Object)key, (Object)order));
                    }
                    return this;
                }
            }
        }
    }
}

