/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

public abstract class TupleTypeInfoBase<T>
extends CompositeType<T> {
    protected final TypeInformation<?>[] types;
    protected final Class<T> tupleType;
    private int totalFields;

    public TupleTypeInfoBase(Class<T> tupleType, TypeInformation<?> ... types) {
        super(tupleType);
        this.tupleType = tupleType;
        this.types = types;
        for (TypeInformation<?> type : types) {
            this.totalFields += type.getTotalFields();
        }
    }

    public boolean isBasicType() {
        return false;
    }

    public boolean isTupleType() {
        return true;
    }

    public int getArity() {
        return this.types.length;
    }

    public int getTotalFields() {
        return this.totalFields;
    }

    public Class<T> getTypeClass() {
        return this.tupleType;
    }

    public void addAllFields(int startKeyId, List<CompositeType.FlatFieldDescriptor> keyFields) {
        for (int i = 0; i < this.getArity(); ++i) {
            TypeInformation<?> type = this.types[i];
            if (type instanceof AtomicType) {
                keyFields.add(new CompositeType.FlatFieldDescriptor(startKeyId, type));
            } else if (type instanceof TupleTypeInfoBase) {
                TupleTypeInfoBase ttb = (TupleTypeInfoBase)type;
                ttb.addAllFields(startKeyId, keyFields);
            }
            startKeyId += type.getTotalFields();
        }
    }

    public void getKey(String fieldExpression, int offset, List<CompositeType.FlatFieldDescriptor> result) {
        String fieldNumStr;
        if (fieldExpression.equals("*") || fieldExpression.equals("_")) {
            int keyPosition = 0;
            for (TypeInformation<?> type : this.types) {
                if (type instanceof AtomicType) {
                    result.add(new CompositeType.FlatFieldDescriptor(offset + keyPosition, type));
                } else if (type instanceof CompositeType) {
                    CompositeType cType = (CompositeType)type;
                    cType.getKey(String.valueOf("*"), offset + keyPosition, result);
                    keyPosition += cType.getTotalFields() - 1;
                } else {
                    throw new RuntimeException("Unexpected key type: " + type);
                }
                ++keyPosition;
            }
            return;
        }
        if (fieldExpression.length() < 2) {
            throw new IllegalArgumentException("The field expression '" + fieldExpression + "' is incorrect. The length must be at least 2");
        }
        if (fieldExpression.charAt(0) != 'f') {
            throw new IllegalArgumentException("The field expression '" + fieldExpression + "' is incorrect for a Tuple type. It has to start with an 'f'");
        }
        int dotPos = fieldExpression.indexOf(46);
        String nestedSplitFirst = fieldExpression;
        if (dotPos != -1) {
            Preconditions.checkArgument((dotPos != fieldExpression.length() - 1 ? 1 : 0) != 0, (Object)"The field expression can never end with a dot.");
            nestedSplitFirst = fieldExpression.substring(0, dotPos);
        }
        if (!StringUtils.isNumeric((CharSequence)(fieldNumStr = nestedSplitFirst.substring(1, nestedSplitFirst.length())))) {
            throw new IllegalArgumentException("The field expression '" + fieldExpression + "' is incorrect. Field number '" + fieldNumStr + " is not numeric");
        }
        int pos = -1;
        try {
            pos = Integer.valueOf(fieldNumStr);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("The field expression '" + fieldExpression + "' is incorrect. Field number '" + fieldNumStr + " is not numeric", nfe);
        }
        if (pos < 0) {
            throw new IllegalArgumentException("Negative position is not possible");
        }
        if (dotPos != -1) {
            String rem = fieldExpression.substring(dotPos + 1);
            if (!(this.types[pos] instanceof CompositeType)) {
                throw new RuntimeException("Element at position " + pos + " is not a composite type. There are no nested types to select");
            }
            CompositeType cType = (CompositeType)this.types[pos];
            cType.getKey(rem, offset + pos, result);
            return;
        }
        if (pos >= this.types.length) {
            throw new IllegalArgumentException("The specified tuple position does not exist");
        }
        for (int i = 0; i < pos; ++i) {
            offset += this.types[i].getTotalFields() - 1;
        }
        if (this.types[pos] instanceof CompositeType) {
            throw new IllegalArgumentException("The specified field '" + fieldExpression + "' is refering to a composite type.\n" + "Either select all elements in this type with the '" + "*" + "' operator or specify a field in the sub-type");
        }
        result.add(new CompositeType.FlatFieldDescriptor(offset + pos, this.types[pos]));
    }

    public <X> TypeInformation<X> getTypeAt(int pos) {
        if (pos < 0 || pos >= this.types.length) {
            throw new IndexOutOfBoundsException();
        }
        TypeInformation<?> typed = this.types[pos];
        return typed;
    }

    public boolean isKeyType() {
        return this.isValidKeyType((TypeInformation<?>)this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TupleTypeInfoBase) {
            TupleTypeInfoBase other = (TupleTypeInfoBase)((Object)obj);
            return (this.tupleType == null && other.tupleType == null || this.tupleType.equals(other.tupleType)) && Arrays.deepEquals(this.types, other.types);
        }
        return false;
    }

    public int hashCode() {
        return this.types.hashCode() ^ Arrays.deepHashCode(this.types);
    }

    private boolean isValidKeyType(TypeInformation<?> typeInfo) {
        if (typeInfo instanceof TupleTypeInfoBase) {
            TupleTypeInfoBase tupleType = (TupleTypeInfoBase)typeInfo;
            for (int i = 0; i < tupleType.getArity(); ++i) {
                if (this.isValidKeyType(tupleType.getTypeAt(i))) continue;
                return false;
            }
            return true;
        }
        return typeInfo.isKeyType();
    }

    public String toString() {
        StringBuilder bld = new StringBuilder("Tuple");
        bld.append(this.types.length).append('<');
        bld.append(this.types[0]);
        for (int i = 1; i < this.types.length; ++i) {
            bld.append(", ").append(this.types[i]);
        }
        bld.append('>');
        return bld.toString();
    }
}

