/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.runtime.PojoComparator;
import org.apache.flink.api.java.typeutils.runtime.PojoSerializer;
import org.apache.flink.shaded.com.google.common.base.Joiner;

public class PojoTypeInfo<T>
extends CompositeType<T> {
    private final Class<T> typeClass;
    private PojoField[] fields;
    private int totalFields;
    private TypeComparator<?>[] fieldComparators;
    private Field[] keyFields;
    private int comparatorHelperIndex = 0;

    public PojoTypeInfo(Class<T> typeClass, List<PojoField> fields) {
        super(typeClass);
        this.typeClass = typeClass;
        ArrayList<PojoField> tempFields = new ArrayList<PojoField>(fields);
        Collections.sort(tempFields, new Comparator<PojoField>(){

            @Override
            public int compare(PojoField o1, PojoField o2) {
                return o1.field.getName().compareTo(o2.field.getName());
            }
        });
        this.fields = tempFields.toArray(new PojoField[tempFields.size()]);
        if (!Modifier.isPublic(typeClass.getModifiers())) {
            throw new RuntimeException("POJO " + typeClass + " is not public");
        }
        for (PojoField field : fields) {
            this.totalFields += field.type.getTotalFields();
        }
    }

    public boolean isBasicType() {
        return false;
    }

    public boolean isTupleType() {
        return false;
    }

    public int getArity() {
        return this.fields.length;
    }

    public int getTotalFields() {
        return this.totalFields;
    }

    public Class<T> getTypeClass() {
        return this.typeClass;
    }

    public boolean isKeyType() {
        return Comparable.class.isAssignableFrom(this.typeClass);
    }

    public String toString() {
        ArrayList<String> fieldStrings = new ArrayList<String>();
        for (PojoField field : this.fields) {
            fieldStrings.add(field.field.getName() + ": " + field.type.toString());
        }
        return "PojoType<" + this.typeClass.getCanonicalName() + ", fields = [" + Joiner.on((String)", ").join(fieldStrings) + "]" + ">";
    }

    public void getKey(String fieldExpression, int offset, List<CompositeType.FlatFieldDescriptor> result) {
        if (fieldExpression.equals("*") || fieldExpression.equals("_")) {
            int keyPosition = 0;
            for (PojoField field : this.fields) {
                if (field.type instanceof AtomicType) {
                    result.add(new CompositeType.FlatFieldDescriptor(offset + keyPosition, field.type));
                } else if (field.type instanceof CompositeType) {
                    CompositeType cType = (CompositeType)field.type;
                    cType.getKey(String.valueOf("*"), offset + keyPosition, result);
                    keyPosition += cType.getTotalFields() - 1;
                } else {
                    throw new RuntimeException("Unexpected key type: " + field.type);
                }
                ++keyPosition;
            }
            return;
        }
        Validate.notEmpty((CharSequence)fieldExpression, (String)"Field expression must not be empty.", (Object[])new Object[0]);
        int firstDot = fieldExpression.indexOf(46);
        if (firstDot == -1) {
            int fieldId = 0;
            for (int i = 0; i < this.fields.length; ++i) {
                if (this.fields[i].type instanceof CompositeType) {
                    fieldId += this.fields[i].type.getTotalFields() - 1;
                }
                if (this.fields[i].field.getName().equals(fieldExpression)) {
                    if (this.fields[i].type instanceof CompositeType) {
                        throw new IllegalArgumentException("The specified field '" + fieldExpression + "' is refering to a composite type.\n" + "Either select all elements in this type with the '" + "*" + "' operator or specify a field in the sub-type");
                    }
                    result.add(new CompositeType.FlatFieldDescriptor(offset + fieldId, this.fields[i].type));
                    return;
                }
                ++fieldId;
            }
        } else {
            String firstField = fieldExpression.substring(0, firstDot);
            String rest = fieldExpression.substring(firstDot + 1);
            int fieldId = 0;
            for (int i = 0; i < this.fields.length; ++i) {
                if (this.fields[i].field.getName().equals(firstField)) {
                    if (!(this.fields[i].type instanceof CompositeType)) {
                        throw new RuntimeException("Field " + this.fields[i].type + " (specified by '" + fieldExpression + "') is not a composite type");
                    }
                    CompositeType cType = (CompositeType)this.fields[i].type;
                    cType.getKey(rest, offset + fieldId, result);
                    return;
                }
                fieldId += this.fields[i].type.getTotalFields();
            }
            throw new RuntimeException("Unable to find field " + fieldExpression + " in type " + (Object)((Object)this) + " (looking for '" + firstField + "')");
        }
    }

    public <X> TypeInformation<X> getTypeAt(int pos) {
        if (pos < 0 || pos >= this.fields.length) {
            throw new IndexOutOfBoundsException();
        }
        TypeInformation<?> typed = this.fields[pos].type;
        return typed;
    }

    public PojoField getPojoFieldAt(int pos) {
        if (pos < 0 || pos >= this.fields.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.fields[pos];
    }

    protected void initializeNewComparator(int keyCount) {
        this.fieldComparators = new TypeComparator[keyCount];
        this.keyFields = new Field[keyCount];
        this.comparatorHelperIndex = 0;
    }

    protected void addCompareField(int fieldId, TypeComparator<?> comparator) {
        this.fieldComparators[this.comparatorHelperIndex] = comparator;
        this.keyFields[this.comparatorHelperIndex] = this.fields[fieldId].field;
        ++this.comparatorHelperIndex;
    }

    protected TypeComparator<T> getNewComparator() {
        Field[] finalKeyFields = Arrays.copyOf(this.keyFields, this.comparatorHelperIndex);
        TypeComparator<?>[] finalFieldComparators = Arrays.copyOf(this.fieldComparators, this.comparatorHelperIndex);
        if (finalFieldComparators.length == 0 || finalKeyFields.length == 0 || finalFieldComparators.length != finalKeyFields.length) {
            throw new IllegalArgumentException("Pojo comparator creation has a bug");
        }
        return new PojoComparator<T>(finalKeyFields, finalFieldComparators, this.createSerializer(), this.typeClass);
    }

    public TypeSerializer<T> createSerializer() {
        TypeSerializer[] fieldSerializers = new TypeSerializer[this.fields.length];
        Field[] reflectiveFields = new Field[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            fieldSerializers[i] = this.fields[i].type.createSerializer();
            reflectiveFields[i] = this.fields[i].field;
        }
        return new PojoSerializer<T>(this.typeClass, fieldSerializers, reflectiveFields);
    }
}

