/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import com.google.common.base.Joiner;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.AtomicType;
import org.apache.flink.api.java.typeutils.CompositeType;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.runtime.PojoComparator;
import org.apache.flink.api.java.typeutils.runtime.PojoSerializer;
import org.apache.flink.types.TypeInformation;

public class PojoTypeInfo<T>
extends TypeInformation<T>
implements CompositeType<T> {
    private final Class<T> typeClass;
    private PojoField[] fields;

    public PojoTypeInfo(Class<T> typeClass, List<PojoField> fields) {
        this.typeClass = typeClass;
        ArrayList<PojoField> tempFields = new ArrayList<PojoField>(fields);
        Collections.sort(tempFields, new Comparator<PojoField>(){

            @Override
            public int compare(PojoField o1, PojoField o2) {
                return o1.field.getName().compareTo(o2.field.getName());
            }
        });
        this.fields = tempFields.toArray(new PojoField[tempFields.size()]);
    }

    public boolean isBasicType() {
        return false;
    }

    public boolean isTupleType() {
        return false;
    }

    public int getArity() {
        return this.fields.length;
    }

    public Class<T> getTypeClass() {
        return this.typeClass;
    }

    public boolean isKeyType() {
        return Comparable.class.isAssignableFrom(this.typeClass);
    }

    public TypeSerializer<T> createSerializer() {
        TypeSerializer[] fieldSerializers = new TypeSerializer[this.fields.length];
        Field[] reflectiveFields = new Field[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            fieldSerializers[i] = this.fields[i].type.createSerializer();
            reflectiveFields[i] = this.fields[i].field;
        }
        return new PojoSerializer<T>(this.typeClass, fieldSerializers, reflectiveFields);
    }

    public String toString() {
        ArrayList<String> fieldStrings = new ArrayList<String>();
        for (PojoField field : this.fields) {
            fieldStrings.add(field.field.getName() + ": " + field.type.toString());
        }
        return "PojoType<" + this.typeClass.getCanonicalName() + ", fields = [" + Joiner.on((String)", ").join(fieldStrings) + "]" + ">";
    }

    public int getLogicalPosition(String fieldExpression) {
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].field.getName().equals(fieldExpression)) continue;
            return i;
        }
        return -1;
    }

    public int[] getLogicalPositions(String[] fieldExpression) {
        int[] result = new int[fieldExpression.length];
        for (int i = 0; i < fieldExpression.length; ++i) {
            result[i] = this.getLogicalPosition(fieldExpression[i]);
        }
        return result;
    }

    public TypeInformation<?> getType(String fieldExpression) {
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].field.getName().equals(fieldExpression)) continue;
            return this.fields[i].type;
        }
        return null;
    }

    public TypeInformation<?>[] getTypes(String[] fieldExpression) {
        TypeInformation[] result = new TypeInformation[fieldExpression.length];
        for (int i = 0; i < fieldExpression.length; ++i) {
            result[i] = this.getType(fieldExpression[i]);
        }
        return result;
    }

    @Override
    public TypeComparator<T> createComparator(int[] logicalKeyFields, boolean[] orders) {
        if (logicalKeyFields == null || orders == null || logicalKeyFields.length != orders.length || logicalKeyFields.length > this.fields.length) {
            throw new IllegalArgumentException();
        }
        TypeComparator[] fieldComparators = new TypeComparator[logicalKeyFields.length];
        Field[] keyFields = new Field[logicalKeyFields.length];
        for (int i = 0; i < logicalKeyFields.length; ++i) {
            int field = logicalKeyFields[i];
            if (field < 0 || field >= this.fields.length) {
                throw new IllegalArgumentException("The field position " + field + " is out of range [0," + this.fields.length + ")");
            }
            if (!this.fields[field].type.isKeyType() || !(this.fields[field].type instanceof AtomicType)) {
                throw new IllegalArgumentException("The field at position " + field + " (" + this.fields[field].type + ") is no atomic key type.");
            }
            fieldComparators[i] = ((AtomicType)this.fields[field].type).createComparator(orders[i]);
            keyFields[i] = this.fields[field].field;
            keyFields[i].setAccessible(true);
        }
        return new PojoComparator<T>(keyFields, fieldComparators, this.createSerializer(), this.typeClass);
    }
}

