/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.aggregation.Aggregations;
import org.apache.flink.api.java.functions.UnsupportedLambdaExpressionException;
import org.apache.flink.api.java.operators.AggregateOperator;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.Grouping;
import org.apache.flink.api.java.operators.Keys;
import org.apache.flink.api.java.operators.ReduceOperator;
import org.apache.flink.api.java.operators.SortedGrouping;

public class UnsortedGrouping<T>
extends Grouping<T> {
    public UnsortedGrouping(DataSet<T> set, Keys<T> keys) {
        super(set, keys);
    }

    public AggregateOperator<T> aggregate(Aggregations agg, int field) {
        return new AggregateOperator(this, agg, field);
    }

    public AggregateOperator<T> sum(int field) {
        return this.aggregate(Aggregations.SUM, field);
    }

    public AggregateOperator<T> max(int field) {
        return this.aggregate(Aggregations.MAX, field);
    }

    public AggregateOperator<T> min(int field) {
        return this.aggregate(Aggregations.MIN, field);
    }

    public ReduceOperator<T> reduce(ReduceFunction<T> reducer) {
        if (reducer == null) {
            throw new NullPointerException("Reduce function must not be null.");
        }
        return new ReduceOperator<T>(this, reducer);
    }

    public <R> GroupReduceOperator<T, R> reduceGroup(GroupReduceFunction<T, R> reducer) {
        if (reducer == null) {
            throw new NullPointerException("GroupReduce function must not be null.");
        }
        if (FunctionUtils.isLambdaFunction(reducer)) {
            throw new UnsupportedLambdaExpressionException();
        }
        return new GroupReduceOperator<T, R>(this, reducer);
    }

    public SortedGrouping<T> sortGroup(int field, Order order) {
        return new SortedGrouping(this.dataSet, this.keys, field, order);
    }
}

