/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.MapOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.api.java.typeutils.TypeExtractor;

public class MapOperator<IN, OUT>
extends SingleInputUdfOperator<IN, OUT, MapOperator<IN, OUT>> {
    protected final MapFunction<IN, OUT> function;

    public MapOperator(DataSet<IN> input, MapFunction<IN, OUT> function) {
        super(input, TypeExtractor.getMapReturnTypes(function, input.getType()));
        this.function = function;
        this.extractSemanticAnnotationsFromUdf(function.getClass());
    }

    @Override
    protected MapOperatorBase<IN, OUT, MapFunction<IN, OUT>> translateToDataFlow(Operator<IN> input) {
        String name = this.getName() != null ? this.getName() : this.function.getClass().getName();
        MapOperatorBase po = new MapOperatorBase(this.function, new UnaryOperatorInformation(this.getInputType(), this.getResultType()), name);
        po.setInput(input);
        if (this.getParallelism() > 0) {
            po.setDegreeOfParallelism(this.getParallelism());
        } else {
            po.setDegreeOfParallelism(input.getDegreeOfParallelism());
        }
        return po;
    }
}

