/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import java.util.Arrays;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.types.TypeInformation;

public abstract class Keys<T> {
    public abstract int getNumberOfKeyFields();

    public boolean isEmpty() {
        return this.getNumberOfKeyFields() == 0;
    }

    public abstract boolean areCompatibale(Keys<?> var1);

    public abstract int[] computeLogicalKeyPositions();

    private static int[] makeFields(int[] fields, TupleTypeInfo<?> type) {
        int inLength = type.getArity();
        if (fields == null || fields.length == 0) {
            fields = new int[inLength];
            for (int i = 0; i < inLength; ++i) {
                fields[i] = i;
            }
            return fields;
        }
        return Keys.rangeCheckAndOrderFields(fields, inLength - 1);
    }

    private static final int[] rangeCheckAndOrderFields(int[] fields, int maxAllowedField) {
        Arrays.sort(fields);
        int k = 0;
        int last = fields[0];
        if (last < 0 || last > maxAllowedField) {
            throw new IllegalArgumentException("Tuple position is out of range.");
        }
        for (int i = 1; i < fields.length; ++i) {
            if (fields[i] < 0 || i > maxAllowedField) {
                throw new IllegalArgumentException("Tuple position is out of range.");
            }
            if (fields[i] == last) continue;
            fields[++k] = fields[i];
        }
        if (k == fields.length - 1) {
            return fields;
        }
        return Arrays.copyOfRange(fields, 0, k);
    }

    public static class ExpressionKeys<T>
    extends Keys<T> {
        private int[] logicalPositions;
        private final TypeInformation<?>[] types;
        private PojoTypeInfo<?> type;

        public ExpressionKeys(String[] expressions, TypeInformation<T> type) {
            PojoTypeInfo pojoType;
            if (!(type instanceof PojoTypeInfo)) {
                throw new UnsupportedOperationException("Key expressions can only be used on POJOs. A POJO must have a default constructor without arguments and not have readObject and/or writeObject methods. A current restriction is that it can only have nested POJOs or primitive (also boxed) fields.");
            }
            this.type = pojoType = (PojoTypeInfo)type;
            this.logicalPositions = pojoType.getLogicalPositions(expressions);
            this.types = pojoType.getTypes(expressions);
            for (int i = 0; i < this.logicalPositions.length; ++i) {
                if (this.logicalPositions[i] >= 0) continue;
                throw new IllegalArgumentException("Expression '" + expressions[i] + "' is not a valid key for POJO" + " type " + type.toString() + ".");
            }
        }

        @Override
        public int getNumberOfKeyFields() {
            return this.logicalPositions.length;
        }

        @Override
        public boolean areCompatibale(Keys<?> other) {
            if (other instanceof ExpressionKeys) {
                ExpressionKeys oKey = (ExpressionKeys)other;
                if (oKey.types.length != this.types.length) {
                    return false;
                }
                for (int i = 0; i < this.types.length; ++i) {
                    if (this.types[i].equals(oKey.types[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public int[] computeLogicalKeyPositions() {
            return this.logicalPositions;
        }
    }

    public static class SelectorFunctionKeys<T, K>
    extends Keys<T> {
        private final KeySelector<T, K> keyExtractor;
        private final TypeInformation<K> keyType;

        public SelectorFunctionKeys(KeySelector<T, K> keyExtractor, TypeInformation<T> type) {
            if (keyExtractor == null) {
                throw new NullPointerException("Key extractor must not be null.");
            }
            this.keyExtractor = keyExtractor;
            this.keyType = TypeExtractor.getKeySelectorTypes(keyExtractor, type);
        }

        public TypeInformation<K> getKeyType() {
            return this.keyType;
        }

        public KeySelector<T, K> getKeyExtractor() {
            return this.keyExtractor;
        }

        @Override
        public int getNumberOfKeyFields() {
            return 1;
        }

        @Override
        public boolean areCompatibale(Keys<?> other) {
            if (other instanceof SelectorFunctionKeys) {
                SelectorFunctionKeys sfk = (SelectorFunctionKeys)other;
                return sfk.keyType.equals(this.keyType);
            }
            if (other instanceof FieldPositionKeys) {
                FieldPositionKeys fpk = (FieldPositionKeys)other;
                if (fpk.types.length != 1) {
                    return false;
                }
                return fpk.types[0].equals(this.keyType);
            }
            return false;
        }

        @Override
        public int[] computeLogicalKeyPositions() {
            return new int[]{0};
        }

        public String toString() {
            return this.keyExtractor + " (" + this.keyType + ")";
        }
    }

    public static class FieldPositionKeys<T>
    extends Keys<T> {
        private final int[] fieldPositions;
        private final TypeInformation<?>[] types;

        public FieldPositionKeys(int[] groupingFields, TypeInformation<T> type) {
            this(groupingFields, type, false);
        }

        public FieldPositionKeys(int[] groupingFields, TypeInformation<T> type, boolean allowEmpty) {
            if (!type.isTupleType()) {
                throw new InvalidProgramException("Specifying keys via field positions is only valid for tuple data types");
            }
            if (!(allowEmpty || groupingFields != null && groupingFields.length != 0)) {
                throw new IllegalArgumentException("The grouping fields must not be empty.");
            }
            TupleTypeInfo tupleType = (TupleTypeInfo)type;
            this.fieldPositions = Keys.makeFields(groupingFields, (TupleTypeInfo)type);
            this.types = new TypeInformation[this.fieldPositions.length];
            for (int i = 0; i < this.fieldPositions.length; ++i) {
                this.types[i] = tupleType.getTypeAt(this.fieldPositions[i]);
            }
        }

        @Override
        public int getNumberOfKeyFields() {
            return this.fieldPositions.length;
        }

        @Override
        public boolean areCompatibale(Keys<?> other) {
            if (other instanceof FieldPositionKeys) {
                FieldPositionKeys oKey = (FieldPositionKeys)other;
                if (oKey.types.length != this.types.length) {
                    return false;
                }
                for (int i = 0; i < this.types.length; ++i) {
                    if (this.types[i].equals(oKey.types[i])) continue;
                    return false;
                }
                return true;
            }
            if (other instanceof SelectorFunctionKeys) {
                if (this.types.length != 1) {
                    return false;
                }
                SelectorFunctionKeys sfk = (SelectorFunctionKeys)other;
                return sfk.keyType.equals(this.types[0]);
            }
            return false;
        }

        @Override
        public int[] computeLogicalKeyPositions() {
            return this.fieldPositions;
        }

        public String toString() {
            return Arrays.toString(this.fieldPositions);
        }
    }
}

