/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.Validate;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.java.LocalEnvironment;
import org.apache.flink.api.java.RemoteEnvironment;
import org.apache.flink.api.java.io.CollectionInputFormat;
import org.apache.flink.api.java.io.CsvReader;
import org.apache.flink.api.java.io.IteratorInputFormat;
import org.apache.flink.api.java.io.ParallelIteratorInputFormat;
import org.apache.flink.api.java.io.TextInputFormat;
import org.apache.flink.api.java.io.TextValueInputFormat;
import org.apache.flink.api.java.operators.DataSink;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.OperatorTranslation;
import org.apache.flink.api.java.operators.translation.JavaPlan;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.BasicTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.java.typeutils.ValueTypeInfo;
import org.apache.flink.core.fs.Path;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.TypeInformation;
import org.apache.flink.util.NumberSequenceIterator;
import org.apache.flink.util.SplittableIterator;

public abstract class ExecutionEnvironment {
    private static ExecutionEnvironment contextEnvironment;
    private static int defaultLocalDop;
    private static boolean allowLocalExecution;
    private final UUID executionId;
    private final List<DataSink<?>> sinks = new ArrayList();
    private final List<Tuple2<String, DistributedCache.DistributedCacheEntry>> cacheFile = new ArrayList<Tuple2<String, DistributedCache.DistributedCacheEntry>>();
    private int degreeOfParallelism = -1;

    protected ExecutionEnvironment() {
        this.executionId = UUID.randomUUID();
    }

    public int getDegreeOfParallelism() {
        return this.degreeOfParallelism;
    }

    public void setDegreeOfParallelism(int degreeOfParallelism) {
        if (degreeOfParallelism < 1) {
            throw new IllegalArgumentException("Degree of parallelism must be at least one.");
        }
        this.degreeOfParallelism = degreeOfParallelism;
    }

    public UUID getId() {
        return this.executionId;
    }

    public String getIdString() {
        return this.executionId.toString();
    }

    public DataSource<String> readTextFile(String filePath) {
        Validate.notNull((Object)filePath, (String)"The file path may not be null.", (Object[])new Object[0]);
        return new DataSource<String>(this, (InputFormat<String, ?>)new TextInputFormat(new Path(filePath)), (TypeInformation<String>)BasicTypeInfo.STRING_TYPE_INFO);
    }

    public DataSource<String> readTextFile(String filePath, String charsetName) {
        Validate.notNull((Object)filePath, (String)"The file path may not be null.", (Object[])new Object[0]);
        TextInputFormat format = new TextInputFormat(new Path(filePath));
        format.setCharsetName(charsetName);
        return new DataSource<String>(this, (InputFormat<String, ?>)format, (TypeInformation<String>)BasicTypeInfo.STRING_TYPE_INFO);
    }

    public DataSource<StringValue> readTextFileWithValue(String filePath) {
        Validate.notNull((Object)filePath, (String)"The file path may not be null.", (Object[])new Object[0]);
        return new DataSource<StringValue>(this, (InputFormat<StringValue, ?>)new TextValueInputFormat(new Path(filePath)), (TypeInformation<StringValue>)new ValueTypeInfo<StringValue>(StringValue.class));
    }

    public DataSource<StringValue> readTextFileWithValue(String filePath, String charsetName, boolean skipInvalidLines) {
        Validate.notNull((Object)filePath, (String)"The file path may not be null.", (Object[])new Object[0]);
        TextValueInputFormat format = new TextValueInputFormat(new Path(filePath));
        format.setCharsetName(charsetName);
        format.setSkipInvalidLines(skipInvalidLines);
        return new DataSource<StringValue>(this, (InputFormat<StringValue, ?>)format, (TypeInformation<StringValue>)new ValueTypeInfo<StringValue>(StringValue.class));
    }

    public CsvReader readCsvFile(String filePath) {
        return new CsvReader(filePath, this);
    }

    public <X> DataSource<X> readFile(FileInputFormat<X> inputFormat, String filePath) {
        if (inputFormat == null) {
            throw new IllegalArgumentException("InputFormat must not be null.");
        }
        if (filePath == null) {
            throw new IllegalArgumentException("The file path must not be null.");
        }
        inputFormat.setFilePath(new Path(filePath));
        try {
            return this.createInput((InputFormat<X, ?>)inputFormat, (TypeInformation<X>)TypeExtractor.getInputFormatTypes(inputFormat));
        }
        catch (Exception e) {
            throw new InvalidProgramException("The type returned by the input format could not be automatically determined. Please specify the TypeInformation of the produced type explicitly.");
        }
    }

    public <X> DataSource<X> createInput(InputFormat<X, ?> inputFormat) {
        if (inputFormat == null) {
            throw new IllegalArgumentException("InputFormat must not be null.");
        }
        try {
            return this.createInput(inputFormat, TypeExtractor.getInputFormatTypes(inputFormat));
        }
        catch (Exception e) {
            throw new InvalidProgramException("The type returned by the input format could not be automatically determined. Please specify the TypeInformation of the produced type explicitly.");
        }
    }

    public <X> DataSource<X> createInput(InputFormat<X, ?> inputFormat, TypeInformation<X> producedType) {
        if (inputFormat == null) {
            throw new IllegalArgumentException("InputFormat must not be null.");
        }
        if (producedType == null) {
            throw new IllegalArgumentException("Produced type information must not be null.");
        }
        return new DataSource<X>(this, inputFormat, producedType);
    }

    public <X> DataSource<X> fromCollection(Collection<X> data) {
        if (data == null) {
            throw new IllegalArgumentException("The data must not be null.");
        }
        if (data.size() == 0) {
            throw new IllegalArgumentException("The size of the collection must not be empty.");
        }
        X firstValue = data.iterator().next();
        return this.fromCollection(data, TypeExtractor.getForObject(firstValue));
    }

    public <X> DataSource<X> fromCollection(Collection<X> data, TypeInformation<X> type) {
        CollectionInputFormat.checkCollection(data, type.getTypeClass());
        return new DataSource<X>(this, new CollectionInputFormat<X>(data, type.createSerializer()), type);
    }

    public <X> DataSource<X> fromCollection(Iterator<X> data, Class<X> type) {
        return this.fromCollection(data, TypeExtractor.getForClass(type));
    }

    public <X> DataSource<X> fromCollection(Iterator<X> data, TypeInformation<X> type) {
        if (!(data instanceof Serializable)) {
            throw new IllegalArgumentException("The iterator must be serializable.");
        }
        return new DataSource<X>(this, new IteratorInputFormat<X>(data), type);
    }

    public <X> DataSource<X> fromElements(X ... data) {
        if (data == null) {
            throw new IllegalArgumentException("The data must not be null.");
        }
        if (data.length == 0) {
            throw new IllegalArgumentException("The number of elements must not be zero.");
        }
        return this.fromCollection(Arrays.asList(data), TypeExtractor.getForObject(data[0]));
    }

    public <X> DataSource<X> fromParallelCollection(SplittableIterator<X> iterator, Class<X> type) {
        return this.fromParallelCollection(iterator, TypeExtractor.getForClass(type));
    }

    public <X> DataSource<X> fromParallelCollection(SplittableIterator<X> iterator, TypeInformation<X> type) {
        return new DataSource<X>(this, new ParallelIteratorInputFormat<X>(iterator), type);
    }

    public DataSource<Long> generateSequence(long from, long to) {
        return this.fromParallelCollection((SplittableIterator)new NumberSequenceIterator(from, to), (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO);
    }

    public JobExecutionResult execute() throws Exception {
        return this.execute(ExecutionEnvironment.getDefaultName());
    }

    public abstract JobExecutionResult execute(String var1) throws Exception;

    public abstract String getExecutionPlan() throws Exception;

    public void registerCachedFile(String filePath, String name) {
        this.registerCachedFile(filePath, name, false);
    }

    public void registerCachedFile(String filePath, String name, boolean executable) {
        this.cacheFile.add(new Tuple2<String, DistributedCache.DistributedCacheEntry>(name, new DistributedCache.DistributedCacheEntry(filePath, Boolean.valueOf(executable))));
    }

    protected void registerCachedFilesWithPlan(Plan p) throws IOException {
        for (Tuple2<String, DistributedCache.DistributedCacheEntry> entry : this.cacheFile) {
            p.registerCachedFile((String)entry.f0, (DistributedCache.DistributedCacheEntry)entry.f1);
        }
    }

    public JavaPlan createProgramPlan() {
        return this.createProgramPlan(null);
    }

    public JavaPlan createProgramPlan(String jobName) {
        if (this.sinks.isEmpty()) {
            throw new RuntimeException("No data sinks have been created yet. A program needs at least one sink that consumes data. Examples are writing the data set or printing it.");
        }
        if (jobName == null) {
            jobName = ExecutionEnvironment.getDefaultName();
        }
        OperatorTranslation translator = new OperatorTranslation();
        JavaPlan plan = translator.translateToPlan(this.sinks, jobName);
        if (this.getDegreeOfParallelism() > 0) {
            plan.setDefaultParallelism(this.getDegreeOfParallelism());
        }
        try {
            this.registerCachedFilesWithPlan(plan);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while registering cached files: " + e.getMessage(), e);
        }
        this.sinks.clear();
        return plan;
    }

    void registerDataSink(DataSink<?> sink) {
        this.sinks.add(sink);
    }

    private static String getDefaultName() {
        return "Flink Java Job at " + Calendar.getInstance().getTime();
    }

    public static ExecutionEnvironment getExecutionEnvironment() {
        return contextEnvironment == null ? ExecutionEnvironment.createLocalEnvironment() : contextEnvironment;
    }

    public static LocalEnvironment createLocalEnvironment() {
        return ExecutionEnvironment.createLocalEnvironment(defaultLocalDop);
    }

    public static LocalEnvironment createLocalEnvironment(int degreeOfParallelism) {
        LocalEnvironment lee = new LocalEnvironment();
        lee.setDegreeOfParallelism(degreeOfParallelism);
        return lee;
    }

    public static ExecutionEnvironment createRemoteEnvironment(String host, int port, String ... jarFiles) {
        return new RemoteEnvironment(host, port, jarFiles);
    }

    public static ExecutionEnvironment createRemoteEnvironment(String host, int port, int degreeOfParallelism, String ... jarFiles) {
        RemoteEnvironment rec = new RemoteEnvironment(host, port, jarFiles);
        rec.setDegreeOfParallelism(degreeOfParallelism);
        return rec;
    }

    public static void setDefaultLocalParallelism(int degreeOfParallelism) {
        defaultLocalDop = degreeOfParallelism;
    }

    protected static void initializeContextEnvironment(ExecutionEnvironment ctx) {
        contextEnvironment = ctx;
    }

    protected static boolean isContextEnvironmentSet() {
        return contextEnvironment != null;
    }

    protected static void disableLocalExecution() {
        allowLocalExecution = false;
    }

    public static boolean localExecutionIsAllowed() {
        return allowLocalExecution;
    }

    static {
        defaultLocalDop = Runtime.getRuntime().availableProcessors();
        allowLocalExecution = true;
    }
}

