/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.sampling;

import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Random;
import org.apache.flink.api.java.sampling.DistributedRandomSampler;
import org.apache.flink.api.java.sampling.IntermediateSampleData;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.util.XORShiftRandom;

public class ReservoirSamplerWithReplacement<T>
extends DistributedRandomSampler<T> {
    private final Random random;

    public ReservoirSamplerWithReplacement(int numSamples) {
        this(numSamples, (Random)new XORShiftRandom());
    }

    public ReservoirSamplerWithReplacement(int numSamples, long seed) {
        this(numSamples, (Random)new XORShiftRandom(seed));
    }

    public ReservoirSamplerWithReplacement(int numSamples, Random random) {
        super(numSamples);
        Preconditions.checkArgument(numSamples >= 0, "numSamples should be non-negative.");
        this.random = random;
    }

    @Override
    public Iterator<IntermediateSampleData<T>> sampleInPartition(Iterator<T> input) {
        int i;
        T element;
        if (this.numSamples == 0) {
            return this.EMPTY_INTERMEDIATE_ITERABLE;
        }
        PriorityQueue<IntermediateSampleData<T>> queue = new PriorityQueue<IntermediateSampleData<T>>(this.numSamples);
        IntermediateSampleData smallest = null;
        if (input.hasNext()) {
            element = input.next();
            for (i = 0; i < this.numSamples; ++i) {
                queue.add(new IntermediateSampleData<T>(this.random.nextDouble(), element));
                smallest = (IntermediateSampleData)queue.peek();
            }
        }
        while (input.hasNext()) {
            element = input.next();
            for (i = 0; i < this.numSamples; ++i) {
                double rand = this.random.nextDouble();
                if (!(rand > smallest.getWeight())) continue;
                queue.remove();
                queue.add(new IntermediateSampleData<T>(rand, element));
                smallest = (IntermediateSampleData)queue.peek();
            }
        }
        return queue.iterator();
    }
}

