/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.io.GenericCsvInputFormat;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.types.parser.FieldParser;

public abstract class CommonCsvInputFormat<OUT>
extends GenericCsvInputFormat<OUT> {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_LINE_DELIMITER = "\n";
    public static final String DEFAULT_FIELD_DELIMITER = ",";
    protected transient Object[] parsedValues;
    private final Class<OUT> pojoTypeClass;
    private String[] pojoFieldNames;
    private transient PojoTypeInfo<OUT> pojoTypeInfo;
    private transient Field[] pojoFields;

    public CommonCsvInputFormat(Path filePath, CompositeType<OUT> typeInformation) {
        this(filePath, DEFAULT_LINE_DELIMITER, DEFAULT_FIELD_DELIMITER, typeInformation);
    }

    public CommonCsvInputFormat(Path filePath, String lineDelimiter, String fieldDelimiter, CompositeType<OUT> compositeTypeInfo) {
        super(filePath);
        this.setDelimiter(lineDelimiter);
        this.setFieldDelimiter(fieldDelimiter);
        Class[] classes = new Class[compositeTypeInfo.getArity()];
        for (int i = 0; i < compositeTypeInfo.getArity(); ++i) {
            classes[i] = compositeTypeInfo.getTypeAt(i).getTypeClass();
        }
        this.setFieldTypes(classes);
        if (compositeTypeInfo instanceof PojoTypeInfo) {
            this.pojoTypeInfo = (PojoTypeInfo)compositeTypeInfo;
            this.pojoTypeClass = compositeTypeInfo.getTypeClass();
            this.setOrderOfPOJOFields(compositeTypeInfo.getFieldNames());
        } else {
            this.pojoTypeClass = null;
            this.pojoFieldNames = null;
        }
    }

    public void setOrderOfPOJOFields(String[] fieldNames) {
        Preconditions.checkNotNull(this.pojoTypeClass, "Field order can only be specified if output type is a POJO.");
        Preconditions.checkNotNull(fieldNames);
        int includedCount = 0;
        for (boolean isIncluded : this.fieldIncluded) {
            if (!isIncluded) continue;
            ++includedCount;
        }
        Preconditions.checkArgument(includedCount == fieldNames.length, includedCount + " CSV fields and " + fieldNames.length + " POJO fields selected. The number of selected CSV and POJO fields must be equal.");
        for (String field : fieldNames) {
            Preconditions.checkNotNull(field, "The field name cannot be null.");
            Preconditions.checkArgument(this.pojoTypeInfo.getFieldIndex(field) != -1, "Field \"" + field + "\" is not a member of POJO class " + this.pojoTypeClass.getName());
        }
        this.pojoFieldNames = Arrays.copyOfRange(fieldNames, 0, fieldNames.length);
    }

    public void setFieldTypes(Class<?> ... fieldTypes) {
        if (fieldTypes == null || fieldTypes.length == 0) {
            throw new IllegalArgumentException("Field types must not be null or empty.");
        }
        this.setFieldTypesGeneric(fieldTypes);
    }

    public void setFields(int[] sourceFieldIndices, Class<?>[] fieldTypes) {
        Preconditions.checkNotNull(sourceFieldIndices);
        Preconditions.checkNotNull(fieldTypes);
        CommonCsvInputFormat.checkForMonotonousOrder((int[])sourceFieldIndices, (Class[])fieldTypes);
        this.setFieldsGeneric(sourceFieldIndices, fieldTypes);
    }

    public void setFields(boolean[] sourceFieldMask, Class<?>[] fieldTypes) {
        Preconditions.checkNotNull(sourceFieldMask);
        Preconditions.checkNotNull(fieldTypes);
        this.setFieldsGeneric(sourceFieldMask, fieldTypes);
    }

    public Class<?>[] getFieldTypes() {
        return super.getGenericFieldTypes();
    }

    public void open(FileInputSplit split) throws IOException {
        super.open(split);
        FieldParser[] fieldParsers = this.getFieldParsers();
        if (fieldParsers.length == 0) {
            throw new IOException("CsvInputFormat.open(FileInputSplit split) - no field parsers to parse input");
        }
        this.parsedValues = new Object[fieldParsers.length];
        for (int i = 0; i < fieldParsers.length; ++i) {
            this.parsedValues[i] = fieldParsers[i].createValue();
        }
        if (this.getDelimiter().length == 1 && this.getDelimiter()[0] == 10) {
            this.lineDelimiterIsLinebreak = true;
        }
        if (this.pojoTypeClass != null) {
            this.pojoFields = new Field[this.pojoFieldNames.length];
            HashMap<String, Field> allFields = new HashMap<String, Field>();
            this.findAllFields(this.pojoTypeClass, allFields);
            for (int i = 0; i < this.pojoFieldNames.length; ++i) {
                this.pojoFields[i] = (Field)allFields.get(this.pojoFieldNames[i]);
                if (this.pojoFields[i] == null) {
                    throw new RuntimeException("There is no field called \"" + this.pojoFieldNames[i] + "\" in " + this.pojoTypeClass.getName());
                }
                this.pojoFields[i].setAccessible(true);
            }
        }
        this.commentCount = 0;
        this.invalidLineCount = 0;
    }

    private void findAllFields(Class<?> clazz, Map<String, Field> allFields) {
        for (Field field : clazz.getDeclaredFields()) {
            allFields.put(field.getName(), field);
        }
        if (clazz.getSuperclass() != null) {
            this.findAllFields(clazz.getSuperclass(), allFields);
        }
    }

    public OUT nextRecord(OUT record) throws IOException {
        Object returnRecord = null;
        while ((returnRecord = super.nextRecord(record)) == null && !this.reachedEnd()) {
        }
        return (OUT)returnRecord;
    }

    public OUT readRecord(OUT reuse, byte[] bytes, int offset, int numBytes) throws IOException {
        if (this.lineDelimiterIsLinebreak && numBytes > 0 && bytes[offset + numBytes - 1] == 13) {
            --numBytes;
        }
        if (this.commentPrefix != null && this.commentPrefix.length <= numBytes) {
            boolean isComment = true;
            for (int i = 0; i < this.commentPrefix.length; ++i) {
                if (this.commentPrefix[i] == bytes[offset + i]) continue;
                isComment = false;
                break;
            }
            if (isComment) {
                ++this.commentCount;
                return null;
            }
        }
        if (this.parseRecord(this.parsedValues, bytes, offset, numBytes)) {
            if (this.pojoTypeClass == null) {
                return this.createTuple(reuse);
            }
            for (int i = 0; i < this.parsedValues.length; ++i) {
                try {
                    this.pojoFields[i].set(reuse, this.parsedValues[i]);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Parsed value could not be set in POJO field \"" + this.pojoFieldNames[i] + "\"", e);
                }
            }
            return reuse;
        }
        ++this.invalidLineCount;
        return null;
    }

    protected abstract OUT createTuple(OUT var1);
}

