/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.WritableComparator;
import org.apache.flink.api.java.typeutils.runtime.WritableSerializer;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.io.Writable;

public class WritableTypeInfo<T extends Writable>
extends TypeInformation<T>
implements AtomicType<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> typeClass;

    public WritableTypeInfo(Class<T> typeClass) {
        this.typeClass = Preconditions.checkNotNull(typeClass);
        Preconditions.checkArgument(Writable.class.isAssignableFrom(typeClass) && !typeClass.equals(Writable.class), "WritableTypeInfo can only be used for subclasses of " + Writable.class.getName());
    }

    public TypeComparator<T> createComparator(boolean sortOrderAscending, ExecutionConfig executionConfig) {
        if (Comparable.class.isAssignableFrom(this.typeClass)) {
            return new WritableComparator<T>(sortOrderAscending, this.typeClass);
        }
        throw new UnsupportedOperationException("Cannot create Comparator for " + this.typeClass.getCanonicalName() + ". " + "Class does not implement Comparable interface.");
    }

    public boolean isBasicType() {
        return false;
    }

    public boolean isTupleType() {
        return false;
    }

    public int getArity() {
        return 1;
    }

    public int getTotalFields() {
        return 1;
    }

    public Class<T> getTypeClass() {
        return this.typeClass;
    }

    public boolean isKeyType() {
        return Comparable.class.isAssignableFrom(this.typeClass);
    }

    public TypeSerializer<T> createSerializer(ExecutionConfig executionConfig) {
        return new WritableSerializer<T>(this.typeClass);
    }

    public String toString() {
        return "WritableType<" + this.typeClass.getName() + ">";
    }

    public int hashCode() {
        return this.typeClass.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof WritableTypeInfo) {
            WritableTypeInfo writableTypeInfo = (WritableTypeInfo)((Object)obj);
            return writableTypeInfo.canEqual((Object)this) && this.typeClass == writableTypeInfo.typeClass;
        }
        return false;
    }

    public boolean canEqual(Object obj) {
        return obj instanceof WritableTypeInfo;
    }

    static <T extends Writable> TypeInformation<T> getWritableTypeInfo(Class<T> typeClass) {
        if (Writable.class.isAssignableFrom(typeClass) && !typeClass.equals(Writable.class)) {
            return new WritableTypeInfo<T>(typeClass);
        }
        throw new InvalidTypesException("The given class is no subclass of " + Writable.class.getName());
    }
}

