/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.hadoop.mapreduce.utils;

import java.lang.reflect.Constructor;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;

public final class HadoopUtils {
    public static void mergeHadoopConf(Configuration configuration) {
        Configuration hadoopConf = org.apache.flink.api.java.hadoop.mapred.utils.HadoopUtils.getHadoopConfiguration();
        for (Map.Entry e : hadoopConf) {
            configuration.set((String)e.getKey(), (String)e.getValue());
        }
    }

    public static JobContext instantiateJobContext(Configuration configuration, JobID jobId) throws Exception {
        try {
            Class<?> clazz = JobContext.class.isInterface() ? Class.forName("org.apache.hadoop.mapreduce.task.JobContextImpl", true, Thread.currentThread().getContextClassLoader()) : Class.forName("org.apache.hadoop.mapreduce.JobContext", true, Thread.currentThread().getContextClassLoader());
            Constructor<?> constructor = clazz.getConstructor(Configuration.class, JobID.class);
            JobContext context = (JobContext)constructor.newInstance(configuration, jobId);
            return context;
        }
        catch (Exception e) {
            throw new Exception("Could not create instance of JobContext.");
        }
    }

    public static TaskAttemptContext instantiateTaskAttemptContext(Configuration configuration, TaskAttemptID taskAttemptID) throws Exception {
        try {
            Class<?> clazz = JobContext.class.isInterface() ? Class.forName("org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl") : Class.forName("org.apache.hadoop.mapreduce.TaskAttemptContext");
            Constructor<?> constructor = clazz.getConstructor(Configuration.class, TaskAttemptID.class);
            TaskAttemptContext context = (TaskAttemptContext)constructor.newInstance(configuration, taskAttemptID);
            return context;
        }
        catch (Exception e) {
            throw new Exception("Could not create instance of TaskAttemptContext.");
        }
    }

    private HadoopUtils() {
        throw new RuntimeException();
    }
}

