/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.record.io;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.flink.api.common.io.GenericInputFormat;
import org.apache.flink.api.common.io.NonParallelInput;
import org.apache.flink.core.io.GenericInputSplit;
import org.apache.flink.types.Record;
import org.apache.flink.types.ValueUtil;

public class CollectionInputFormat
extends GenericInputFormat<Record>
implements NonParallelInput {
    private static final long serialVersionUID = 1L;
    private Collection<?> dataSet;
    private Iterator<?> serializableIter;
    private transient Iterator<?> it;

    public boolean reachedEnd() throws IOException {
        return !this.it.hasNext();
    }

    public void open(GenericInputSplit split) throws IOException {
        super.open(split);
        this.it = this.serializableIter != null ? this.serializableIter : this.dataSet.iterator();
    }

    public Record nextRecord(Record record) throws IOException {
        if (this.it.hasNext()) {
            record.clear();
            Object b = this.it.next();
            if (b.getClass().isArray()) {
                for (Object s : (Object[])b) {
                    record.addField(ValueUtil.toFlinkValueType((Object)s));
                }
            } else if (b instanceof Collection) {
                for (Object s : (Collection)b) {
                    record.addField(ValueUtil.toFlinkValueType(s));
                }
            } else {
                record.setField(0, ValueUtil.toFlinkValueType(b));
            }
            return record;
        }
        return null;
    }

    public void setData(Collection<?> data) {
        this.dataSet = data;
        this.serializableIter = null;
    }

    public <T extends Iterator<?>, Serializable> void setIter(T iter) {
        this.serializableIter = iter;
    }
}

