/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.changelog.fs;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.JobID;
import org.apache.flink.changelog.fs.ChangelogStreamHandleReaderWithCache;
import org.apache.flink.changelog.fs.FsStateChangelogOptions;
import org.apache.flink.changelog.fs.FsStateChangelogStorage;
import org.apache.flink.changelog.fs.FsStateChangelogStorageForRecovery;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.StateChangelogOptions;
import org.apache.flink.runtime.metrics.groups.TaskManagerJobMetricGroup;
import org.apache.flink.runtime.state.LocalRecoveryConfig;
import org.apache.flink.runtime.state.changelog.StateChangelogStorage;
import org.apache.flink.runtime.state.changelog.StateChangelogStorageFactory;
import org.apache.flink.runtime.state.changelog.StateChangelogStorageView;

@Internal
public class FsStateChangelogStorageFactory
implements StateChangelogStorageFactory {
    public static final String IDENTIFIER = "filesystem";

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public StateChangelogStorage<?> createStorage(JobID jobID, Configuration configuration, TaskManagerJobMetricGroup metricGroup, LocalRecoveryConfig localRecoveryConfig) throws IOException {
        return new FsStateChangelogStorage(jobID, configuration, metricGroup, localRecoveryConfig);
    }

    public StateChangelogStorageView<?> createStorageView(Configuration configuration) {
        return new FsStateChangelogStorageForRecovery(new ChangelogStreamHandleReaderWithCache(configuration));
    }

    public static void configure(Configuration configuration, File newFolder, Duration uploadTimeout, int maxUploadAttempts) {
        configuration.set(StateChangelogOptions.STATE_CHANGE_LOG_STORAGE, (Object)IDENTIFIER);
        configuration.set(FsStateChangelogOptions.BASE_PATH, (Object)newFolder.getAbsolutePath());
        configuration.set(FsStateChangelogOptions.UPLOAD_TIMEOUT, (Object)uploadTimeout);
        configuration.set(FsStateChangelogOptions.RETRY_MAX_ATTEMPTS, (Object)maxUploadAttempts);
    }
}

