/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.changelog.fs;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.flink.api.common.JobID;
import org.apache.flink.changelog.fs.AbstractStateChangeFsUploader;
import org.apache.flink.changelog.fs.ChangelogStorageMetricGroup;
import org.apache.flink.changelog.fs.DuplicatingOutputStreamWithPos;
import org.apache.flink.changelog.fs.OutputStreamWithPos;
import org.apache.flink.changelog.fs.TaskChangelogRegistry;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.ChangelogTaskLocalStateStore;
import org.apache.flink.runtime.state.LocalRecoveryDirectoryProvider;
import org.apache.flink.runtime.state.filesystem.FileStateHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicatingStateChangeFsUploader
extends AbstractStateChangeFsUploader {
    private static final Logger LOG = LoggerFactory.getLogger(DuplicatingStateChangeFsUploader.class);
    private final Path basePath;
    private final FileSystem fileSystem;
    private final LocalRecoveryDirectoryProvider localRecoveryDirectoryProvider;
    private final JobID jobID;

    public DuplicatingStateChangeFsUploader(JobID jobID, Path basePath, FileSystem fileSystem, boolean compression, int bufferSize, ChangelogStorageMetricGroup metrics, TaskChangelogRegistry changelogRegistry, LocalRecoveryDirectoryProvider localRecoveryDirectoryProvider) {
        super(compression, bufferSize, metrics, changelogRegistry, FileStateHandle::new);
        this.basePath = new Path(basePath, String.format("%s/%s", jobID.toHexString(), "dstl"));
        this.fileSystem = fileSystem;
        this.localRecoveryDirectoryProvider = localRecoveryDirectoryProvider;
        this.jobID = jobID;
    }

    @Override
    public OutputStreamWithPos prepareStream() throws IOException {
        String fileName = this.generateFileName();
        LOG.debug("upload tasks to {}", (Object)fileName);
        Path path = new Path(this.basePath, fileName);
        FSDataOutputStream primaryStream = this.fileSystem.create(path, FileSystem.WriteMode.NO_OVERWRITE);
        Path localPath = new Path(ChangelogTaskLocalStateStore.getLocalTaskOwnedDirectory((LocalRecoveryDirectoryProvider)this.localRecoveryDirectoryProvider, (JobID)this.jobID), fileName);
        FSDataOutputStream secondaryStream = localPath.getFileSystem().create(localPath, FileSystem.WriteMode.NO_OVERWRITE);
        DuplicatingOutputStreamWithPos outputStream = new DuplicatingOutputStreamWithPos((OutputStream)primaryStream, path, (OutputStream)secondaryStream, localPath);
        outputStream.wrap(this.compression, this.bufferSize);
        return outputStream;
    }

    @Override
    public void close() throws Exception {
    }
}

