/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.context;

import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.watermark.WatermarkManager;
import org.apache.flink.datastream.api.common.Collector;
import org.apache.flink.datastream.api.context.JobInfo;
import org.apache.flink.datastream.api.context.TaskInfo;
import org.apache.flink.datastream.api.context.TwoOutputNonPartitionedContext;
import org.apache.flink.datastream.api.function.TwoOutputApplyPartitionFunction;
import org.apache.flink.datastream.impl.context.DefaultRuntimeContext;
import org.apache.flink.datastream.impl.context.DefaultTwoOutputPartitionedContext;
import org.apache.flink.datastream.impl.watermark.DefaultWatermarkManager;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.runtime.watermark.AbstractInternalWatermarkDeclaration;

public class DefaultTwoOutputNonPartitionedContext<OUT1, OUT2>
implements TwoOutputNonPartitionedContext<OUT1, OUT2> {
    protected final DefaultRuntimeContext context;
    private final DefaultTwoOutputPartitionedContext<OUT1, OUT2> partitionedContext;
    protected final Collector<OUT1> firstCollector;
    protected final Collector<OUT2> secondCollector;
    private final boolean isKeyed;
    private final Set<Object> keySet;
    private final WatermarkManager watermarkManager;

    public DefaultTwoOutputNonPartitionedContext(DefaultRuntimeContext context, DefaultTwoOutputPartitionedContext<OUT1, OUT2> partitionedContext, Collector<OUT1> firstCollector, Collector<OUT2> secondCollector, boolean isKeyed, Set<Object> keySet, Output<?> streamRecordOutput, Map<String, AbstractInternalWatermarkDeclaration<?>> watermarkDeclarationMap) {
        this.context = context;
        this.partitionedContext = partitionedContext;
        this.firstCollector = firstCollector;
        this.secondCollector = secondCollector;
        this.isKeyed = isKeyed;
        this.keySet = keySet;
        this.watermarkManager = new DefaultWatermarkManager(streamRecordOutput, watermarkDeclarationMap);
    }

    public void applyToAllPartitions(TwoOutputApplyPartitionFunction<OUT1, OUT2> applyPartitionFunction) throws Exception {
        if (this.isKeyed) {
            for (Object key : this.keySet) {
                this.partitionedContext.getStateManager().executeInKeyContext(() -> {
                    try {
                        applyPartitionFunction.apply(this.firstCollector, this.secondCollector, this.partitionedContext);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }, key);
            }
        } else {
            applyPartitionFunction.apply(this.firstCollector, this.secondCollector, this.partitionedContext);
        }
    }

    public WatermarkManager getWatermarkManager() {
        return this.watermarkManager;
    }

    public JobInfo getJobInfo() {
        return this.context.getJobInfo();
    }

    public TaskInfo getTaskInfo() {
        return this.context.getTaskInfo();
    }

    public MetricGroup getMetricGroup() {
        return this.context.getMetricGroup();
    }
}

