/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.stream;

import java.util.Collections;
import java.util.HashSet;
import org.apache.flink.api.common.state.StateDeclaration;
import org.apache.flink.api.common.state.v2.ListStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.dsv2.Sink;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.datastream.api.function.OneInputStreamProcessFunction;
import org.apache.flink.datastream.api.function.TwoInputBroadcastStreamProcessFunction;
import org.apache.flink.datastream.api.function.TwoInputNonBroadcastStreamProcessFunction;
import org.apache.flink.datastream.api.function.TwoOutputStreamProcessFunction;
import org.apache.flink.datastream.api.stream.BroadcastStream;
import org.apache.flink.datastream.api.stream.GlobalStream;
import org.apache.flink.datastream.api.stream.KeyedPartitionStream;
import org.apache.flink.datastream.api.stream.NonKeyedPartitionStream;
import org.apache.flink.datastream.api.stream.ProcessConfigurable;
import org.apache.flink.datastream.impl.attribute.AttributeParser;
import org.apache.flink.datastream.impl.extension.join.operators.TwoInputNonBroadcastJoinProcessFunction;
import org.apache.flink.datastream.impl.extension.join.operators.TwoInputNonBroadcastJoinProcessOperator;
import org.apache.flink.datastream.impl.extension.window.function.InternalOneInputWindowStreamProcessFunction;
import org.apache.flink.datastream.impl.extension.window.function.InternalTwoInputWindowStreamProcessFunction;
import org.apache.flink.datastream.impl.extension.window.function.InternalTwoOutputWindowStreamProcessFunction;
import org.apache.flink.datastream.impl.operators.KeyedProcessOperator;
import org.apache.flink.datastream.impl.operators.KeyedTwoInputBroadcastProcessOperator;
import org.apache.flink.datastream.impl.operators.KeyedTwoInputNonBroadcastProcessOperator;
import org.apache.flink.datastream.impl.operators.KeyedTwoOutputProcessOperator;
import org.apache.flink.datastream.impl.stream.AbstractDataStream;
import org.apache.flink.datastream.impl.stream.BroadcastStreamImpl;
import org.apache.flink.datastream.impl.stream.GlobalStreamImpl;
import org.apache.flink.datastream.impl.stream.NonKeyedPartitionStreamImpl;
import org.apache.flink.datastream.impl.stream.ProcessConfigurableAndKeyedPartitionStreamImpl;
import org.apache.flink.datastream.impl.stream.ProcessConfigurableAndTwoKeyedPartitionStreamsImpl;
import org.apache.flink.datastream.impl.stream.ProcessConfigurableAndTwoNonKeyedPartitionStreamImpl;
import org.apache.flink.datastream.impl.utils.StreamUtils;
import org.apache.flink.streaming.api.transformations.DataStreamV2SinkTransformation;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.api.transformations.PartitionTransformation;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;
import org.apache.flink.streaming.runtime.partitioner.GlobalPartitioner;
import org.apache.flink.streaming.runtime.partitioner.KeyGroupStreamPartitioner;
import org.apache.flink.streaming.runtime.partitioner.ShufflePartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;

public class KeyedPartitionStreamImpl<K, V>
extends AbstractDataStream<V>
implements KeyedPartitionStream<K, V> {
    private final KeySelector<V, K> keySelector;
    private final TypeInformation<K> keyType;

    public KeyedPartitionStreamImpl(AbstractDataStream<V> dataStream, KeySelector<V, K> keySelector) {
        this(dataStream, keySelector, TypeExtractor.getKeySelectorTypes(keySelector, dataStream.getType()));
    }

    public KeyedPartitionStreamImpl(AbstractDataStream<V> dataStream, KeySelector<V, K> keySelector, TypeInformation<K> keyType) {
        this(dataStream, (Transformation<V>)new PartitionTransformation(dataStream.getTransformation(), (StreamPartitioner)new KeyGroupStreamPartitioner(keySelector, 128)), keySelector, keyType);
    }

    public KeyedPartitionStreamImpl(AbstractDataStream<V> dataStream, Transformation<V> partitionTransformation, KeySelector<V, K> keySelector, TypeInformation<K> keyType) {
        super(dataStream.getEnvironment(), partitionTransformation);
        this.keySelector = keySelector;
        this.keyType = keyType;
    }

    public <OUT> NonKeyedPartitionStream.ProcessConfigurableAndNonKeyedPartitionStream<OUT> process(OneInputStreamProcessFunction<V, OUT> processFunction) {
        Transformation<OUT> transform;
        StreamUtils.validateStates(processFunction.usesStates(), new HashSet<StateDeclaration.RedistributionMode>(Collections.singletonList(StateDeclaration.RedistributionMode.IDENTICAL)));
        TypeInformation<OUT> outType = StreamUtils.getOutputTypeForOneInputProcessFunction(processFunction, this.getType());
        if (processFunction instanceof InternalOneInputWindowStreamProcessFunction) {
            transform = StreamUtils.transformOneInputWindow(this.environment.getExecutionConfig(), this, this.getType(), outType, (InternalOneInputWindowStreamProcessFunction)processFunction, this.keySelector, this.keyType);
        } else {
            KeyedProcessOperator operator = new KeyedProcessOperator(processFunction);
            transform = StreamUtils.getOneInputKeyedTransformation("KeyedProcess", this, outType, operator, this.keySelector, this.keyType);
        }
        transform.setAttribute(AttributeParser.parseAttribute(processFunction));
        this.environment.addOperator(transform);
        return StreamUtils.wrapWithConfigureHandle(new NonKeyedPartitionStreamImpl<OUT>(this.environment, transform));
    }

    public <OUT> KeyedPartitionStream.ProcessConfigurableAndKeyedPartitionStream<K, OUT> process(OneInputStreamProcessFunction<V, OUT> processFunction, KeySelector<OUT, K> newKeySelector) {
        Transformation<OUT> transform;
        StreamUtils.validateStates(processFunction.usesStates(), new HashSet<StateDeclaration.RedistributionMode>(Collections.singletonList(StateDeclaration.RedistributionMode.IDENTICAL)));
        TypeInformation<OUT> outType = StreamUtils.getOutputTypeForOneInputProcessFunction(processFunction, this.getType());
        if (processFunction instanceof InternalOneInputWindowStreamProcessFunction) {
            transform = StreamUtils.transformOneInputWindow(this.environment.getExecutionConfig(), this, this.getType(), outType, (InternalOneInputWindowStreamProcessFunction)processFunction, this.keySelector, this.keyType);
        } else {
            KeyedProcessOperator operator = new KeyedProcessOperator(processFunction, (KeySelector)Preconditions.checkNotNull(newKeySelector));
            transform = StreamUtils.getOneInputKeyedTransformation("KeyedProcess", this, outType, operator, this.keySelector, this.keyType);
        }
        NonKeyedPartitionStreamImpl<OUT> outputStream = new NonKeyedPartitionStreamImpl<OUT>(this.environment, transform);
        transform.setAttribute(AttributeParser.parseAttribute(processFunction));
        this.environment.addOperator(transform);
        return StreamUtils.wrapWithConfigureHandle(new KeyedPartitionStreamImpl<K, OUT>(outputStream, transform, newKeySelector, TypeExtractor.getKeySelectorTypes(newKeySelector, outputStream.getType())));
    }

    public <OUT1, OUT2> KeyedPartitionStream.ProcessConfigurableAndTwoKeyedPartitionStreams<K, OUT1, OUT2> process(TwoOutputStreamProcessFunction<V, OUT1, OUT2> processFunction, KeySelector<OUT1, K> keySelector1, KeySelector<OUT2, K> keySelector2) {
        Transformation mainOutputTransform;
        StreamUtils.validateStates(processFunction.usesStates(), new HashSet<StateDeclaration.RedistributionMode>(Collections.singletonList(StateDeclaration.RedistributionMode.IDENTICAL)));
        Tuple2<TypeInformation<OUT1>, TypeInformation<OUT2>> twoOutputType = StreamUtils.getOutputTypesForTwoOutputProcessFunction(processFunction, this.getType());
        TypeInformation firstOutputType = (TypeInformation)twoOutputType.f0;
        TypeInformation secondOutputType = (TypeInformation)twoOutputType.f1;
        OutputTag secondOutputTag = new OutputTag("Second-Output", secondOutputType);
        if (processFunction instanceof InternalTwoOutputWindowStreamProcessFunction) {
            mainOutputTransform = StreamUtils.transformTwoOutputWindow(this.environment.getExecutionConfig(), this, this.getType(), firstOutputType, secondOutputType, secondOutputTag, (InternalTwoOutputWindowStreamProcessFunction)processFunction, this.keySelector, this.keyType);
        } else {
            KeyedTwoOutputProcessOperator<K, V, OUT1, OUT2> operator = new KeyedTwoOutputProcessOperator<K, V, OUT1, OUT2>(processFunction, secondOutputTag, keySelector1, keySelector2);
            mainOutputTransform = StreamUtils.getOneInputKeyedTransformation("Two-Output-Process", this, firstOutputType, operator, this.keySelector, this.keyType);
        }
        mainOutputTransform.setAttribute(AttributeParser.parseAttribute(processFunction));
        NonKeyedPartitionStreamImpl nonKeyedMainOutputStream = new NonKeyedPartitionStreamImpl(this.environment, mainOutputTransform);
        Transformation sideOutputTransform = nonKeyedMainOutputStream.getSideOutputTransform(secondOutputTag);
        NonKeyedPartitionStreamImpl nonKeyedSideStream = new NonKeyedPartitionStreamImpl(this.environment, sideOutputTransform);
        KeyedPartitionStreamImpl keyedMainOutputStream = new KeyedPartitionStreamImpl(nonKeyedMainOutputStream, mainOutputTransform, keySelector1, TypeExtractor.getKeySelectorTypes(keySelector1, nonKeyedMainOutputStream.getType()));
        KeyedPartitionStreamImpl keyedSideOutputStream = new KeyedPartitionStreamImpl(nonKeyedSideStream, sideOutputTransform, keySelector2, TypeExtractor.getKeySelectorTypes(keySelector2, nonKeyedSideStream.getType()));
        this.environment.addOperator(mainOutputTransform);
        return new ProcessConfigurableAndTwoKeyedPartitionStreamsImpl(this.environment, mainOutputTransform, keyedMainOutputStream, keyedSideOutputStream);
    }

    public <OUT1, OUT2> NonKeyedPartitionStream.ProcessConfigurableAndTwoNonKeyedPartitionStream<OUT1, OUT2> process(TwoOutputStreamProcessFunction<V, OUT1, OUT2> processFunction) {
        OneInputTransformation firstTransformation;
        StreamUtils.validateStates(processFunction.usesStates(), new HashSet<StateDeclaration.RedistributionMode>(Collections.singletonList(StateDeclaration.RedistributionMode.IDENTICAL)));
        Tuple2<TypeInformation<OUT1>, TypeInformation<OUT2>> twoOutputType = StreamUtils.getOutputTypesForTwoOutputProcessFunction(processFunction, this.getType());
        TypeInformation firstOutputType = (TypeInformation)twoOutputType.f0;
        TypeInformation secondOutputType = (TypeInformation)twoOutputType.f1;
        OutputTag secondOutputTag = new OutputTag("Second-Output", secondOutputType);
        if (processFunction instanceof InternalTwoOutputWindowStreamProcessFunction) {
            firstTransformation = StreamUtils.transformTwoOutputWindow(this.environment.getExecutionConfig(), this, this.getType(), firstOutputType, secondOutputType, secondOutputTag, (InternalTwoOutputWindowStreamProcessFunction)processFunction, this.keySelector, this.keyType);
        } else {
            KeyedTwoOutputProcessOperator operator = new KeyedTwoOutputProcessOperator(processFunction, secondOutputTag);
            firstTransformation = StreamUtils.getOneInputKeyedTransformation("Two-Output-Process", this, firstOutputType, operator, this.keySelector, this.keyType);
        }
        firstTransformation.setAttribute(AttributeParser.parseAttribute(processFunction));
        NonKeyedPartitionStreamImpl firstStream = new NonKeyedPartitionStreamImpl(this.environment, firstTransformation);
        NonKeyedPartitionStreamImpl secondStream = new NonKeyedPartitionStreamImpl(this.environment, firstStream.getSideOutputTransform(secondOutputTag));
        this.environment.addOperator((Transformation<?>)firstTransformation);
        return new ProcessConfigurableAndTwoNonKeyedPartitionStreamImpl(this.environment, firstTransformation, firstStream, secondStream);
    }

    public <T_OTHER, OUT> NonKeyedPartitionStream.ProcessConfigurableAndNonKeyedPartitionStream<OUT> connectAndProcess(KeyedPartitionStream<K, T_OTHER> other, TwoInputNonBroadcastStreamProcessFunction<V, T_OTHER, OUT> processFunction) {
        Transformation<OUT> outTransformation;
        StreamUtils.validateStates(processFunction.usesStates(), new HashSet<StateDeclaration.RedistributionMode>(Collections.singletonList(StateDeclaration.RedistributionMode.IDENTICAL)));
        other = other instanceof ProcessConfigurableAndKeyedPartitionStreamImpl ? ((ProcessConfigurableAndKeyedPartitionStreamImpl)other).getKeyedPartitionStream() : other;
        TypeInformation<OUT> outTypeInfo = StreamUtils.getOutputTypeForTwoInputNonBroadcastProcessFunction(processFunction, this.getType(), ((KeyedPartitionStreamImpl)other).getType());
        if (processFunction instanceof TwoInputNonBroadcastJoinProcessFunction) {
            outTransformation = this.getJoinTransformation(other, processFunction, outTypeInfo);
        } else if (processFunction instanceof InternalTwoInputWindowStreamProcessFunction) {
            outTransformation = StreamUtils.transformTwoInputNonBroadcastWindow(this.environment.getExecutionConfig(), this.transformation, this.getType(), ((KeyedPartitionStreamImpl)other).getTransformation(), ((KeyedPartitionStreamImpl)other).getType(), outTypeInfo, (InternalTwoInputWindowStreamProcessFunction)processFunction, this.keySelector, this.keyType, ((KeyedPartitionStreamImpl)other).getKeySelector(), ((KeyedPartitionStreamImpl)other).getKeyType());
        } else {
            KeyedTwoInputNonBroadcastProcessOperator processOperator = new KeyedTwoInputNonBroadcastProcessOperator(processFunction);
            outTransformation = StreamUtils.getTwoInputTransformation("Keyed-TwoInput-Process", this, (KeyedPartitionStreamImpl)other, outTypeInfo, processOperator);
        }
        outTransformation.setAttribute(AttributeParser.parseAttribute(processFunction));
        this.environment.addOperator(outTransformation);
        return StreamUtils.wrapWithConfigureHandle(new NonKeyedPartitionStreamImpl<OUT>(this.environment, outTransformation));
    }

    public <T_OTHER, OUT> KeyedPartitionStream.ProcessConfigurableAndKeyedPartitionStream<K, OUT> connectAndProcess(KeyedPartitionStream<K, T_OTHER> other, TwoInputNonBroadcastStreamProcessFunction<V, T_OTHER, OUT> processFunction, KeySelector<OUT, K> newKeySelector) {
        StreamUtils.validateStates(processFunction.usesStates(), new HashSet<StateDeclaration.RedistributionMode>(Collections.singletonList(StateDeclaration.RedistributionMode.IDENTICAL)));
        other = other instanceof ProcessConfigurableAndKeyedPartitionStreamImpl ? ((ProcessConfigurableAndKeyedPartitionStreamImpl)other).getKeyedPartitionStream() : other;
        TypeInformation<OUT> outTypeInfo = StreamUtils.getOutputTypeForTwoInputNonBroadcastProcessFunction(processFunction, this.getType(), ((KeyedPartitionStreamImpl)other).getType());
        KeyedTwoInputNonBroadcastProcessOperator<K, V, T_OTHER, OUT> processOperator = new KeyedTwoInputNonBroadcastProcessOperator<K, V, T_OTHER, OUT>(processFunction, newKeySelector);
        TwoInputTransformation outTransformation = StreamUtils.getTwoInputTransformation("Keyed-TwoInput-Process", this, (KeyedPartitionStreamImpl)other, outTypeInfo, processOperator);
        outTransformation.setAttribute(AttributeParser.parseAttribute(processFunction));
        NonKeyedPartitionStreamImpl nonKeyedOutputStream = new NonKeyedPartitionStreamImpl(this.environment, outTransformation);
        this.environment.addOperator((Transformation<?>)outTransformation);
        return StreamUtils.wrapWithConfigureHandle(new KeyedPartitionStreamImpl(nonKeyedOutputStream, outTransformation, newKeySelector, TypeExtractor.getKeySelectorTypes(newKeySelector, nonKeyedOutputStream.getType())));
    }

    public <T_OTHER, OUT> NonKeyedPartitionStream.ProcessConfigurableAndNonKeyedPartitionStream<OUT> connectAndProcess(BroadcastStream<T_OTHER> other, TwoInputBroadcastStreamProcessFunction<V, T_OTHER, OUT> processFunction) {
        TypeInformation<OUT> outTypeInfo = StreamUtils.getOutputTypeForTwoInputBroadcastProcessFunction(processFunction, this.getType(), ((BroadcastStreamImpl)other).getType());
        KeyedTwoInputBroadcastProcessOperator processOperator = new KeyedTwoInputBroadcastProcessOperator(processFunction);
        TwoInputTransformation outTransformation = StreamUtils.getTwoInputTransformation("Keyed-TwoInput-Broadcast-Process", this, (BroadcastStreamImpl)other, outTypeInfo, processOperator);
        outTransformation.setAttribute(AttributeParser.parseAttribute(processFunction));
        this.environment.addOperator((Transformation<?>)outTransformation);
        return StreamUtils.wrapWithConfigureHandle(new NonKeyedPartitionStreamImpl(this.environment, outTransformation));
    }

    public <T_OTHER, OUT> KeyedPartitionStream.ProcessConfigurableAndKeyedPartitionStream<K, OUT> connectAndProcess(BroadcastStream<T_OTHER> other, TwoInputBroadcastStreamProcessFunction<V, T_OTHER, OUT> processFunction, KeySelector<OUT, K> newKeySelector) {
        TypeInformation<OUT> outTypeInfo = StreamUtils.getOutputTypeForTwoInputBroadcastProcessFunction(processFunction, this.getType(), ((BroadcastStreamImpl)other).getType());
        KeyedTwoInputBroadcastProcessOperator processOperator = new KeyedTwoInputBroadcastProcessOperator(processFunction, (KeySelector)Preconditions.checkNotNull(newKeySelector));
        TwoInputTransformation outTransformation = StreamUtils.getTwoInputTransformation("Keyed-TwoInput-Broadcast-Process", this, (BroadcastStreamImpl)other, outTypeInfo, processOperator);
        NonKeyedPartitionStreamImpl outputStream = new NonKeyedPartitionStreamImpl(this.environment, outTransformation);
        outTransformation.setAttribute(AttributeParser.parseAttribute(processFunction));
        this.environment.addOperator((Transformation<?>)outTransformation);
        return StreamUtils.wrapWithConfigureHandle(new KeyedPartitionStreamImpl(outputStream, outTransformation, newKeySelector, TypeExtractor.getKeySelectorTypes(newKeySelector, outputStream.getType())));
    }

    public <T_OTHER, OUT> Transformation<OUT> getJoinTransformation(KeyedPartitionStream<K, T_OTHER> other, TwoInputNonBroadcastStreamProcessFunction<V, T_OTHER, OUT> processFunction, TypeInformation<OUT> outTypeInfo) {
        ListStateDescriptor leftStateDesc = new ListStateDescriptor("join-left-state", this.getType());
        ListStateDescriptor rightStateDesc = new ListStateDescriptor("join-right-state", ((KeyedPartitionStreamImpl)other).getType());
        TwoInputNonBroadcastJoinProcessOperator joinProcessOperator = new TwoInputNonBroadcastJoinProcessOperator(processFunction, leftStateDesc, rightStateDesc);
        return StreamUtils.getTwoInputTransformation("Keyed-Join-Process", this, (KeyedPartitionStreamImpl)other, outTypeInfo, joinProcessOperator);
    }

    public TypeInformation<K> getKeyType() {
        return this.keyType;
    }

    public KeySelector<V, K> getKeySelector() {
        return this.keySelector;
    }

    public ProcessConfigurable<?> toSink(Sink<V> sink) {
        DataStreamV2SinkTransformation<V, V> sinkTransformation = StreamUtils.addSinkOperator(this, sink, this.getType());
        return StreamUtils.wrapWithConfigureHandle(new NonKeyedPartitionStreamImpl(this.environment, sinkTransformation));
    }

    public GlobalStream<V> global() {
        return new GlobalStreamImpl(this.environment, new PartitionTransformation(this.transformation, (StreamPartitioner)new GlobalPartitioner()));
    }

    public <NEW_KEY> KeyedPartitionStream<NEW_KEY, V> keyBy(KeySelector<V, NEW_KEY> keySelector) {
        return new KeyedPartitionStreamImpl<NEW_KEY, V>(this, keySelector);
    }

    public NonKeyedPartitionStream<V> shuffle() {
        return new NonKeyedPartitionStreamImpl(this.environment, new PartitionTransformation(this.getTransformation(), (StreamPartitioner)new ShufflePartitioner()));
    }

    public BroadcastStream<V> broadcast() {
        return new BroadcastStreamImpl(this.environment, this.getTransformation());
    }
}

