/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.stream;

import java.util.Collections;
import java.util.HashSet;
import org.apache.flink.api.common.state.StateDeclaration;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.datastream.api.function.TwoInputBroadcastStreamProcessFunction;
import org.apache.flink.datastream.api.stream.BroadcastStream;
import org.apache.flink.datastream.api.stream.KeyedPartitionStream;
import org.apache.flink.datastream.api.stream.NonKeyedPartitionStream;
import org.apache.flink.datastream.impl.ExecutionEnvironmentImpl;
import org.apache.flink.datastream.impl.attribute.AttributeParser;
import org.apache.flink.datastream.impl.operators.KeyedTwoInputBroadcastProcessOperator;
import org.apache.flink.datastream.impl.operators.TwoInputBroadcastProcessOperator;
import org.apache.flink.datastream.impl.stream.AbstractDataStream;
import org.apache.flink.datastream.impl.stream.KeyedPartitionStreamImpl;
import org.apache.flink.datastream.impl.stream.NonKeyedPartitionStreamImpl;
import org.apache.flink.datastream.impl.stream.ProcessConfigurableAndKeyedPartitionStreamImpl;
import org.apache.flink.datastream.impl.stream.ProcessConfigurableAndNonKeyedPartitionStreamImpl;
import org.apache.flink.datastream.impl.utils.StreamUtils;
import org.apache.flink.streaming.api.transformations.PartitionTransformation;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;
import org.apache.flink.streaming.runtime.partitioner.BroadcastPartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;

public class BroadcastStreamImpl<T>
extends AbstractDataStream<T>
implements BroadcastStream<T> {
    public BroadcastStreamImpl(ExecutionEnvironmentImpl environment, Transformation<T> transformation) {
        this(environment, new PartitionTransformation(transformation, (StreamPartitioner)new BroadcastPartitioner()));
    }

    private BroadcastStreamImpl(ExecutionEnvironmentImpl environment, PartitionTransformation<T> transformation) {
        super(environment, transformation);
    }

    public <K, T_OTHER, OUT> NonKeyedPartitionStream.ProcessConfigurableAndNonKeyedPartitionStream<OUT> connectAndProcess(KeyedPartitionStream<K, T_OTHER> other, TwoInputBroadcastStreamProcessFunction<T_OTHER, T, OUT> processFunction) {
        other = other instanceof ProcessConfigurableAndKeyedPartitionStreamImpl ? ((ProcessConfigurableAndKeyedPartitionStreamImpl)other).getKeyedPartitionStream() : other;
        TypeInformation<OUT> outTypeInfo = StreamUtils.getOutputTypeForTwoInputBroadcastProcessFunction(processFunction, ((KeyedPartitionStreamImpl)other).getType(), this.getType());
        KeyedTwoInputBroadcastProcessOperator processOperator = new KeyedTwoInputBroadcastProcessOperator(processFunction);
        TwoInputTransformation outTransformation = StreamUtils.getTwoInputTransformation("Broadcast-Keyed-TwoInput-Process", (KeyedPartitionStreamImpl)other, this, outTypeInfo, processOperator);
        outTransformation.setAttribute(AttributeParser.parseAttribute(processFunction));
        this.environment.addOperator((Transformation<?>)outTransformation);
        return StreamUtils.wrapWithConfigureHandle(new NonKeyedPartitionStreamImpl(this.environment, outTransformation));
    }

    public <T_OTHER, OUT> NonKeyedPartitionStream.ProcessConfigurableAndNonKeyedPartitionStream<OUT> connectAndProcess(NonKeyedPartitionStream<T_OTHER> other, TwoInputBroadcastStreamProcessFunction<T_OTHER, T, OUT> processFunction) {
        StreamUtils.validateStates(processFunction.usesStates(), new HashSet<StateDeclaration.RedistributionMode>(Collections.singletonList(StateDeclaration.RedistributionMode.NONE)));
        other = other instanceof ProcessConfigurableAndNonKeyedPartitionStreamImpl ? ((ProcessConfigurableAndNonKeyedPartitionStreamImpl)other).getNonKeyedPartitionStream() : other;
        TypeInformation<OUT> outTypeInfo = StreamUtils.getOutputTypeForTwoInputBroadcastProcessFunction(processFunction, ((NonKeyedPartitionStreamImpl)other).getType(), this.getType());
        TwoInputBroadcastProcessOperator<T_OTHER, T, OUT> processOperator = new TwoInputBroadcastProcessOperator<T_OTHER, T, OUT>(processFunction);
        TwoInputTransformation<T_OTHER, T, OUT> outTransformation = StreamUtils.getTwoInputTransformation("Broadcast-TwoInput-Process", (NonKeyedPartitionStreamImpl)other, this, outTypeInfo, processOperator);
        outTransformation.setAttribute(AttributeParser.parseAttribute(processFunction));
        this.environment.addOperator((Transformation<?>)outTransformation);
        return StreamUtils.wrapWithConfigureHandle(new NonKeyedPartitionStreamImpl(this.environment, outTransformation));
    }

    public <K, T_OTHER, OUT> KeyedPartitionStream.ProcessConfigurableAndKeyedPartitionStream<K, OUT> connectAndProcess(KeyedPartitionStream<K, T_OTHER> other, TwoInputBroadcastStreamProcessFunction<T_OTHER, T, OUT> processFunction, KeySelector<OUT, K> newKeySelector) {
        other = other instanceof ProcessConfigurableAndKeyedPartitionStreamImpl ? ((ProcessConfigurableAndKeyedPartitionStreamImpl)other).getKeyedPartitionStream() : other;
        TypeInformation<OUT> outTypeInfo = StreamUtils.getOutputTypeForTwoInputBroadcastProcessFunction(processFunction, ((KeyedPartitionStreamImpl)other).getType(), this.getType());
        KeyedTwoInputBroadcastProcessOperator processOperator = new KeyedTwoInputBroadcastProcessOperator(processFunction);
        TwoInputTransformation outTransformation = StreamUtils.getTwoInputTransformation("Broadcast-Keyed-TwoInput-Process", (KeyedPartitionStreamImpl)other, this, outTypeInfo, processOperator);
        NonKeyedPartitionStreamImpl outputStream = new NonKeyedPartitionStreamImpl(this.environment, outTransformation);
        outTransformation.setAttribute(AttributeParser.parseAttribute(processFunction));
        this.environment.addOperator((Transformation<?>)outTransformation);
        return StreamUtils.wrapWithConfigureHandle(new KeyedPartitionStreamImpl(outputStream, outTransformation, newKeySelector, TypeExtractor.getKeySelectorTypes(newKeySelector, outputStream.getType())));
    }
}

