/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.extension.window.context;

import java.util.Optional;
import java.util.Set;
import org.apache.flink.api.common.state.AggregatingStateDeclaration;
import org.apache.flink.api.common.state.ListStateDeclaration;
import org.apache.flink.api.common.state.MapStateDeclaration;
import org.apache.flink.api.common.state.ReducingStateDeclaration;
import org.apache.flink.api.common.state.StateDeclaration;
import org.apache.flink.api.common.state.ValueStateDeclaration;
import org.apache.flink.api.common.state.v2.AggregatingState;
import org.apache.flink.api.common.state.v2.AggregatingStateDescriptor;
import org.apache.flink.api.common.state.v2.ListState;
import org.apache.flink.api.common.state.v2.ListStateDescriptor;
import org.apache.flink.api.common.state.v2.MapState;
import org.apache.flink.api.common.state.v2.MapStateDescriptor;
import org.apache.flink.api.common.state.v2.ReducingState;
import org.apache.flink.api.common.state.v2.ReducingStateDescriptor;
import org.apache.flink.api.common.state.v2.StateDescriptor;
import org.apache.flink.api.common.state.v2.ValueState;
import org.apache.flink.api.common.state.v2.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.datastream.api.extension.window.function.WindowProcessFunction;
import org.apache.flink.runtime.asyncprocessing.operators.AbstractAsyncStateStreamOperator;
import org.apache.flink.runtime.state.v2.adaptor.AggregatingStateAdaptor;
import org.apache.flink.runtime.state.v2.adaptor.ListStateAdaptor;
import org.apache.flink.runtime.state.v2.adaptor.MapStateAdaptor;
import org.apache.flink.runtime.state.v2.adaptor.ReducingStateAdaptor;
import org.apache.flink.runtime.state.v2.adaptor.ValueStateAdaptor;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowStateStore<K, W extends Window> {
    private static final Logger LOG = LoggerFactory.getLogger(WindowStateStore.class);
    private final Set<StateDeclaration> windowStateDeclarations;
    private final AbstractAsyncStateStreamOperator<?> operator;
    private final TypeSerializer<W> windowSerializer;
    private final boolean isMergingWindow;

    public WindowStateStore(WindowProcessFunction windowProcessFunction, AbstractAsyncStateStreamOperator<?> operator, TypeSerializer<W> windowSerializer, boolean isMergingWindow) {
        this.windowStateDeclarations = windowProcessFunction.useWindowStates();
        this.operator = operator;
        this.windowSerializer = windowSerializer;
        this.isMergingWindow = isMergingWindow;
    }

    private boolean isStateDeclared(StateDeclaration stateDeclaration) {
        if (!this.windowStateDeclarations.contains(stateDeclaration)) {
            LOG.warn("Fail to get window state for " + stateDeclaration.getName() + ", please declare the used state in the `WindowProcessFunction#useWindowStates` method first.");
            return false;
        }
        return true;
    }

    private boolean stateRedistributionModeIsNotNone(StateDeclaration stateDeclaration) {
        StateDeclaration.RedistributionMode redistributionMode = stateDeclaration.getRedistributionMode();
        return redistributionMode != StateDeclaration.RedistributionMode.NONE;
    }

    public <T> Optional<ListState<T>> getWindowState(ListStateDeclaration<T> stateDeclaration, W namespace) throws Exception {
        Preconditions.checkState((!this.isMergingWindow ? 1 : 0) != 0, (Object)"Retrieving the window state is not permitted when using merging windows, such as session windows.");
        if (!this.isStateDeclared((StateDeclaration)stateDeclaration)) {
            return Optional.empty();
        }
        if (this.stateRedistributionModeIsNotNone((StateDeclaration)stateDeclaration)) {
            throw new UnsupportedOperationException("RedistributionMode " + stateDeclaration.getRedistributionMode().name() + " is not supported for window state.");
        }
        ListStateDescriptor stateDescriptor = new ListStateDescriptor(stateDeclaration.getName(), TypeExtractor.createTypeInfo((Class)stateDeclaration.getTypeDescriptor().getTypeClass()));
        ListStateAdaptor state = (ListStateAdaptor)this.operator.getOrCreateKeyedState(namespace, this.windowSerializer, (StateDescriptor)stateDescriptor);
        state.setCurrentNamespace(namespace);
        return Optional.of(state);
    }

    public <KEY, V> Optional<MapState<KEY, V>> getWindowState(MapStateDeclaration<KEY, V> stateDeclaration, W namespace) throws Exception {
        Preconditions.checkState((!this.isMergingWindow ? 1 : 0) != 0, (Object)"Retrieving the window state is not permitted when using merging windows, such as session windows.");
        if (!this.isStateDeclared((StateDeclaration)stateDeclaration)) {
            return Optional.empty();
        }
        if (this.stateRedistributionModeIsNotNone((StateDeclaration)stateDeclaration)) {
            throw new UnsupportedOperationException("RedistributionMode " + stateDeclaration.getRedistributionMode().name() + " is not supported for window state.");
        }
        MapStateDescriptor stateDescriptor = new MapStateDescriptor(stateDeclaration.getName(), TypeExtractor.createTypeInfo((Class)stateDeclaration.getKeyTypeDescriptor().getTypeClass()), TypeExtractor.createTypeInfo((Class)stateDeclaration.getValueTypeDescriptor().getTypeClass()));
        MapStateAdaptor state = (MapStateAdaptor)this.operator.getOrCreateKeyedState(namespace, this.windowSerializer, (StateDescriptor)stateDescriptor);
        state.setCurrentNamespace(namespace);
        return Optional.of(state);
    }

    public <T> Optional<ValueState<T>> getWindowState(ValueStateDeclaration<T> stateDeclaration, W namespace) throws Exception {
        Preconditions.checkState((!this.isMergingWindow ? 1 : 0) != 0, (Object)"Retrieving the window state is not permitted when using merging windows, such as session windows.");
        if (!this.isStateDeclared((StateDeclaration)stateDeclaration)) {
            return Optional.empty();
        }
        if (this.stateRedistributionModeIsNotNone((StateDeclaration)stateDeclaration)) {
            throw new UnsupportedOperationException("RedistributionMode " + stateDeclaration.getRedistributionMode().name() + " is not supported for window state.");
        }
        ValueStateDescriptor stateDescriptor = new ValueStateDescriptor(stateDeclaration.getName(), TypeExtractor.createTypeInfo((Class)stateDeclaration.getTypeDescriptor().getTypeClass()));
        ValueStateAdaptor state = (ValueStateAdaptor)this.operator.getOrCreateKeyedState(namespace, this.windowSerializer, (StateDescriptor)stateDescriptor);
        state.setCurrentNamespace(namespace);
        return Optional.of(state);
    }

    public <T> Optional<ReducingState<T>> getWindowState(ReducingStateDeclaration<T> stateDeclaration, W namespace) throws Exception {
        Preconditions.checkState((!this.isMergingWindow ? 1 : 0) != 0, (Object)"Retrieving the window state is not permitted when using merging windows, such as session windows.");
        if (!this.isStateDeclared((StateDeclaration)stateDeclaration)) {
            return Optional.empty();
        }
        if (this.stateRedistributionModeIsNotNone((StateDeclaration)stateDeclaration)) {
            throw new UnsupportedOperationException("RedistributionMode " + stateDeclaration.getRedistributionMode().name() + " is not supported for window state.");
        }
        ReducingStateDescriptor stateDescriptor = new ReducingStateDescriptor(stateDeclaration.getName(), stateDeclaration.getReduceFunction(), TypeExtractor.createTypeInfo((Class)stateDeclaration.getTypeDescriptor().getTypeClass()));
        ReducingStateAdaptor state = (ReducingStateAdaptor)this.operator.getOrCreateKeyedState(namespace, this.windowSerializer, (StateDescriptor)stateDescriptor);
        state.setCurrentNamespace(namespace);
        return Optional.of(state);
    }

    public <T, ACC, OUT> Optional<AggregatingState<T, OUT>> getWindowState(AggregatingStateDeclaration<T, ACC, OUT> stateDeclaration, W namespace) throws Exception {
        Preconditions.checkState((!this.isMergingWindow ? 1 : 0) != 0, (Object)"Retrieving the window state is not permitted when using merging windows, such as session windows.");
        if (!this.isStateDeclared((StateDeclaration)stateDeclaration)) {
            return Optional.empty();
        }
        if (this.stateRedistributionModeIsNotNone((StateDeclaration)stateDeclaration)) {
            throw new UnsupportedOperationException("RedistributionMode " + stateDeclaration.getRedistributionMode().name() + " is not supported for window state.");
        }
        AggregatingStateDescriptor stateDescriptor = new AggregatingStateDescriptor(stateDeclaration.getName(), stateDeclaration.getAggregateFunction(), TypeExtractor.createTypeInfo((Class)stateDeclaration.getTypeDescriptor().getTypeClass()));
        AggregatingStateAdaptor state = (AggregatingStateAdaptor)this.operator.getOrCreateKeyedState(namespace, this.windowSerializer, (StateDescriptor)stateDescriptor);
        state.setCurrentNamespace(namespace);
        return Optional.of(state);
    }
}

