/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.extension.window.context;

import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.api.common.state.AggregatingStateDeclaration;
import org.apache.flink.api.common.state.ListStateDeclaration;
import org.apache.flink.api.common.state.MapStateDeclaration;
import org.apache.flink.api.common.state.ReducingStateDeclaration;
import org.apache.flink.api.common.state.ValueStateDeclaration;
import org.apache.flink.api.common.state.v2.AggregatingState;
import org.apache.flink.api.common.state.v2.AppendingState;
import org.apache.flink.api.common.state.v2.ListState;
import org.apache.flink.api.common.state.v2.MapState;
import org.apache.flink.api.common.state.v2.ReducingState;
import org.apache.flink.api.common.state.v2.StateIterator;
import org.apache.flink.api.common.state.v2.ValueState;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.datastream.api.extension.window.context.OneInputWindowContext;
import org.apache.flink.datastream.api.extension.window.function.WindowProcessFunction;
import org.apache.flink.datastream.impl.extension.window.context.WindowStateStore;
import org.apache.flink.runtime.asyncprocessing.operators.AbstractAsyncStateStreamOperator;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.streaming.api.windowing.windows.Window;

public class DefaultOneInputWindowContext<K, IN, W extends Window>
implements OneInputWindowContext<IN> {
    @Nullable
    private W window;
    private final WindowStateStore<K, W> windowStateStore;
    private final AppendingState<IN, StateIterator<IN>, Iterable<IN>> windowState;

    public DefaultOneInputWindowContext(@Nullable W window, AppendingState<IN, StateIterator<IN>, Iterable<IN>> windowState, WindowProcessFunction windowProcessFunction, AbstractAsyncStateStreamOperator<?> operator, TypeSerializer<W> windowSerializer, boolean isMergingWindow) {
        this.window = window;
        this.windowState = windowState;
        this.windowStateStore = new WindowStateStore(windowProcessFunction, operator, windowSerializer, isMergingWindow);
    }

    public void setWindow(W window) {
        this.window = window;
    }

    public long getStartTime() {
        if (this.window instanceof TimeWindow) {
            return ((TimeWindow)this.window).getStart();
        }
        return -1L;
    }

    public long getEndTime() {
        if (this.window instanceof TimeWindow) {
            return ((TimeWindow)this.window).getEnd();
        }
        return -1L;
    }

    public <T> Optional<ListState<T>> getWindowState(ListStateDeclaration<T> stateDeclaration) throws Exception {
        return this.windowStateStore.getWindowState(stateDeclaration, this.window);
    }

    public <KEY, V> Optional<MapState<KEY, V>> getWindowState(MapStateDeclaration<KEY, V> stateDeclaration) throws Exception {
        return this.windowStateStore.getWindowState(stateDeclaration, this.window);
    }

    public <T> Optional<ValueState<T>> getWindowState(ValueStateDeclaration<T> stateDeclaration) throws Exception {
        return this.windowStateStore.getWindowState(stateDeclaration, this.window);
    }

    public <T> Optional<ReducingState<T>> getWindowState(ReducingStateDeclaration<T> stateDeclaration) throws Exception {
        return this.windowStateStore.getWindowState(stateDeclaration, this.window);
    }

    public <T, ACC, OUT> Optional<AggregatingState<T, OUT>> getWindowState(AggregatingStateDeclaration<T, ACC, OUT> stateDeclaration) throws Exception {
        return this.windowStateStore.getWindowState(stateDeclaration, this.window);
    }

    public void putRecord(IN record) {
        this.windowState.add(record);
    }

    public Iterable<IN> getAllRecords() {
        return (Iterable)this.windowState.get();
    }
}

