/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.stream;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.apache.flink.api.common.state.StateDeclaration;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.connector.dsv2.Sink;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.functions.NullByteKeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.datastream.api.extension.window.strategy.GlobalWindowStrategy;
import org.apache.flink.datastream.api.function.OneInputStreamProcessFunction;
import org.apache.flink.datastream.api.function.TwoInputBroadcastStreamProcessFunction;
import org.apache.flink.datastream.api.function.TwoInputNonBroadcastStreamProcessFunction;
import org.apache.flink.datastream.api.function.TwoOutputStreamProcessFunction;
import org.apache.flink.datastream.api.stream.BroadcastStream;
import org.apache.flink.datastream.api.stream.GlobalStream;
import org.apache.flink.datastream.api.stream.KeyedPartitionStream;
import org.apache.flink.datastream.api.stream.NonKeyedPartitionStream;
import org.apache.flink.datastream.api.stream.ProcessConfigurable;
import org.apache.flink.datastream.impl.ExecutionEnvironmentImpl;
import org.apache.flink.datastream.impl.attribute.AttributeParser;
import org.apache.flink.datastream.impl.extension.window.function.InternalOneInputWindowStreamProcessFunction;
import org.apache.flink.datastream.impl.extension.window.function.InternalTwoInputWindowStreamProcessFunction;
import org.apache.flink.datastream.impl.extension.window.function.InternalTwoOutputWindowStreamProcessFunction;
import org.apache.flink.datastream.impl.operators.ProcessOperator;
import org.apache.flink.datastream.impl.operators.TwoInputBroadcastProcessOperator;
import org.apache.flink.datastream.impl.operators.TwoInputNonBroadcastProcessOperator;
import org.apache.flink.datastream.impl.operators.TwoOutputProcessOperator;
import org.apache.flink.datastream.impl.stream.AbstractDataStream;
import org.apache.flink.datastream.impl.stream.BroadcastStreamImpl;
import org.apache.flink.datastream.impl.stream.GlobalStreamImpl;
import org.apache.flink.datastream.impl.stream.KeyedPartitionStreamImpl;
import org.apache.flink.datastream.impl.stream.ProcessConfigurableAndNonKeyedPartitionStreamImpl;
import org.apache.flink.datastream.impl.stream.ProcessConfigurableAndTwoNonKeyedPartitionStreamImpl;
import org.apache.flink.datastream.impl.utils.StreamUtils;
import org.apache.flink.streaming.api.transformations.DataStreamV2SinkTransformation;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.api.transformations.PartitionTransformation;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;
import org.apache.flink.streaming.runtime.partitioner.GlobalPartitioner;
import org.apache.flink.streaming.runtime.partitioner.ShufflePartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;

public class NonKeyedPartitionStreamImpl<T>
extends AbstractDataStream<T>
implements NonKeyedPartitionStream<T> {
    public NonKeyedPartitionStreamImpl(ExecutionEnvironmentImpl environment, Transformation<T> transformation) {
        super(environment, transformation);
    }

    public <OUT> NonKeyedPartitionStream.ProcessConfigurableAndNonKeyedPartitionStream<OUT> process(OneInputStreamProcessFunction<T, OUT> processFunction) {
        OneInputTransformation outputTransform;
        StreamUtils.validateStates(processFunction.usesStates(), new HashSet<StateDeclaration.RedistributionMode>(Arrays.asList(StateDeclaration.RedistributionMode.NONE, StateDeclaration.RedistributionMode.IDENTICAL)));
        TypeInformation<OUT> outType = StreamUtils.getOutputTypeForOneInputProcessFunction(processFunction, this.getType());
        if (processFunction instanceof InternalOneInputWindowStreamProcessFunction) {
            InternalOneInputWindowStreamProcessFunction internalProcessFunction = (InternalOneInputWindowStreamProcessFunction)processFunction;
            Preconditions.checkState((boolean)(internalProcessFunction.getWindowStrategy() instanceof GlobalWindowStrategy), (Object)"Only the Global Window is permitted for execution in NonKeyedPartitionStream.");
            outputTransform = (OneInputTransformation)StreamUtils.transformOneInputWindow(this.environment.getExecutionConfig(), this, this.getType(), outType, (InternalOneInputWindowStreamProcessFunction)processFunction, new NullByteKeySelector(), Types.BYTE);
        } else {
            ProcessOperator<T, OUT> operator = new ProcessOperator<T, OUT>(processFunction);
            outputTransform = StreamUtils.getOneInputTransformation("Process", this, outType, operator);
        }
        outputTransform.setAttribute(AttributeParser.parseAttribute(processFunction));
        this.environment.addOperator((Transformation<?>)outputTransform);
        return StreamUtils.wrapWithConfigureHandle(new NonKeyedPartitionStreamImpl<T>(this.environment, outputTransform));
    }

    public <OUT1, OUT2> NonKeyedPartitionStream.ProcessConfigurableAndTwoNonKeyedPartitionStream<OUT1, OUT2> process(TwoOutputStreamProcessFunction<T, OUT1, OUT2> processFunction) {
        OneInputTransformation outTransformation;
        StreamUtils.validateStates(processFunction.usesStates(), new HashSet<StateDeclaration.RedistributionMode>(Arrays.asList(StateDeclaration.RedistributionMode.NONE, StateDeclaration.RedistributionMode.IDENTICAL)));
        Tuple2<TypeInformation<OUT1>, TypeInformation<OUT2>> twoOutputType = StreamUtils.getOutputTypesForTwoOutputProcessFunction(processFunction, this.getType());
        TypeInformation firstOutputType = (TypeInformation)twoOutputType.f0;
        TypeInformation secondOutputType = (TypeInformation)twoOutputType.f1;
        OutputTag secondOutputTag = new OutputTag("Second-Output", secondOutputType);
        if (processFunction instanceof InternalTwoOutputWindowStreamProcessFunction) {
            InternalTwoOutputWindowStreamProcessFunction internalProcessFunction = (InternalTwoOutputWindowStreamProcessFunction)processFunction;
            Preconditions.checkState((boolean)(internalProcessFunction.getWindowStrategy() instanceof GlobalWindowStrategy), (Object)"Only the Global Window is permitted for execution in NonKeyedPartitionStream.");
            outTransformation = (OneInputTransformation)StreamUtils.transformTwoOutputWindow(this.environment.getExecutionConfig(), this, this.getType(), firstOutputType, secondOutputType, secondOutputTag, (InternalTwoOutputWindowStreamProcessFunction)processFunction, new NullByteKeySelector(), Types.BYTE);
        } else {
            TwoOutputProcessOperator<T, OUT1, OUT2> operator = new TwoOutputProcessOperator<T, OUT1, OUT2>(processFunction, secondOutputTag);
            outTransformation = StreamUtils.getOneInputTransformation("Two-Output-Operator", this, firstOutputType, operator);
        }
        outTransformation.setAttribute(AttributeParser.parseAttribute(processFunction));
        NonKeyedPartitionStreamImpl<T> firstStream = new NonKeyedPartitionStreamImpl<T>(this.environment, outTransformation);
        NonKeyedPartitionStreamImpl secondStream = new NonKeyedPartitionStreamImpl(this.environment, firstStream.getSideOutputTransform(secondOutputTag));
        this.environment.addOperator((Transformation<?>)outTransformation);
        return new ProcessConfigurableAndTwoNonKeyedPartitionStreamImpl(this.environment, outTransformation, firstStream, secondStream);
    }

    public <T_OTHER, OUT> NonKeyedPartitionStream.ProcessConfigurableAndNonKeyedPartitionStream<OUT> connectAndProcess(NonKeyedPartitionStream<T_OTHER> other, TwoInputNonBroadcastStreamProcessFunction<T, T_OTHER, OUT> processFunction) {
        TwoInputTransformation<T, T_OTHER, OUT> outTransformation;
        StreamUtils.validateStates(processFunction.usesStates(), new HashSet<StateDeclaration.RedistributionMode>(Arrays.asList(StateDeclaration.RedistributionMode.NONE, StateDeclaration.RedistributionMode.IDENTICAL)));
        other = other instanceof ProcessConfigurableAndNonKeyedPartitionStreamImpl ? ((ProcessConfigurableAndNonKeyedPartitionStreamImpl)other).getNonKeyedPartitionStream() : other;
        TypeInformation<OUT> outTypeInfo = StreamUtils.getOutputTypeForTwoInputNonBroadcastProcessFunction(processFunction, this.getType(), ((NonKeyedPartitionStreamImpl)other).getType());
        if (processFunction instanceof InternalTwoInputWindowStreamProcessFunction) {
            InternalTwoInputWindowStreamProcessFunction internalWindowFunction = (InternalTwoInputWindowStreamProcessFunction)processFunction;
            Preconditions.checkState((boolean)(internalWindowFunction.getWindowStrategy() instanceof GlobalWindowStrategy), (Object)"Only the Global Window is permitted for execution in NonKeyedPartitionStream.");
            outTransformation = StreamUtils.transformTwoInputNonBroadcastWindow(this.environment.getExecutionConfig(), this.transformation, this.getType(), ((NonKeyedPartitionStreamImpl)other).getTransformation(), ((NonKeyedPartitionStreamImpl)other).getType(), outTypeInfo, internalWindowFunction, new NullByteKeySelector(), Types.BYTE, new NullByteKeySelector(), Types.BYTE);
        } else {
            TwoInputNonBroadcastProcessOperator<T, T_OTHER, OUT> processOperator = new TwoInputNonBroadcastProcessOperator<T, T_OTHER, OUT>(processFunction);
            outTransformation = StreamUtils.getTwoInputTransformation("TwoInput-Process", this, (NonKeyedPartitionStreamImpl)other, outTypeInfo, processOperator);
        }
        outTransformation.setAttribute(AttributeParser.parseAttribute(processFunction));
        this.environment.addOperator((Transformation<?>)outTransformation);
        return StreamUtils.wrapWithConfigureHandle(new NonKeyedPartitionStreamImpl<T>(this.environment, outTransformation));
    }

    public <T_OTHER, OUT> NonKeyedPartitionStream.ProcessConfigurableAndNonKeyedPartitionStream<OUT> connectAndProcess(BroadcastStream<T_OTHER> other, TwoInputBroadcastStreamProcessFunction<T, T_OTHER, OUT> processFunction) {
        StreamUtils.validateStates(processFunction.usesStates(), new HashSet<StateDeclaration.RedistributionMode>(Collections.singletonList(StateDeclaration.RedistributionMode.NONE)));
        TypeInformation<OUT> outTypeInfo = StreamUtils.getOutputTypeForTwoInputBroadcastProcessFunction(processFunction, this.getType(), ((BroadcastStreamImpl)other).getType());
        TwoInputBroadcastProcessOperator<T, T_OTHER, OUT> processOperator = new TwoInputBroadcastProcessOperator<T, T_OTHER, OUT>(processFunction);
        TwoInputTransformation<T, T_OTHER, OUT> outTransformation = StreamUtils.getTwoInputTransformation("Broadcast-TwoInput-Process", this, (BroadcastStreamImpl)other, outTypeInfo, processOperator);
        outTransformation.setAttribute(AttributeParser.parseAttribute(processFunction));
        this.environment.addOperator((Transformation<?>)outTransformation);
        return StreamUtils.wrapWithConfigureHandle(new NonKeyedPartitionStreamImpl<T>(this.environment, outTransformation));
    }

    public ProcessConfigurable<?> toSink(Sink<T> sink) {
        DataStreamV2SinkTransformation<T, T> sinkTransformation = StreamUtils.addSinkOperator(this, sink, this.getType());
        return StreamUtils.wrapWithConfigureHandle(new NonKeyedPartitionStreamImpl<T>(this.environment, sinkTransformation));
    }

    public GlobalStream<T> global() {
        return new GlobalStreamImpl(this.environment, new PartitionTransformation(this.transformation, (StreamPartitioner)new GlobalPartitioner()));
    }

    public <K> KeyedPartitionStream<K, T> keyBy(KeySelector<T, K> keySelector) {
        return new KeyedPartitionStreamImpl<K, T>(this, keySelector);
    }

    public NonKeyedPartitionStream<T> shuffle() {
        return new NonKeyedPartitionStreamImpl<T>(this.environment, new PartitionTransformation(this.getTransformation(), (StreamPartitioner)new ShufflePartitioner()));
    }

    public BroadcastStream<T> broadcast() {
        return new BroadcastStreamImpl(this.environment, this.getTransformation());
    }
}

