/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.watermark;

import java.util.Map;
import org.apache.flink.api.common.watermark.Watermark;
import org.apache.flink.api.common.watermark.WatermarkManager;
import org.apache.flink.runtime.event.WatermarkEvent;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.runtime.watermark.AbstractInternalWatermarkDeclaration;
import org.apache.flink.util.Preconditions;

public class DefaultWatermarkManager
implements WatermarkManager {
    private final Output<?> streamRecordOutput;
    private final Map<String, AbstractInternalWatermarkDeclaration<?>> watermarkDeclarationMap;

    public DefaultWatermarkManager(Output<?> streamRecordOutput, Map<String, AbstractInternalWatermarkDeclaration<?>> watermarkDeclarationMap) {
        this.streamRecordOutput = streamRecordOutput;
        this.watermarkDeclarationMap = watermarkDeclarationMap;
    }

    public void emitWatermark(Watermark watermark) {
        Preconditions.checkState((boolean)this.watermarkDeclarationMap.containsKey(watermark.getIdentifier()), (Object)("Watermark identifier " + watermark.getIdentifier() + " does not exist, please declare it."));
        this.streamRecordOutput.emitWatermark(new WatermarkEvent(watermark, this.watermarkDeclarationMap.get(watermark.getIdentifier()).isAligned()));
    }
}

