/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.operators;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.datastream.api.context.NonPartitionedContext;
import org.apache.flink.datastream.api.function.TwoInputNonBroadcastStreamProcessFunction;
import org.apache.flink.datastream.impl.common.KeyCheckedOutputCollector;
import org.apache.flink.datastream.impl.common.OutputCollector;
import org.apache.flink.datastream.impl.common.TimestampCollector;
import org.apache.flink.datastream.impl.context.DefaultNonPartitionedContext;
import org.apache.flink.datastream.impl.operators.TwoInputNonBroadcastProcessOperator;

public class BaseKeyedTwoInputNonBroadcastProcessOperator<KEY, IN1, IN2, OUT>
extends TwoInputNonBroadcastProcessOperator<IN1, IN2, OUT> {
    protected transient Set<Object> keySet;
    @Nullable
    protected final KeySelector<OUT, KEY> outKeySelector;

    public BaseKeyedTwoInputNonBroadcastProcessOperator(TwoInputNonBroadcastStreamProcessFunction<IN1, IN2, OUT> userFunction) {
        this(userFunction, null);
    }

    public BaseKeyedTwoInputNonBroadcastProcessOperator(TwoInputNonBroadcastStreamProcessFunction<IN1, IN2, OUT> userFunction, @Nullable KeySelector<OUT, KEY> outKeySelector) {
        super(userFunction);
        this.outKeySelector = outKeySelector;
    }

    @Override
    public void open() throws Exception {
        this.keySet = new HashSet<Object>();
        super.open();
    }

    @Override
    protected TimestampCollector<OUT> getOutputCollector() {
        return this.outKeySelector == null ? new OutputCollector(this.output) : new KeyCheckedOutputCollector(new OutputCollector(this.output), this.outKeySelector, () -> this.getCurrentKey());
    }

    @Override
    protected Object currentKey() {
        return this.getCurrentKey();
    }

    @Override
    protected NonPartitionedContext<OUT> getNonPartitionedContext() {
        return new DefaultNonPartitionedContext(this.context, this.partitionedContext, this.collector, true, this.keySet, this.output, this.watermarkDeclarationMap);
    }

    public void newKeySelected(Object newKey) {
        this.keySet.add(newKey);
    }

    @Override
    public boolean isAsyncStateProcessingEnabled() {
        return true;
    }
}

