/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.stream;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.dsv2.Sink;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.datastream.api.function.OneInputStreamProcessFunction;
import org.apache.flink.datastream.api.function.TwoInputBroadcastStreamProcessFunction;
import org.apache.flink.datastream.api.function.TwoInputNonBroadcastStreamProcessFunction;
import org.apache.flink.datastream.api.function.TwoOutputStreamProcessFunction;
import org.apache.flink.datastream.api.stream.BroadcastStream;
import org.apache.flink.datastream.api.stream.GlobalStream;
import org.apache.flink.datastream.api.stream.KeyedPartitionStream;
import org.apache.flink.datastream.api.stream.NonKeyedPartitionStream;
import org.apache.flink.datastream.impl.ExecutionEnvironmentImpl;
import org.apache.flink.datastream.impl.operators.ProcessOperator;
import org.apache.flink.datastream.impl.operators.TwoInputBroadcastProcessOperator;
import org.apache.flink.datastream.impl.operators.TwoInputNonBroadcastProcessOperator;
import org.apache.flink.datastream.impl.operators.TwoOutputProcessOperator;
import org.apache.flink.datastream.impl.stream.AbstractDataStream;
import org.apache.flink.datastream.impl.stream.BroadcastStreamImpl;
import org.apache.flink.datastream.impl.stream.GlobalStreamImpl;
import org.apache.flink.datastream.impl.stream.KeyedPartitionStreamImpl;
import org.apache.flink.datastream.impl.utils.StreamUtils;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.api.transformations.PartitionTransformation;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;
import org.apache.flink.streaming.runtime.partitioner.GlobalPartitioner;
import org.apache.flink.streaming.runtime.partitioner.ShufflePartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.util.OutputTag;

public class NonKeyedPartitionStreamImpl<T>
extends AbstractDataStream<T>
implements NonKeyedPartitionStream<T> {
    public NonKeyedPartitionStreamImpl(ExecutionEnvironmentImpl environment, Transformation<T> transformation) {
        super(environment, transformation);
    }

    public <OUT> NonKeyedPartitionStream<OUT> process(OneInputStreamProcessFunction<T, OUT> processFunction) {
        TypeInformation<OUT> outType = StreamUtils.getOutputTypeForOneInputProcessFunction(processFunction, this.getType());
        ProcessOperator<T, OUT> operator = new ProcessOperator<T, OUT>(processFunction);
        OneInputTransformation<T, OUT> outputTransform = StreamUtils.getOneInputTransformation("Process", this, outType, operator);
        this.environment.addOperator((Transformation<?>)outputTransform);
        return new NonKeyedPartitionStreamImpl<T>(this.environment, outputTransform);
    }

    public <OUT1, OUT2> NonKeyedPartitionStream.TwoNonKeyedPartitionStreams<OUT1, OUT2> process(TwoOutputStreamProcessFunction<T, OUT1, OUT2> processFunction) {
        Tuple2<TypeInformation<OUT1>, TypeInformation<OUT2>> twoOutputType = StreamUtils.getOutputTypesForTwoOutputProcessFunction(processFunction, this.getType());
        TypeInformation firstOutputType = (TypeInformation)twoOutputType.f0;
        TypeInformation secondOutputType = (TypeInformation)twoOutputType.f1;
        OutputTag secondOutputTag = new OutputTag("Second-Output", secondOutputType);
        TwoOutputProcessOperator<T, OUT1, OUT2> operator = new TwoOutputProcessOperator<T, OUT1, OUT2>(processFunction, secondOutputTag);
        OneInputTransformation outTransformation = StreamUtils.getOneInputTransformation("Two-Output-Operator", this, firstOutputType, operator);
        NonKeyedPartitionStreamImpl<T> firstStream = new NonKeyedPartitionStreamImpl<T>(this.environment, outTransformation);
        NonKeyedPartitionStreamImpl secondStream = new NonKeyedPartitionStreamImpl(this.environment, firstStream.getSideOutputTransform(secondOutputTag));
        this.environment.addOperator((Transformation<?>)outTransformation);
        return TwoNonKeyedPartitionStreamsImpl.of(firstStream, secondStream);
    }

    public <T_OTHER, OUT> NonKeyedPartitionStream<OUT> connectAndProcess(NonKeyedPartitionStream<T_OTHER> other, TwoInputNonBroadcastStreamProcessFunction<T, T_OTHER, OUT> processFunction) {
        TypeInformation<OUT> outTypeInfo = StreamUtils.getOutputTypeForTwoInputNonBroadcastProcessFunction(processFunction, this.getType(), ((NonKeyedPartitionStreamImpl)other).getType());
        TwoInputNonBroadcastProcessOperator<T, T_OTHER, OUT> processOperator = new TwoInputNonBroadcastProcessOperator<T, T_OTHER, OUT>(processFunction);
        TwoInputTransformation<T, T_OTHER, OUT> outTransformation = StreamUtils.getTwoInputTransformation("TwoInput-Process", this, (NonKeyedPartitionStreamImpl)other, outTypeInfo, processOperator);
        this.environment.addOperator((Transformation<?>)outTransformation);
        return new NonKeyedPartitionStreamImpl<T>(this.environment, outTransformation);
    }

    public <T_OTHER, OUT> NonKeyedPartitionStream<OUT> connectAndProcess(BroadcastStream<T_OTHER> other, TwoInputBroadcastStreamProcessFunction<T, T_OTHER, OUT> processFunction) {
        TypeInformation<OUT> outTypeInfo = StreamUtils.getOutputTypeForTwoInputBroadcastProcessFunction(processFunction, this.getType(), ((BroadcastStreamImpl)other).getType());
        TwoInputBroadcastProcessOperator<T, T_OTHER, OUT> processOperator = new TwoInputBroadcastProcessOperator<T, T_OTHER, OUT>(processFunction);
        TwoInputTransformation<T, T_OTHER, OUT> outTransformation = StreamUtils.getTwoInputTransformation("Broadcast-TwoInput-Process", this, (BroadcastStreamImpl)other, outTypeInfo, processOperator);
        this.environment.addOperator((Transformation<?>)outTransformation);
        return new NonKeyedPartitionStreamImpl<T>(this.environment, outTransformation);
    }

    public void toSink(Sink<T> sink) {
        StreamUtils.addSinkOperator(this, sink, this.getType());
    }

    public GlobalStream<T> global() {
        return new GlobalStreamImpl(this.environment, new PartitionTransformation(this.transformation, (StreamPartitioner)new GlobalPartitioner()));
    }

    public <K> KeyedPartitionStream<K, T> keyBy(KeySelector<T, K> keySelector) {
        return new KeyedPartitionStreamImpl<K, T>(this, keySelector);
    }

    public NonKeyedPartitionStream<T> shuffle() {
        return new NonKeyedPartitionStreamImpl<T>(this.environment, new PartitionTransformation(this.getTransformation(), (StreamPartitioner)new ShufflePartitioner()));
    }

    public BroadcastStream<T> broadcast() {
        return new BroadcastStreamImpl(this.environment, this.getTransformation());
    }

    static class TwoNonKeyedPartitionStreamsImpl<OUT1, OUT2>
    implements NonKeyedPartitionStream.TwoNonKeyedPartitionStreams<OUT1, OUT2> {
        private final NonKeyedPartitionStream<OUT1> firstStream;
        private final NonKeyedPartitionStream<OUT2> secondStream;

        public static <OUT1, OUT2> TwoNonKeyedPartitionStreamsImpl<OUT1, OUT2> of(NonKeyedPartitionStreamImpl<OUT1> firstStream, NonKeyedPartitionStreamImpl<OUT2> secondStream) {
            return new TwoNonKeyedPartitionStreamsImpl<OUT1, OUT2>(firstStream, secondStream);
        }

        private TwoNonKeyedPartitionStreamsImpl(NonKeyedPartitionStreamImpl<OUT1> firstStream, NonKeyedPartitionStreamImpl<OUT2> secondStream) {
            this.firstStream = firstStream;
            this.secondStream = secondStream;
        }

        public NonKeyedPartitionStream<OUT1> getFirst() {
            return this.firstStream;
        }

        public NonKeyedPartitionStream<OUT2> getSecond() {
            return this.secondStream;
        }
    }
}

