/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.operators;

import org.apache.flink.datastream.api.context.RuntimeContext;
import org.apache.flink.datastream.api.context.TwoOutputNonPartitionedContext;
import org.apache.flink.datastream.api.function.TwoOutputStreamProcessFunction;
import org.apache.flink.datastream.impl.common.OutputCollector;
import org.apache.flink.datastream.impl.common.TimestampCollector;
import org.apache.flink.datastream.impl.context.DefaultRuntimeContext;
import org.apache.flink.datastream.impl.context.DefaultTwoOutputNonPartitionedContext;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.OutputTag;

public class TwoOutputProcessOperator<IN, OUT_MAIN, OUT_SIDE>
extends AbstractUdfStreamOperator<OUT_MAIN, TwoOutputStreamProcessFunction<IN, OUT_MAIN, OUT_SIDE>>
implements OneInputStreamOperator<IN, OUT_MAIN>,
BoundedOneInput {
    protected transient TimestampCollector<OUT_MAIN> mainCollector;
    protected transient TimestampCollector<OUT_SIDE> sideCollector;
    protected transient DefaultRuntimeContext context;
    protected transient TwoOutputNonPartitionedContext<OUT_MAIN, OUT_SIDE> nonPartitionedContext;
    protected OutputTag<OUT_SIDE> outputTag;

    public TwoOutputProcessOperator(TwoOutputStreamProcessFunction<IN, OUT_MAIN, OUT_SIDE> userFunction, OutputTag<OUT_SIDE> outputTag) {
        super(userFunction);
        this.outputTag = outputTag;
        this.chainingStrategy = ChainingStrategy.ALWAYS;
    }

    public void open() throws Exception {
        this.mainCollector = this.getMainCollector();
        this.sideCollector = this.getSideCollector();
        this.context = new DefaultRuntimeContext();
        this.nonPartitionedContext = new DefaultTwoOutputNonPartitionedContext<OUT_MAIN, OUT_SIDE>();
    }

    public void processElement(StreamRecord<IN> element) throws Exception {
        this.mainCollector.setTimestampFromStreamRecord(element);
        this.sideCollector.setTimestampFromStreamRecord(element);
        ((TwoOutputStreamProcessFunction)this.userFunction).processRecord(element.getValue(), this.mainCollector, this.sideCollector, (RuntimeContext)this.context);
    }

    public void endInput() throws Exception {
        ((TwoOutputStreamProcessFunction)this.userFunction).endInput(this.nonPartitionedContext);
    }

    protected TimestampCollector<OUT_MAIN> getMainCollector() {
        return new OutputCollector(this.output);
    }

    public TimestampCollector<OUT_SIDE> getSideCollector() {
        return new SideOutputCollector(this.output);
    }

    protected class SideOutputCollector
    extends TimestampCollector<OUT_SIDE> {
        private final Output<StreamRecord<OUT_MAIN>> output;

        public SideOutputCollector(Output<StreamRecord<OUT_MAIN>> output) {
            this.output = output;
        }

        public void collect(OUT_SIDE outputRecord) {
            this.output.collect(TwoOutputProcessOperator.this.outputTag, this.reuse.replace(outputRecord));
        }

        public void collectAndOverwriteTimestamp(OUT_SIDE record, long timestamp) {
            this.setTimestamp(timestamp);
            this.output.collect(TwoOutputProcessOperator.this.outputTag, this.reuse.replace(record));
        }
    }
}

